/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "prototypes.h"
#include <assert.h>
#include <tcl.h>
#include <tk.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>


extern Tcl_Interp *interp;
extern user_data me;
extern char hostname[];
extern char vanityname[];
/* added for this terminals identification purposes */
extern char os_version[];
extern char nt_version[];
/* end of additions */
p_list plist;
int cur_timeout;
int cur_inactive_timeout;
int keep_participants = 0;


void init_participant_list(p_list * pl, u_int8 col)
{

    char str[3 * (MAX_SESSION_NAME_LEN + 1)];
    char *str_ptr;
    char *str_ptr2;
    int str_len;

    pl->no_of_participants = 0;
    pl->first_participant = NULL;
    pl->last_participant = NULL;

    if (strcmp(vanityname, "") == 0) {
	/*assert(strlen(me.username) + strlen(hostname) < 30);                    // removed - Jim */
	sprintf(str, "%s@%s", me.username, hostname);
    } else
	sprintf(str, "%s", vanityname);


/* additions to set our nte and os version correctly */
    /* the following section of code can be removed without any connotations. */

    /* using the 'protocol.c' session message method - which we know does work.. */
    str_ptr = str;
    str_ptr2 = str;

    str_len = strlen(str) + 1;
    str_ptr2 = str_ptr + str_len;

    strcpy(str_ptr2, nt_version);

    str_len += strlen(nt_version) + 1;
    str_ptr2 = str_ptr + str_len;

    strcpy(str_ptr2, os_version);

/* end of additions. */

    add_receiver_to_participants(&me, str_ptr, col, NULL);
    cur_timeout = 160;
    cur_inactive_timeout = 16;
}

void add_receiver_to_participants(user_data * ud,
				  char name[],
				  u_int8 col,
				  struct timeval *t)
{
    participant *pt;
    pt = get_participant(ud, &plist);
    if (pt == NULL) {
	char str[30];
	add_participant(ud, name, col, t, &plist);
	Tcl_SetVar(interp, "c_str", name, 0);
	sprintf(str, "add_participant %d", col);
	Tcl_Eval(interp, str);
    } else {
	int pnum;
	if (t != NULL)
	    pt->time = t->tv_sec;
	if (pt->status == GREY) {
	    char str[30];
	    pt->status = ACTIVE;
	    pnum = get_participant_number(ud, &plist);
	    sprintf(str, "activate_participant %d", pnum);
	    Tcl_Eval(interp, str);
	}
	if (pt->col != col) {
	    char str[30];
	    pnum = get_participant_number(ud, &plist);
	    sprintf(str, "uncolour_participant %d %d", pnum, pt->col);
	    Tcl_Eval(interp, str);
	    pt->col = col;
	    sprintf(str, "colour_participant %d %d", pnum, col);
	    Tcl_Eval(interp, str);
	}
    }
}

void rm_receiver_from_participants(user_data * ud)
{
    participant *pt;
    int pnum;
    char str[24];
    if (keep_participants == TRUE)
	return;			/* don't adjust list if */

    /* user has specified to keep a */

    /* complete list of all participants */
    pt = get_participant(ud, &plist);
    if (pt == NULL) {
	return;
    }
    pnum = get_participant_number(ud, &plist);
    rm_participant(pt, &plist);
    if (pnum != -1) {
	sprintf(str, "rm_participant %d", pnum);
	Tcl_Eval(interp, str);
    }
}

void reset_participants()
{
    participant *pt = plist.first_participant;
    while (pt != NULL) {
	pt = get_participant_by_number(1, &plist);
	if (pt != NULL)
	    rm_receiver_from_participants(&(pt->ud));
    }
}

int get_conf_size()
{
    return plist.no_of_participants;
}

int keep_userlist(int flag)
{
    keep_participants = flag;
    return 0;
}

void timeout_participants()
{
    participant *pt, *ptnext;
    struct timeval t;
    struct timezone tzp;
    int pnum = 0;
    if (plist.first_participant == NULL)	/* if no participants then end procedure? */
	return;


    gettimeofday(&t, &tzp);
    pt = plist.first_participant;
    while (pt != NULL) {
	ptnext = pt->next_participant;
	if (pt->time != 0) {
	    if ((t.tv_sec - pt->time) > (cur_timeout)) {
		rm_receiver_from_participants(&(pt->ud));
	    } else if ((t.tv_sec - pt->time) > (cur_inactive_timeout)) {
		char str[30];
		pt->status = GREY;
		sprintf(str, "deactivate_participant %d", pnum);
		Tcl_Eval(interp, str);
	    }
	}
	pt = ptnext;
	pnum++;
    }
}

participant *get_participant(user_data * ud, p_list * pl)
{
    participant *pt;
    if (pl == NULL)
	return NULL;		/* if no participant list. */
    if (pl->first_participant == NULL)
	return NULL;		/* if empty participant list */
    pt = pl->first_participant;
    while (pt != NULL) {	/* repeat for each participant */
	if ((ud->hostaddr.s_addr) == (pt->ud.hostaddr.s_addr))
	    if (strncmp((ud->username), (pt->ud.username), MAX_USER_NAME) == 0) {
		return pt;	/* match if host address and user name's are identical */
	    }			/*   between participant in memory and the search subject */
	pt = pt->next_participant;	/* check next participant for match */
    }
    return NULL;
}

participant *get_participant_by_number(int ix, p_list * pl)
{
    participant *pt;		/* end if participants list does not exist or if it is empty */
    if (pl == NULL)
	return NULL;
    if (pl->first_participant == NULL)
	return NULL;
    pt = pl->first_participant;
    while (pt != NULL) {	/* check through participant list, until you run out of participants *//* or you find the matching index number */
	if (ix == 0)
	    return pt;
	ix--;
	pt = pt->next_participant;
    }
    return NULL;		/* if participant ix does not exist, then return null */
}

int get_participant_number(user_data * ud, p_list * pl)
{
    participant *pt;
    int pnum = 0;
    if (pl == NULL)
	return -1;
    if (pl->first_participant == NULL)
	return -1;
    pt = pl->first_participant;
    while (pt != NULL) {
	if ((ud->hostaddr.s_addr) == (pt->ud.hostaddr.s_addr))
	    if (strncmp((ud->username), (pt->ud.username), MAX_USER_NAME) == 0) {
		return pnum;
	    }
	pt = pt->next_participant;
	pnum++;
    }
    return -1;
}

void add_participant(user_data * ud, char *name, u_int8 col,
		     struct timeval *t, p_list * pl)
{
    participant *pt;
    char *str;
    pt = (participant *) malloc(sizeof(participant));
    user_copy(ud, &(pt->ud));	/* copy user data into new participant pt */
    if (t != NULL)
	pt->time = t->tv_sec;
    else
	pt->time = 0;
    pt->col = col;		/* set participants colour */
    strncpy(pt->text_name, name, MAX_SESSION_NAME_LEN);		/* copy participant name */

    if (name[strlen(name) + 1] != '\0') {
	/*it's a new style session message */
	str = name + strlen(name) + 1;
	strncpy(pt->nt_version, str, MAX_SESSION_NAME_LEN);
	str += strlen(str) + 1;
	strncpy(pt->os_version, str, MAX_SESSION_NAME_LEN);
    } else {
	strcpy(pt->nt_version, "unknown");
	strcpy(pt->os_version, "unknown");
    }

    if (pl->first_participant == NULL) {
	pl->first_participant = pt;
	pt->prev_participant = NULL;
    } else {
	pl->last_participant->next_participant = pt;
	pt->prev_participant = pl->last_participant;
    }
    pt->next_participant = NULL;
    pt->status = ACTIVE;
    pl->last_participant = pt;
    pl->no_of_participants++;
}

void rm_participant(participant * pt, p_list * pl)
{
    if (pl->first_participant == pt) {
	pl->first_participant = pt->next_participant;
    }
    if (pl->last_participant == pt) {
	pl->last_participant = pt->prev_participant;
    }
    if (pt->next_participant != NULL) {
	pt->next_participant->prev_participant = pt->prev_participant;
    }
    if (pt->prev_participant != NULL) {
	pt->prev_participant->next_participant = pt->next_participant;
    }
    pl->no_of_participants--;
    free(pt);
}

void save_participants(FILE * file, p_list * pl)
{
    participant *pt;
    fprintf(file, "Participants:\n------------\n");
    if (pl == NULL)
	return;
    if (pl->first_participant == NULL)
	return;
    pt = pl->first_participant;
    while (pt != NULL) {
	fprintf(file, "  %s (%s@%s)\n", pt->text_name, pt->ud.username, inet_ntoa(pt->ud.hostaddr));
	pt = pt->next_participant;
    }
    fprintf(file, "------------\n\n");
}
