/***************************************************************************
                          fixedspinbox.cpp  -  a spinbox for fixed numbers
                             -------------------                                         
    begin                : Tue Sep 28 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include <math.h>
#include "fixedspinbox.h"

FixedSpinBox::FixedSpinBox ( int minValue, int maxValue, int step = 1, unsigned fix = 2, QWidget * parent = 0, const char * name = 0 )
	: QSpinBox(minValue, maxValue, step, parent, name)
{
	fixed = fix;
	divisor = int(pow(10.0, double(fixed)));
	validator = new QDoubleValidator(double(minValue), double(maxValue), fixed, this, QString(name) + "Validator" );
	setValidator(validator);
}

FixedSpinBox::~FixedSpinBox()
{
	delete validator;
}

QString FixedSpinBox::mapValueToText ( int value )
{
	leftint = value / divisor;
	workstring = QString::number(leftint) + ".";
	rightstring = QString::number(value - (leftint * divisor));
	workstring += rightstring.rightJustify(fixed, '0', true);
	return workstring;
}

int FixedSpinBox::mapTextToValue ( bool * ok )
{
	workstring = cleanText();
	pos = workstring.find('.');
	if (pos >= 0) {
		leftint = workstring.left(pos).toInt();
		rightstring = workstring.right(workstring.length() - pos - 1);
		rightint = rightstring.leftJustify(fixed, '0', true).toInt();
		
	} else {
		leftint = workstring.toInt();
		rightint = 0;
	}
	return (leftint * divisor) + rightint;
}







