/***************************************************************************
                          grain.h  -  grain entry
                             -------------------                                         
    begin                : Sat Oct 9 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef GRAIN_H
#define GRAIN_H

#include <qlistview.h>
#include <qmap.h>
#include <qstring.h>

enum { GRAIN_OTHER, GRAIN_MASHED, GRAIN_STEEPED, GRAIN_EXTRACT };

/**
  *@author David Johnson
  */
class Grain {
public:
	/** constructor */
	Grain();
	/** full constructor */
	Grain(const QString &gname, const unsigned &gquant, const unsigned &gextr, const unsigned &gcolor, const int &guse);
	/** copy constructor */
	Grain(const Grain &g);
	/** assignment operator */
	Grain operator=(const Grain &g);
	/** comparison operator */
	bool operator==(const Grain &g);
	/** destructor */
	~Grain();

	/** return name */
	QString getName();
	/** return quantity (in pounds) */
	unsigned getQuantity();
	/** return grain extract */
	unsigned getExtract();
	/** return grain color */
	unsigned getColor();
	/** return how grain is used (mash, steep, extract) */
	int getUse();
	/** return the yield (quantity times extract) */
	double getYield();
	/** return the HCU (quantity times color) */
	double getHCU();
		
	/** return quantity as string */
	QString getQuantityString();
	/** return extract as string */
	QString getExtractString();
	/** return color as string */
	QString getColorString();
	/** return use as string */
	QString getUseString();

	/** return a list of use strings */
	static QStringList getUseStringList();
	/** convert use string to enum */
	static int useStringToEnum(const QString &uname);
	
	/** return object as string, for serialization */
	QString serializeOut();
	/** set object to string, for serialization */
	void serializeIn(const QString &gname, const QString &gvalue);
	
private:
	/** format an UInt to fixed decimal */
	QString formatValue(const unsigned &value, const unsigned &fix);
					
private:
	QString name;
	unsigned quantity; // measured in pounds
	unsigned extract;
	unsigned color;
	int use;
	
	double yield;	// gravity yield for grain
	double hcu;		// color yield for grain
	
	unsigned divisor, leftuint;
	QString leftstring, rightstring;
};

typedef QValueList<Grain> GrainList;
typedef QValueList<Grain>::Iterator GrainIterator;

class GrainListItem : public QListViewItem {
public:
	/** constructor */
	GrainListItem(QListView * parent, QString, QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null, QString = QString::null,
			QString = QString::null, QString = QString::null );
	/** destructor */
	~GrainListItem();
	/** get iterator to Grain item */
	GrainIterator getGrainIterator();
	/** set iterator to Grain item */
	void setGrainIterator(GrainIterator &it);
	/** set grain to match iterator */
	void setToIterator();
private:
	GrainIterator git;
};

#endif // GRAIN_H












