/****************************************************************************
** helpwindow.cpp
**
** This file originated as part of an example program for Qt.  This
** file may be used, distributed and modified without limitation.
**
** Thanks to Troll Tech for their generosity in granting me permission to
** modify this class for the needs of my program - David Johnson
**
*****************************************************************************/

#include "helpwindow.h"
#include "home.xpm"
#include "back.xpm"
#include "forward.xpm"

#include <qstatusbar.h>
#include <qpixmap.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qiconset.h>
#include <qstylesheet.h>

HelpWindow::HelpWindow( const QString& home_, const QString& path, QWidget* parent, const char *name )
	: QMainWindow( parent, name, WDestructiveClose )
{

	browser = new QTextBrowser( this );
	browser->mimeSourceFactory()->setFilePath( path );
	browser->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    connect( browser, SIGNAL( textChanged() ), this, SLOT( textChanged() ) );

	setCentralWidget( browser );

	if ( !home_.isEmpty() )
		browser->setSource( home_ );

	connect( browser, SIGNAL( highlighted( const QString&) ), statusBar(), SLOT( message( const QString&)) );

	resize( 608,448 );

	QPopupMenu* file = new QPopupMenu( this );
	file->insertItem( tr("&Quit"), this, SLOT( close() ), ALT | Key_Q );

	QPopupMenu* go = new QPopupMenu( this );
	backwardId = go->insertItem( QPixmap(backxpm),
			tr("&Backward"), browser, SLOT( backward() ), ALT | Key_Left );
	forwardId = go->insertItem( QPixmap(forwardxpm),
			tr("&Forward"), browser, SLOT( forward() ), ALT | Key_Right );
	go->insertItem( QPixmap(homexpm), tr("&Home"), browser, SLOT( home() ) );

	menuBar()->insertItem( tr("&File"), file );
	menuBar()->insertItem( tr("&Go"), go );
	menuBar()->insertSeparator();

	menuBar()->setItemEnabled( forwardId, FALSE);
	menuBar()->setItemEnabled( backwardId, FALSE);
	connect( browser, SIGNAL( backwardAvailable( bool ) ), this, SLOT( setBackwardAvailable( bool ) ) );
    connect( browser, SIGNAL( forwardAvailable( bool ) ), this, SLOT( setForwardAvailable( bool ) ) );


	QToolBar* toolbar = new QToolBar( this );
	addToolBar( toolbar, "Toolbar");
	QToolButton* button;

	button = new QToolButton( QPixmap(backxpm), tr("Backward"), "", browser, SLOT(backward()), toolbar );
	connect( browser, SIGNAL( backwardAvailable(bool) ), button, SLOT( setEnabled(bool) ) );
	button->setEnabled( FALSE );
	button = new QToolButton( QPixmap(forwardxpm), tr("Forward"), "", browser, SLOT(forward()), toolbar );
	connect( browser, SIGNAL( forwardAvailable(bool) ), button, SLOT( setEnabled(bool) ) );
	button->setEnabled( FALSE );
	button = new QToolButton( QPixmap(homexpm), tr("Home"), "", browser, SLOT(home()), toolbar );

	browser->setFocus();
}


void HelpWindow::setBackwardAvailable( bool b)
{
	menuBar()->setItemEnabled( backwardId, b);
}

void HelpWindow::setForwardAvailable( bool b)
{
	menuBar()->setItemEnabled( forwardId, b);
}


void HelpWindow::textChanged()
{
    if ( browser->documentTitle().isNull() )
		setCaption( "QBrew " + tr("Help") + " - " + browser->context() );
	else
		setCaption( "QBrew " + tr("Help") + " - " + browser->documentTitle() ) ;
}

HelpWindow::~HelpWindow()
{
}



