/***************************************************************************
                          qbrew.h  -  a brewing recipe calculator
                             -------------------
    begin                : September 20th, 1999
    copyright            : (C) 1999 by David Johnson
    email                : arandir@meer.net

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#ifndef QBREW_H
#define QBREW_H

// include files for QT
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qmenubar.h>
#include <qtoolbar.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qtoolbutton.h>
#include <qapp.h>
#include <qstatusbar.h>
#include <qwhatsthis.h>
#include <qmsgbox.h>
#include <qfiledialog.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qstylesheet.h>

// application specific includes
#include "resource.h"
#include "qbrewview.h"
#include "qbrewdoc.h"
#include "qbrewcalc.h"
#include "helpwindow.h"
#include "settings.h"

/**
  * This Class is the base class for QBrew. It sets up the main
  * frame window and provides a menubar, toolbar and statusbar.
  * The client view is an instance of class QBrewView.
  */
class QBrew : public QMainWindow
{
	Q_OBJECT
  
public:
	/** constructor */
	QBrew();
	/** destructor */
	~QBrew();
	
	/** initializes the menubar */
	void initMenuBar();
	/** initializes the toolbar */
	void initToolBar();
	/** initialize the statusbar */
	void initStatusBar();
	/** initialize the client document */
	void initDoc();
	/** initialize the calculations class */
	void initCalc();
	/** initialize the client view */
	void initView();
	/** initialize the XML styles */
	void initStyles();
	/** initialize the application settings */
	void initSettings();

	/** Message box to ask save file first */
	int querySave();
	
	/** get default batch size */
	unsigned getBatchSetting();
	
	/** return recipe as an ascii string */
	QString getRecipeText();

public slots:
	/** switch argument for Statusbar help entries on slot selection */
	void statusCallback(int id_);
	/** temporarily change the status message of the statusbar */
	void slotStatusHelpMsg(const char *text);
	/** receives if view widgets have changed */
	void slotDocumentModified();

	/** generate a new document */
	void slotFileNew();
	/** open a document */
	void slotFileOpen();
	/** save a document */
	void slotFileSave();
	/** save a document under a different filename*/
	void slotFileSaveAs();
	/** print the document */
	void slotFilePrint();
	/** exits the application */
	void slotFileQuit();
	
	/** put the marked text/object into the clipboard and delete */
	void slotEditCut();
	/** put the marked text/object into the clipboard */
	void slotEditCopy();
	/** paste the clipboard into the document */
	void slotEditPaste();
	
	/** toggle the toolbar */
	void slotOptionsToolBar();
	/** toggle the statusbar */
	void slotOptionsStatusBar();
	/** display the setup dialog */
	void slotOptionsSetup();
 	/** save settings */
	void slotOptionsSaveSettings();

	/** displays help contents */
	void slotHelpContents();
	/** shows an about dlg for Qt */
	void slotHelpAboutQt();
	/** shows an about dlg for QBrew */
	void slotHelpAbout();

private:

	/** the main widget which represents the client document. */
	QBrewView *view;
	/** doc represents the client document */
	QBrewDoc *doc;
	/** calc is a pointer to the calculations class */
	QBrewCalc *calc;

	/** file_menu contains all items of the menubar entry "File" */
	QPopupMenu *file_menu;
	/** edit_menu contains all items of the menubar entry "Edit" */
	QPopupMenu *edit_menu;
	/** view_menu contains all items of the menubar entry "View" */
	QPopupMenu *options_menu;
	/** view_menu contains all items of the menubar entry "Help" */
	QPopupMenu *help_menu;
  
	/** the main toolbar */
	QToolBar *main_toolbar;

	QStyleSheetItem *qmlStyle;		// default style sheet
	Settings *settings;				// application settings
	QString filename;				// name of file
	QPrinter printer;				// printer object so that settings are static
};
#endif 





























