/***************************************************************************
                          settings.cpp  -  settings for QBrew
                             -------------------                                         
    begin                : September 22nd 1999
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include "resource.h"
#include "settings.h"
#include "store.h"

Settings::Settings()
{
}

Settings::~Settings()
{
}

void Settings::insertSetting(const QString &name, const QString &value)
{
	map.replace(name, value);
}

const QString Settings::retrieveSetting(const QString &name)
{
	if (!map[name].isEmpty())
		return map[name];
	else
		return IDS_NULL;
}

bool Settings::saveSettings(const QString &filename, const QString &appname)
{
	Store *ofile = new Store(IO_WriteOnly, filename, appname);
	if ( !ofile->good() ) {
		// couldn't open file
		warning(IDS_TITLE + QObject::tr(": couldn't save settings to ") + filename);
		return false;
	}

	ofile->putGroup("Settings");
	// iterate through dictionary and write pairs
	QMap<QString, QString>::Iterator it;
	for (it = map.begin(); it != map.end(); it++) {
		ofile->putLine(it.key(), it.data());
	}
	// close the file
	delete ofile;
	return true;
}

bool Settings::loadSettings(const QString &filename, const QString &appname)	
{
    QString name, value;

    Store *ifile = new Store(IO_ReadOnly, filename, appname);
	if ( !ifile->good() ) {
		// couldn't open file
		warning(IDS_TITLE + QObject::tr(": couldn't read settings from ") + filename);
		return false;
	}

	while ( ifile->getLine() ) {
		if (ifile->getName() != ifile->getGroup())
			insertSetting(ifile->getName(), ifile->getValue());
	}

	delete ifile;
	return true;
}

















































