/***************************************************************************
                          style.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Sep 26 1999                                           
    copyright            : (C) 1999 by David Johnson                         
    email                : arandir@meer.net                                     

    This software licensed under the Berkeley Software Distribution License
 ***************************************************************************/

#include <qstringlist.h>
#include "style.h"

Style::Style()
{
	// setup with default values
	OGlow = 0;
	OGhi = 100;
	IBUlow = 0;
	IBUhi = 100;
	SRMlow = 1;
	SRMhi = 40;
}

Style::Style(const unsigned &oglow, const unsigned &oghi,
			const unsigned &ibulow, const unsigned &ibuhi,
			const unsigned &srmlow, const unsigned &srmhi)
{
	OGlow = oglow; OGhi = oghi;
	IBUlow = ibulow; IBUhi = ibuhi;
	SRMlow = srmlow; SRMhi = srmhi;
}
				
Style::Style(const Style &s)
{
	OGlow = s.OGlow; OGhi = s.OGhi;
	IBUlow = s.IBUlow; IBUhi = s.IBUhi;
	SRMlow = s.SRMlow; SRMhi = s.SRMhi;
}

Style Style::operator=(const Style &s)
{
	OGlow = s.OGlow; OGhi = s.OGhi;
	IBUlow = s.IBUlow; IBUhi = s.IBUhi;
	SRMlow = s.SRMlow; SRMhi = s.SRMhi;
	return *this;
}

Style::~Style() {}

///////////////////////////////////////////////////////////////////////////////
// member access routines

unsigned Style::getOGHi() { return OGhi; }

unsigned Style::getOGLow() { return OGlow; }

unsigned Style::getIBUHi() { return IBUhi; }

unsigned Style::getIBULow() { return IBUlow; }

unsigned Style::getSRMHi() { return SRMhi; }

unsigned Style::getSRMLow() { return SRMlow; }
	
///////////////////////////////////////////////////////////////////////////////
// serialization routines

QString Style::serializeOut()
{
	QString text;
	text = QString::number(OGlow) + ", " + QString::number(OGhi) + ", ";
	text += QString::number(IBUlow) + ", " + QString::number(IBUhi) + ", ";
	text += QString::number(SRMlow) + ", " + QString::number(SRMhi) + ", ";
	return text;
}

void Style::serializeIn(const QString &s)
{
	QString value = s;
	QStringList tokens;
	int pos;
	
	// get tokens
	while (value.length() > 0) {
		pos = value.find(',');
		if (pos > 0) {
			tokens += value.left(pos);
			value.remove(0, pos+1);
			value = value.stripWhiteSpace();
		} else {
			// get last token
			tokens += value;
			value = "";
		}
	}
	// create new style
	OGlow	= tokens[0].toUInt();
	OGhi	= tokens[1].toUInt();
	IBUlow	= tokens[2].toUInt();
	IBUhi	= tokens[3].toUInt();
	SRMlow	= tokens[4].toUInt();
	SRMhi	= tokens[5].toUInt();
}




