// 
// $Id: qaregexpmatch.hpp,v 1.3 1999/07/19 02:36:55 amos Exp $
//
// Definition of QaRegExpMatch class
//
// Jan Borsodi <amos@ez.no>
// Created on: <15-Jul-1999 13:53:16 amos>
//

#ifndef QAREGEXPMATCH_HPP
#define QAREGEXPMATCH_HPP

#include "qaregexprange.hpp"
#include <regex.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvaluelist.h>

class QaRegExpMatch
{
public:
    QaRegExpMatch();
    QaRegExpMatch( const QString &s );
    QaRegExpMatch( const QString &s, const regmatch_t m[], int size );
    ~QaRegExpMatch();

    void appendMatch( const QaRegExpRange &r );
    const QStringList &toString();
    const QString &toString( int o );

    const QaRegExpRange &operator[]( int o ) const;

private:
    QValueList<QaRegExpRange> Matches;
    QArray<bool> Calc;
    QStringList List;
    QString String;
};


#endif // QAREGEXPMATCH_HPP
