/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef IO_H
#define IO_H

#include "commun.h"

typedef struct _DirList DirList;

struct _DirList {
  int size;
  struct elements_ {
    char *name;
    int mode;
  } *elements;
} ;

extern int exec_it(char **args);
extern void exec_it_and_mem(char **args, char *msg);
extern int exec_it_and_wait(char **args);
extern DirList dir_list_with_suffix(char *dir, char *suffix);
extern void dir_list_toggle_sort_type();
extern void dir_list_free(DirList l);
extern boolean stat_it(char *file, int *mode);
extern boolean is_directory(char *dir);
extern boolean is_file(char *name);
extern char *absolute2relative(char *src, char *base);
extern boolean any_child_left();
extern void kill_children_left();
extern void update_views();
extern void received_sigchild();
extern void received_child_ended(int pid, int status);

extern void paste(char *dir_prefix);

#endif
