/* sfm -- Simple File Manager
   Copyright (C) 1998 Pixel (Pascal Rigaux)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */
#ifndef SFM_VIEW_H
#define SFM_VIEW_H

#include "sfm_doc.h"
#include "textlist.h"




typedef struct _SfmView SfmView;

struct Widgets { 
  GtkWidget *window, *frame, *list, *statusbar, *dir, *labeldir, *framedir, *dialog, *entry; 
};

struct _SfmView {
  SfmDoc *doc;
  TextList *list;
  char *Xselection;
  char *statusbar;
  gint statusbarTimeoutId;

  struct Widgets widgets;
  GdkColor colors[nb_ls_colors];

  char *startingWord;
  gint startingWordTimeoutId;

  int status;
  gint event_signal_handler;
};

typedef void (*an_action)(SfmView *view);



extern SfmView *sfm_view_new(int number, int *argc, char ***argv);
extern void sfm_view_free(SfmView *view);
extern void sfm_view_do_it(an_action f);

#endif
