#---------------------------------------------------------------------

namespace eval stderr {
    variable errInfo

    array set errInfo {
	index 0
    }
}

# stderr::log --
#
#   Method to insert an error message in the LW.  This object should
#   be used instead of any type of modal/non-modal popup dialog.
#
# Args
#
#   errcode - Code representing the error message to display.
#   msg     - Additional message to the user to go with the standard
#             error message for the errcode.
#
#   The first digit in the errcode has the following structure.
#
#   Digit         Comment
#   -----         ------------------------------
#     0           Errors from the CC
#     1           Warnings from the CC
#     2           Errors for a Registry item
#     3           Warnings for a Registry item
#     4           Errors from a file
#     5           Warnings from a file
#     6           Errors from invoking help
#     7           Warnings for invoking help
#
#   The last 3 digits of the errcode are the available sequence
#   numbers.  Here is a sample error table:
#
#   errcode       Definition
#   -------       ------------------------------
#     0101        CC error number 101
#     1101        CC warning number 101
#     2101        Registry error number 101
#     3101        Registry warning number 101
#     4101        File error number 101
#     5101        File warning ...
#     6101        Browser error number 101
#     7101        Browser warning ...
#
# Returns
#
#   None

proc stderr::log { errcode {msg ""} } {
    global tkWorld
    variable errInfo

    # Define the message and image type based on the error code.
    set x error_img
    switch $errcode {
	0001 {
	    set errmsg "Error: No Command.\n\tDid you acidentally\
		    click on the lightning bolt?"
	}
	0002 {
	    set errmsg "Error: Command Failure.\n\t$msg"
	}
	0003 {
	    set errmsg "Error: Write permission failure\n\t$msg"
	}
	0004 {
	    set errmsg "Error: File delete failure\n\t$msg"
	}
	0005 {
	    set errmsg "Error: Cannot create dir\n\t$msg"
	}
	1001 {
	    set errmsg "Warning: No Output."
	    set x warning_img
	}
	2001 {
	    set errmsg "Error: Find cannot move files and copy files\
		    at the same time"
	}
	3001 {
	    set errmsg "Warning: Null Regular Expression\n\t\
		    This is allowed but it will return every line\
		    from every file that is on the command line."
	    set x warning_img
	}
	3002 {
	    set errmsg "Warning: Null Target\n\t\
		    This is allowed but it will work on the first\
		    listed target in $msg."
	    set x warning_img
	}
	4001 {
	    set errmsg "Error: File Entry Empty.\n\tNo filename\
		    given in the highlighted entry."
	}
	4002 {
	    # Use msg to communicate the filename.
	    set errmsg "Error: File Open Error."
	    if [string length $msg] {
		append errmsg "\n\tCould not open file $msg. Check to\
			make sure you are trying to open the right file."
	    }
	}
	4003 {
	    set errmsg "Error: Not Directory"
	    if [string length $msg] {
		append errmsg "\n\t$msg is not a directory"
	    }
	}
	4004 {
	    set errmsg "Error: File Does Not Exist"
	    if [string length $msg] {
		append errmsg "\n\t$msg could not be found.  Are you\
			sure you typed in the correct filename?"
	    }
	}
	6001 {
	    set errmsg "Error: Netscape not loaded on this machine"
	    if [string length $msg] {
		append errmsg "\n\tthe site $msg could not be opened"
	    }
	}
	6002 {
	    set errmsg "Error: Could not start Netscape"
	    if [string length $msg] {
		append errmsg "\n\tThe site $msg could not be opened"
	    }
	}
    }

    # Warn the user of any errors.
    bell

    # Create the label with the working directory as its text.
    set l [label $tkWorld(log_window).stderr_label[incr errInfo(index)] \
	    -text "tkWorld Error..." \
	    -anchor w \
	    -foreground #ffffff \
	    -background #000000 \
	    -width [$tkWorld(log_window) cget -width]]

    # Put the label in the LW.
    $tkWorld(log_window) window create end \
	    -window $l \
	    -padx 0 \
	    -pady 10

    # Display the error message in the LW.
    $tkWorld(log_window) insert end "\n$errmsg\n"

    # Put the LW at the end.
    $tkWorld(log_window) see end

    # Make the LW toobar buttons work.
    toolbar::group_state log_window active
}
