/*
 * Browser vrml
 *
 * Philippe Dax
 * Fev 1998
 */

#include "global.h"
#include "mc.h"
#include "browsers.h"

#ifdef WITHVRML

/* global variable */
int vrmltool = WEBSPACE_TOOL;
int vrmlpid = -1;

void startvrml(char *url)
{
	trace(DBG_TOOL, "vrmltool=%d url=%s", vrmltool, url);
	if (vrmltool == WEBSPACE_TOOL)
		startwebspace("webspace", url);
	if (vrmltool == VRWEB_TOOL)
		startvrweb("vrweb", url);
	else trace(DBG_TOOL, "unknown browser");
}

void startwebspace(char *name, char *url)
{
#ifdef WITHWEBSPACE
	char openurl[128];

	vrmlpid = fork();
	switch (vrmlpid) {
	case -1:
		trace(DBG_TOOL, "can't fork for %s", name);
		break;
	case 0:
		execl(WEBSPACEPATH, name, url, (char *) NULL);
		trace(DBG_TOOL, "can't exec %s", name);
		exit(1);
	default:
		break;
	}
#endif
}

void startvrweb(char *name, char *url)
{
#ifdef WITHVRWEB
	char openurl[URL_LEN];

	vrmlpid = fork();
	switch (vrmlpid) {
	case -1:
		trace(DBG_TOOL, "can't fork for %s", name);
		break;
	case 0:
		execl(VRWEBPATH, name, url, (char *) NULL);
		trace(DBG_TOOL, "can't exec %s", name);
		exit(1);
	default:
		break;
	}
#endif
}

void quitvrml()
{
	if (vrmlpid > 0) {
		kill(vrmlpid, SIGKILL);
		vrmlpid = -1;
	}
}


#endif /* WITHVRML */
