#include "global.h"
#include "net_shm.h"


/******************************************/
/*** Gestion des noms et des proprietes ***/
/******************************************/

/* petite fonction pour fabriquer une chaine lisible a partir d'un nom */
Public
char *
nameByID(NetObjectId noid)
{
  static char str[80];

#ifdef WITH_SSRC
  sprintf(str, "%lx/%lx/%x/%d",
    ntohl(noid.ssrc_id), ntohl(noid.host_id), ntohs(noid.port_id), ntohs(noid.obj_id));
#else
  sprintf(str, "%lx/%x/%d",
    ntohl(noid.host_id), ntohs(noid.port_id), ntohs(noid.obj_id));
#endif
  return str;
}

/* return 0 if differents, other if equals */
Public
int equalNetObjectId(NetObjectId n1, NetObjectId n2)
{
  return    n1.host_id == n2.host_id
         && n1.port_id == n2.port_id
         && n1.obj_id == n2.obj_id;
}

/* get an object by name, NULL if not found */
Public
NetObject *
getNetObjectId(NetObjectId noid)
{
  NetObject *pnoh;

  for (pnoh = objects_list; 
      pnoh != NULL && !equalNetObjectId(pnoh->noid, noid); 
      pnoh = pnoh->next) {
    assert(pnoh->next == NULL || pnoh->next->prev == pnoh);
    assert(pnoh->prev == NULL || pnoh->prev->next == pnoh);
    assert(pnoh->prev || pnoh == objects_list);
  }
  return pnoh;
}

#ifdef WITH_SSRC
/* get an object by SSRC */
Public
NetObject *
getObjectBySSRC(u_int32 ssrc)
{
  NetObject *pnoh;

  for (pnoh = objects_list; 
      pnoh != NULL && pnoh->noid.ssrc_id != ssrc;
      pnoh = pnoh->next) {
	;
  }
  return pnoh;
}
#endif

/* insert object en head of NetObject list */
Public
void insertNetObject(NetObject *pnoh)
{
  assert(pnoh);
  if (pnoh->next = objects_list)
    objects_list->prev = pnoh;
  objects_list = pnoh;
  pnoh->prev = NULL;  
}

/* initialise la gestion des responsabilites (0=non, 1=oui)
 * Les dates passent par resetDates
 * param "responsible" est copie dans le champ de meme nom
 */
Public
void initProperties(NetObject *pnoh, u_int8 responsible)
{
  int i;
  u_int8 n;

  assert(pnoh); assert(! pnoh->prop);
  n = countProperties(pnoh->type);
  pnoh->prop = (Property *) malloc(n * sizeof(Property));
  assert(pnoh->prop);
  memset(pnoh->prop, 0, n * sizeof(Property));
  for (i = 0; i < n; i++) {
    Property *pprop = pnoh->prop + i;
    pprop->responsible = responsible;
    pprop->version = 0;
    resetDates(pprop);
  }
}

/* Cree un nouveau nom d'objet et baptise ainsi l'objet 
 * Des la sortie, on peut faire un getNetObjectId
 * et des declareDelta. Un declareCreationToNetwork
 * est souhaitable apres, des que les props sont init
 * dans le wmgt
 */
Public
void createNetObject(NetObject *pnoh, u_int8 perm)
{
  assert(pnoh);
  if (pnoh->noid.host_id != 0 || pnoh->next != NULL) {
    warning("createNetObject: already named object");
    return;
  }
#ifdef WITH_SSRC
  pnoh->noid.ssrc_id = my_ssrcid;
#endif
  pnoh->noid.host_id = my_hostid;
  pnoh->noid.port_id = my_portid;
  pnoh->noid.obj_id = htons(new_objectid++);
  pnoh->permanent = perm;
  insertNetObject(pnoh);
  initProperties(pnoh, 1); /* new: then we are responsible */
#ifdef WITH_SSRC
  if (pnoh->s)
    warning("createNetObject: already sourced");
  else
    pnoh->s = (source *) malloc(sizeof(source));
  /* init_seq(pnoh->s, rtp_seq); */
#endif
}

/* fabrique un nom d'objet a partir de la chaine, format
 * "scene_id/obj_id", tous deux u_int16>0.
 * Des la sortie, on peut faire un getNetObjectId
 * et des declareDelta.
 * Le format "scene_id/obj_id" est "prive'"
 */
Public
void createNetObjectFromString(NetObject *pnoh, const char *s, u_int8 perm)
{
  u_int16 scene_id, obj_id;
  int c;

  assert(pnoh); assert(s);
  if (pnoh->noid.host_id != 0 || pnoh->next != NULL) {
    warning("createNetObjectFromString: already named object");
    return;
  }
  c = sscanf(s, "%hu/%hu", &scene_id, &obj_id);
  if (c != 2 || scene_id <= 0 || obj_id <= 0) {
    warning("createNetObjectFromString: invalid namefromstring %s", (char *)s);
    return;
  }
  pnoh->noid.host_id = htonl(1); 
  pnoh->noid.port_id = htons(scene_id);
  pnoh->noid.obj_id = htons(obj_id);
  if (getNetObjectId(pnoh->noid) != NULL) {
    warning("createNetObjectFromString: already seen %d/%d", scene_id, obj_id);
    return;
  }
  pnoh->permanent = perm;  /* perm should be == 1 */
  insertNetObject(pnoh);
  initProperties(pnoh, 0); /* 0 == we are not responsible */
}

/*
 * delete an object from the list
 * free properties
 * Exported to wmgt
 */
Public
void deleteNetObject(NetObject *pnoh)
{
  assert(pnoh);
  if (getNetObjectId(pnoh->noid) == NULL) {
    warning("deleteNetObject: already unnamed/deleted object %d", pnoh->type);
    return;
  }
  if (pnoh->prev)
    pnoh->prev->next = pnoh->next;
  else {
    assert(pnoh == objects_list);
    objects_list = pnoh->next;
  }
  if (pnoh->next)
    pnoh->next->prev = pnoh->prev;
  pnoh->next = NULL;
  pnoh->prev = NULL;
  memset(&(pnoh->noid), 0, sizeof(pnoh->noid));
  free(pnoh->prop); 
#ifdef OLD_SSRC
  free(pnoh->s); 
#endif
  pnoh->prop = NULL;
}

