#include "global.h"
#include "parse.h"
#include "audio.h"
#include "net_global.h"


/* cell parser */
Private
void cellParser(char *l, WObject *pcell)
{
  char *w;

  w = parseFileLine(l);
  w = parsePosition(w, pcell);
  strcpy(pcell->ext.cell.chanin, w); w = strtok(NULL, SEP);
  strcpy(pcell->ext.cell.chanout, w); w = strtok(NULL, SEP);
  pcell->soh = SolidParser(w);
}

/* cell creation from file */
Private
void cellCreateFromFile(Fileline l)
{
  WObject *pcell;

  pcell = (WObject*) malloc(sizeof(WObject));
  memset(pcell, 0, sizeof(WObject));    
  pcell->noh.type = CELLTYPE;
  cellParser(l, pcell);
  strcpy(pcell->h_name, CELLNAME);
  pcell->ext.cell.state = 0;

  updateObjectIn3D(pcell);
  setOptionalBuffer(pcell);
  SolidSetVisibilty(pcell->soh, FALSE);
  updateBB(pcell);
  stilllist = addObjectToList(pcell, stilllist);
  insertObjectIntoGrid(pcell);
} 

/* through */
Private
void cellMethode0(WObject *pcell, long sec, long usec)
{
  /* quitWorld(); *//* CRASH !!! */
  if (!pcell->ext.cell.state) {
    trace(DBG_WMGT, "cell=%d %s", pcell->ext.cell.state,pcell->ext.cell.chanin);
    pcell->ext.cell.state = 1;
    quitChannel(channels_list);
    newChannel(pcell->ext.cell.chanin);
#ifdef WITHAUDIO
    if (audiobusy) {
      quitaudio();
      startaudio(pcell->ext.cell.chanin);
    }
#endif
  }
  else {
    trace(DBG_WMGT, "cell=%d %s", pcell->ext.cell.state, pcell->ext.cell.chanout);
    pcell->ext.cell.state = 0;
    quitChannel(channels_list);
    newChannel(pcell->ext.cell.chanout);
#ifdef WITHAUDIO
    if (audiobusy) {
      quitaudio();
      startaudio(pcell->ext.cell.chanout);
    }
#endif
  }
/***
  localWorldName(url);
  updateMemberWorld(username, worldname);
***/
}

/* object intersects: gothrough */
Private
void cellIntersect(WObject *pwoh, WObject *pwohold, WObject *pcell)
{
  if (pwohold->x <= pwoh->x)
    pwoh->x += (pwoh->bb_size.v[1] + pcell->bb_size.v[1]) * 2 + CELLGOTHROUGH;
  else
    pwoh->x -= (pwoh->bb_size.v[1] + pcell->bb_size.v[1]) * 2 + CELLGOTHROUGH;
  if (pwohold->y <= pwoh->y)
    pwoh->y += (pwoh->bb_size.v[1] + pcell->bb_size.v[1]) * 2 + CELLGOTHROUGH;
  else
    pwoh->y -= (pwoh->bb_size.v[1] + pcell->bb_size.v[1]) * 2 + CELLGOTHROUGH;
  updateObjectIn3D(pwoh);
  updateBB(pwoh);
  /* copyPositionAndBB(pwohold, pwoh); */

  cellMethode0(pcell, 0, 0);
}

/* cell functions initialization  */
Public
void initCellFuncList(void)
{
  generalFuncList[CELLTYPE].createFromFileline = cellCreateFromFile;
  generalFuncList[CELLTYPE].whenIntersect = cellIntersect;
  
  propertiesnumber[CELLTYPE] = 0;
}
