/*
 * WMMail - Window Maker Mail
 *
 * Copyright (c) 1996, 1997, 1998  Per Liden
 * Copyright (c) 1997, 1998  Bryan Chan
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * wmmail.h: global declarations for WMMail
 *
 * $Id: wmmail.h,v 1.7 1999/01/16 04:50:24 bryan.chan Exp $
 *
 */

#ifndef WMMAIL_H
#define WMMAIL_H


/* includes for type information */
#include <proplist.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>
#include "list.h"

/* includes for user-defined constants and feature selection */
#include "config.h"


/* constants */
#define WMMAIL_CLASS  "WMMail"         /* X application class name as
                                          well as GNUstep domain name */

#ifndef True                           /* Boolean values */
#define True                 1
#endif

#ifndef False
#define False                0
#endif

#define NO_MAIL   	     0         /* wmmail status; array subscripts */
#define OLD_MAIL             1
#define NEW_MAIL             2

#define SHOW_NONE            0         /* NumOfMsgMode mode numbers */
#define SHOW_NEW_OVER_TOTAL  1
#define SHOW_NEW_ONLY        2
#define SHOW_TOTAL_ONLY      3

#define LEFT_BUTTON          1         /* left mousebutton id */
#define MIDDLE_BUTTON        2         /* middle mousebutton id */
#define RIGHT_BUTTON         3         /* right mousebutton id */

#define NORMAL               0         /* parsing modes */
#define EXPECT_ANIM_NO_MAIL  1
#define EXPECT_ANIM_OLD_MAIL 2
#define EXPECT_ANIM_NEW_MAIL 3
#define EXPECT_MAIL_FILE     4

/* mailbox types */
#ifdef MBOX_SUPPORT
#  define TYPE_MBOX          (1<<0)
#endif
#ifdef MH_SUPPORT
#  define TYPE_MH            (1<<1)
#endif
#ifdef MAILDIR_SUPPORT
#  define TYPE_MAILDIR       (1<<2)
#endif
#ifdef POP3_SUPPORT
#  define TYPE_POP3          (1<<3)
#endif
#ifdef IMAP_SUPPORT
#  define TYPE_IMAP          (1<<4)
#endif

#ifdef MBOX_SUPPORT
#  define IS_MBOX(x)         ((x)->type & TYPE_MBOX)
#endif
#ifdef MH_SUPPORT
#  define IS_MH(x)           ((x)->type & TYPE_MH)
#endif
#ifdef MAILDIR_SUPPORT
#  define IS_MAILDIR(x)      ((x)->type & TYPE_MAILDIR)
#endif
#ifdef POP3_SUPPORT
#  define IS_POP3(x)         ((x)->type & TYPE_POP3)
#endif
#ifdef IMAP_SUPPORT
#  define IS_IMAP(x)         ((x)->type & TYPE_IMAP)
#endif


/* Mailbox */
typedef struct _Mailbox Mailbox;
struct _Mailbox {
  char       *name;
  char       *execute_on_update;
  int         type;
  int         status;
  int         total_mail_count;
  int         new_mail_count;
  int         update_interval;
  time_t      last_update;
  off_t       size;          /* should be moved into the options dictionary */
  proplist_t  options;       /* mailbox type-specific options dictionary */
};

extern LinkedList *mailbox_list;
extern int mailbox_count;


/* XPM Icon */
typedef struct _XpmIcon XpmIcon;
struct _XpmIcon {
  Pixmap        pixmap;
  Pixmap        mask;
  XpmAttributes attributes;
  XpmIcon       *next;
};

extern XpmIcon *animations[3];


/* global variables */
extern int wmmail_status;
extern int overridden;

extern int always_new_mail_exec;
extern int anim_speed[3];
extern int double_click_time;
extern int keep_quiet;
extern int num_of_msg_mode;
extern int num_of_msg_x;
extern int num_of_msg_y;
extern int use_appicon_only;
extern int use_beep;

extern char *app_name;
extern char *user_specified_domain;
extern char *exec_on_click;
extern char *exec_on_new;
extern char *wmmail_color;

extern Display      *disp;
extern Pixmap       shape_mask;
extern GC           shape_mask_gc;
extern GC           wmmail_gc;
extern Font         wmmail_font;
extern XtAppContext wmmail_context;
extern Widget       wmmail_widget;
extern Widget       wmmail_appicon;
extern Window       root;


#endif
