package biss.jde;

import biss.awt.Awt;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.PrintStream;

/**
 * design specification helper class whch contains all interactivly set
 * layout info of components
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
class DesignObjLayout
  implements Cloneable
{
	int X0;
	int X1;
	int Y0;
	int Y1;
	int OffX0;
	int OffX1;
	int OffY1;
	int OffY0;
	boolean DUOffset;
	int VarSides;

public DesignObjLayout () {
}

public DesignObjLayout ( int x0, int y0, int x1, int y1, boolean duo,
                  int xo0, int yo0, int xo1, int yo1, int vs) {
	X0 = x0; Y0 = y0;
	X1 = x1; Y1 = y1;
	OffX0 = xo0; OffY0 = yo0;
	OffX1 = xo1; OffY1 = yo1;
	DUOffset = duo;
	VarSides = vs;
}

public Object clone () {
	try {
		return super.clone();
	}
	catch ( CloneNotSupportedException x ) {
		return null;
	}
}

void offsetFromPelPoints ( Rectangle r, Point po, Point pc ) {
	int cx = Awt.DlgXUnit;
	int cy = Awt.DlgYUnit;

	if ( DUOffset){
		OffX0 = (r.x - po.x) * 100 / cx;
		OffY0 = (r.y - po.y) * 100 / cy;
		OffX1 = (r.x + r.width - pc.x) * 100 / cx;
		OffY1 = (r.y + r.height - pc.y) * 100 / cy;
	}
	else {
		OffX0 = r.x - po.x;
		OffY0 = r.y - po.y;
		OffX1 = r.x + r.width - pc.x;
		OffY1 = r.y + r.height - pc.y;
	}
}

String offsetString (){
	return "(" + OffX0 + "," + OffY0 + ")" +
	"(" + OffX1 + "," + OffY1 + ")";
}

void printLayoutOn ( PrintStream s) {
	s.print( X0 + ", " + Y0 + ", " +
	         X1 + ", " + Y1 + ", " +
	         DUOffset + ", " +
	         OffX0 + ", " + OffY0 + ", " +
	         OffX1 + ", " + OffY1 + ", " +
	         VarSides );
}

void ratioFromPelPoints ( int width, int height, Point po, Point pc ) {
	X0 = (po.x * 1000) / width;
	Y0 = (po.y * 1000) / height;
	X1 = (pc.x * 1000) / width;
	Y1 = (pc.y * 1000) / height;
}

String ratioString (){
	return "(" + X0 + "," + Y0 + ")" +
	"(" + X1 + "," + Y1 + ")";
}

void ratioToPelPoints ( int width, int height, Point po, Point pc ) {
	po.x = (X0 * width + 500) / 1000;
	po.y = (Y0 * height + 500) / 1000;
	pc.x = (X1 * width + 500) / 1000;
	pc.y = (Y1 * height + 500) / 1000;
}

void rectFromPelPoints ( Rectangle r, Point po, Point pc ) {

	if ( DUOffset ) {
		int cx = Awt.DlgXUnit;
		int cy = Awt.DlgYUnit;
		if ( OffX0 > 0)	r.x = po.x + (OffX0 * cx + 50) / 100;
		else						r.x = po.x + (OffX0 * cx - 50) / 100;
		if ( OffY0 > 0)	r.y = po.y + (OffY0 * cy + 50) / 100;
		else						r.y = po.y + (OffY0 * cy - 50) / 100;
		r.width  = pc.x - po.x + ((OffX1 - OffX0) * cx + 50) / 100;
		r.height = pc.y - po.y + ((OffY1 - OffY0) * cy + 50) / 100;
	}
	else {
		r.x = po.x + OffX0;
		r.y = po.y + OffY0;
		r.width  = pc.x - po.x + (OffX1 - OffX0);
		r.height = pc.y - po.y + (OffY1 - OffY0);
	}
}
}
