package biss.jde;

import biss.Set;
import biss.StringLib;
import biss.VectorSorter;
import java.io.*;
import java.util.*;

/**
 * abstract base model describing Java data or method declarations
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
abstract class FieldDecl
  implements Mod
{
	BitSet Mods;
	String Id;
	String Type;
	Set Cats;
	String Comment;
	int Line;

public void addCategory ( String cat ) {
	if ( Cats == null )
		Cats = new Set(5);
	Cats.add( cat);
}

String commentOrTemplate () {
	if ( Comment != null ) 
		return Comment;
	else
		return "/**\n * \n */";
}

public int  	drawHeight(){
	return DrawSupport.Cy;
}

abstract public boolean equals ( Object o );

public String getComment () {
	return Comment;
}

public boolean hasAnyMods ( BitSet m ) {
	BitSet b = (BitSet) Mods.clone();
	b.and( m);
	return !(b.equals( EmptyMods));
}

public boolean hasCategory ( String cat ) {
	return (Cats != null && Cats.contains( cat));
}

public boolean hasMods () {
	return !Mods.equals( EmptyMods);
}

public String	label(){
	return Id;
}

void printCommentOn ( PrintStream s ) {
	if ( Comment != null )
		s.println( Comment);
}

void printModsOn ( PrintStream s ) {
	for ( int i=0; i<NMods; i++ ){
		if ( Mods.get( i) ){
			s.print( ModName[i]);
			s.print( ' ');
		}
	}
}

abstract public void printOn ( PrintStream s, boolean withCmt, boolean withMods );

public void setComment ( String s ) {
	if ( s == null || s.length() == 0 )
		Comment = null;
	else
		Comment = s;
}
}
