package biss.jde;

import biss.Scanner;

/**
 * Scanner to tokenize Java sources (uggly, but efficient)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
class JavaScanner
  extends Scanner
{
	final public static int UNKNOWN = 0;
	final public static int CHAR = -1;
	final public static int STRING = -2;
	final public static int SCONST = -3;
	final public static int CCONST = -4;
	final public static int ABSTRACT = -5;
	final public static int CLASS = -6;
	final public static int EXTENDS = -7;
	final public static int FINAL = -8;
	final public static int IMPLEMENTS = -9;
	final public static int IMPORT = -10;
	final public static int INTERFACE = -11;
	final public static int NATIVE = -12;
	final public static int PACKAGE = -13;
	final public static int PRIVATE = -14;
	final public static int PROTECTED = -15;
	final public static int PUBLIC = -16;
	final public static int STATIC = -17;
	final public static int SYNCHRONIZED = -18;
	final public static int THROWS = -19;
	final public static int TRANSIENT = -20;
	final public static int VOLATILE = -21;
	final public static int IF = -22;
	final public static int ELSE = -23;
	final public static int FOR = -24;
	final public static int WHILE = -25;
	final public static int DO = -26;
	final public static int CONTINUE = -27;
	final public static int BREAK = -28;
	final public static int SWITCH = -29;
	final public static int CASE = -30;
	final public static int DEFAULT = -31;
	final public static int RETURN = -32;
	final public static int TRY = -33;
	final public static int CATCH = -34;
	final public static int THROW = -35;
	final public static int FINALLY = -36;
	final public static int TRUE = -37;
	final public static int FALSE = -38;
	final public static int NULL = -39;
	final public static int THIS = -40;
	final public static int SUPER = -41;
	final public static int NEW = -42;
	final public static int INSTANCEOF = -43;
	final public static String KeyNames[] = {
                              "nothing", "char", "string", "sconst", "cconst",
			      "abstract", "class", "extends", "final",
			      "implements", "import", "interface", "native",
			      "package", "private", "protected", "public",
			      "static", "synchronized", "throws", "transient", "volatile",
			      "if", "else", "for", "while", "do", "continue", "break",
			      "switch", "case", "default", "return", "try", "catch",
			      "throw", "finally", "true", "false", "null",
			       "this", "super", "new", "instanceof" };
	final public static int NKeys = 32;
// '.', '*' are treated as AN to ease full type parsing -> Strings
	final public static boolean ANTable[] = {
    false, false, false, false, false, false, false, false,  // 0..7
    false, false, false, false, false, false, false, false,  // 8..15
    false, false, false, false, false, false, false, false,  // 16..23
    false, false, false, false, false, false, false, false,  // 24..31
    false, false, false, false, true,  false, false, false,  // 32..39
    false, false, true,  false, false, false, true,  false,  // 40..47
    true,  true,  true,  true,  true,  true,  true,  true,   // 48..55
    true,  true,  false, false, false, false, false, false,  // 56..63
    false, true,  true,  true,  true,  true,  true,  true,   // 64..71
    true,  true,  true,  true,  true,  true,  true,  true,   // 72..79
    true,  true,  true,  true,  true,  true,  true,  true,   // 80..87
    true,  true,  true,  false, false, false, false, true,   // 88..95
    false, true,  true,  true,  true,  true,  true,  true,   // 96..103
    true,  true,  true,  true,  true,  true,  true,  true,   // 104..111
    true,  true,  true,  true,  true,  true,  true,  true,   // 112..119
    true,  true,  true,  false, false, false, false, false   // 120..127
  };

public JavaScanner ( byte source[] ) {
	super( source);
}

protected boolean[] getANTable() {
	return JavaScanner.ANTable;
}

protected String[] getKeywords () {
	return JavaScanner.KeyNames;
}

public static boolean isKeyword ( int id ) {
	return id < -4;
}

public int nextToken () {
	byte a, a1, b;
	boolean lastCmt = false;

	// shadowed because of getfield overhead
	byte[] c = C;
	boolean[] isAN = IsAN;
	int i = I;

	try {
		while ( true ){
			I0 = i;
			b = c[i];

			switch ( b ) {
			case (char)26: // some uggly DOS texeditors append ^Z
			case EOT:      // EOT to mark end of data in buffer
				// I = c.length;
				return (Tok = UNKNOWN);

			case '\n':
				Line++;
				i++;
				continue;

			case ' ':
			case '\t':
			case '\r':
				i++;
				continue;

			case '/':
				switch ( c[++i] ) {
				case '/':
					if ( !lastCmt )
						CStart = i-1;
					for ( i++; (a=c[i]) != '\n' && a != EOT; i++ );  // EOT because of line parsing
					CEnd = i;
					if ( a == '\n' ){
						Line++; i++;
						lastCmt = true;
					}
					else {   // EOT
						return (Tok = UNKNOWN);
					}
					continue;
				case '*':
					if ( !lastCmt )
						CStart = i-1;
					for ( a=c[i], a1=0; ++i < c.length; a1=a, a=c[i] ) {
						if ( a == '\n' )
							Line++;
						else if ( a == EOT )
							return (Tok = UNKNOWN);
						else if ( a == '/' && a1 == '*' ){
							break;
						}
					}
					CEnd = i;
					lastCmt = true;
					continue;
				default:
					I = i; return (Tok = '/');     // CHAR
				}

			case '"':
			case '\'':
				for ( i++, a=c[i]; i < c.length; i++, a=c[i] ){
					if ( a == '\\') {
						i++;
						if ( c[i] == EOT ) break;
					}
					else if ( a == EOT ) {
						// i = c.length;
						break;
					}
					else if ( a == b ) {
						i++;
						break;
					}
				}
				I = i;
				if ( b == '"' )
					return (Tok = SCONST);
				else
					return (Tok = CCONST);

			case 'a':  //------------------------------------------------------- a
				if ( c[++i] == 'b' && c[++i] == 's' && c[++i] == 't' && c[++i] == 'r' &&
				     c[++i] == 'a' && c[++i] == 'c' && c[++i] == 't' ) {
					if ( isAN[c[++i]] ){ while ( isAN[c[++i]] ); I=i; return (Tok = STRING);}
					else               { I=i; return (Tok= ABSTRACT); }
				} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }

			case 'b':  //------------------------------------------------------- b
				if ( c[++i] == 'r' && c[++i] == 'e' && c[++i] == 'a' && c[++i] == 'k' ) {
					if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
					else               { I=i; return (Tok= BREAK); }
				} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }

			case 'c':  //------------------------------------------------------- c
				switch ( c[++i] ) {
				case 'a':
					switch ( c[++i] ) {
					case 's':
						if ( c[++i] == 'e' ) {
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= CASE); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					case 't':
						if ( c[++i] == 'c' && c[++i] == 'h' ) {
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= CATCH); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					default:
						while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
					}
				case 'l':
					if ( c[++i] == 'a' && c[++i] == 's' && c[++i] == 's' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= CLASS); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'o':
					if ( c[++i] == 'n' && c[++i] == 't' && c[++i] == 'i' && c[++i] == 'n' &&
					     c[++i] == 'u' && c[++i] == 'e' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= CONTINUE); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'd': //------------------------------------------------------- d
				switch ( c[++i] ) {
				case 'e':
					if (c[++i]=='f' && c[++i]=='a' && c[++i]=='u' && c[++i]=='l' && c[++i]=='t'){
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= DEFAULT); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'o':
					if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
					else               { I=i; return (Tok= DO); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'e':  //------------------------------------------------------ e
				switch ( c[++i] ) {
				case 'l':
					if ( c[++i] == 's' && c[++i] == 'e' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= ELSE); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'x':
					if (c[++i]=='t' && c[++i]=='e' && c[++i]=='n' && c[++i]=='d' && c[++i]=='s'){
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= EXTENDS); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'f':  //------------------------------------------------------- f
				switch ( c[++i] ) {
				case 'a':
					if ( c[++i] == 'l' && c[++i] == 's' && c[++i] == 'e' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= FALSE); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'i':
					if ( c[++i] == 'n' && c[++i] == 'a' && c[++i] == 'l' ) {
						if ( isAN[c[++i]] ) {
							if ( c[i] == 'l' && c[++i] == 'y' ) {
								if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
								else               { I=i; return (Tok= FINALLY); }
							} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
						}
						else { I=i; return (Tok= FINAL); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'o':
					if ( c[++i] == 'r' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= FOR); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'i':  //-------------------------------------------------------- i
				switch ( c[++i] ) {
				case 'f':
					if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
					else               { I=i; return (Tok= IF); }
				case 'm':
					switch ( c[++i] ) {
					case 'p':
						switch ( c[++i] ) {
						case 'l':
							if ( c[++i] =='e' && c[++i] =='m' && c[++i] =='e' && c[++i] =='n' &&
							     c[++i] =='t' && c[++i] =='s' ){
								if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
								else               { I=i; return (Tok = IMPLEMENTS); }
							} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
						case 'o':
							if ( c[++i] == 'r' && c[++i] == 't' ){
								if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
								else               { I=i; return (Tok= IMPORT); }
							} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
						default:
							while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
						}
					}
				case 'n':
					switch ( c[++i] ) {
					case 's':
						if ( c[++i] =='t' && c[++i] =='a' && c[++i] =='n' && c[++i] =='c' &&
						     c[++i] =='e' && c[++i] =='o' && c[++i] =='f' ) {
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= INSTANCEOF); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					case 't':
						if ( c[++i] =='e' && c[++i] =='r' && c[++i] =='f' &&
						     c[++i] =='a' && c[++i] =='c' && c[++i] =='e' ){
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= INTERFACE); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					default:
						while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
					}
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'n': //---------------------------------------------------------------- n
				switch ( c[++i] ) {
				case 'a':
					if ( c[++i] =='t' && c[++i] =='i' && c[++i] =='v' && c[++i] =='e' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= NATIVE); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'e':
					if ( c[++i] == 'w' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= NEW); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'u':
					if ( c[++i] == 'l' && c[++i] == 'l' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= NULL); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'p':  //-------------------------------------------------------------- p
				switch ( c[++i] ) {
				case 'a':
					if (c[++i]=='c'&& c[++i]=='k'&& c[++i]=='a'&& c[++i]=='g'&& c[++i]=='e'){
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= PACKAGE); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'r':
					switch ( c[++i] ) {
					case 'i':
						if ( c[++i] =='v' && c[++i] =='a' && c[++i] =='t' && c[++i] =='e' ) {
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= PRIVATE); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					case 'o':
						if ( c[++i] =='t' && c[++i] =='e' && c[++i] =='c' && c[++i] =='t' &&
						     c[++i] =='e' && c[++i] =='d' ) {
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= PROTECTED); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					default:
						while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
					}
				case 'u':
					if ( c[++i] == 'b' && c[++i] == 'l' && c[++i] == 'i' && c[++i] == 'c' ){
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= PUBLIC); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 'r':  //----------------------------------------------------------- r
				if (c[++i] =='e'&& c[++i] =='t'&& c[++i] =='u'&& c[++i] =='r'&& c[++i]=='n'){
					if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
					else               { I=i; return (Tok= RETURN); }
				} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }

			case 's': //----------------------------------------------------------- s
				switch ( c[++i] ) {
				case 't':
					if ( c[++i] == 'a' && c[++i] == 't' && c[++i] == 'i' && c[++i] == 'c' ){
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= STATIC); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'u':
					if ( c[++i] == 'p' && c[++i] == 'e' && c[++i] == 'r' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= SUPER); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'w':
					if ( c[++i] =='i' && c[++i] =='t' && c[++i] =='c' && c[++i] =='h' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= SWITCH); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				case 'y':
					if ( c[++i] =='n' && c[++i] =='c' && c[++i] =='h' && c[++i] =='r' &&
					     c[++i] =='o' && c[++i] =='n' && c[++i] =='i' && c[++i] =='z' &&
					     c[++i] =='e' && c[++i] =='d' ) {
						if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
						else               { I=i; return (Tok= SYNCHRONIZED); }
					} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
				default:
					while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
				}

			case 't': //------------------------------------------------------------- t
				switch ( c[++i] ) {
				case 'h':
					switch ( c[++i] ) {
					case 'i':
						if ( c[++i] == 's' ){
							if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
							else               { I=i; return (Tok= THIS); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					case 'r':
						if ( c[++i] =='o' && c[++i] =='w' ) {
							if ( c[++i] == 's' ) {
								if ( isAN[c[++i]] ){ while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
								else               { I=i; return (Tok= THROWS); }
							}
							else {
								if ( isAN[c[i]] )  { while ( isAN[c[++i]] );I=i; return (Tok = STRING);}
								else               { I=i; return (Tok= THROW); }
							}
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					default:
						while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
					}
				case 'r':
					switch ( c[++i] ) {
					case 'a':
						if ( c[++i] =='n' && c[++i] =='s' && c[++i] =='i' && c[++i] =='e' &&
						     c[++i] =='n' && c[++i] =='t' ) {
							if ( isAN[c[++i]] ) { while ( isAN[c[++i]] ); I=i; return (Tok = STRING);}
							else		{ I=i; return (Tok = TRANSIENT); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					case 'u':
						if ( c[++i] == 'e' ){
							if ( isAN[c[++i]] ) { while ( isAN[c[++i]] ); I=i; return (Tok = STRING);}
							else		{ I=i; return (Tok = TRUE); }
						} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }
					case 'y':
						if ( isAN[c[++i]] )  { while ( isAN[c[++i]] ); I=i; return (Tok = STRING); }
						else		       { I=i; return (Tok = TRY); }
					default:
						while ( isAN[c[i]] ) i++; I=i;  return (Tok = STRING);
					}
				default:
					while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING);
				}

			case 'v': //------------------------------------------------------------- v
				if ( c[++i] =='o' && c[++i] =='l' && c[++i] =='a' && c[++i] =='t' &&
				     c[++i] =='i' && c[++i] =='l' && c[++i] =='e' ) {
					if ( isAN[c[++i]] )  { while ( isAN[c[++i]] ); I=i; return (Tok = STRING); }
					else		      { I=i; return (Tok = VOLATILE); }
				} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }

			case 'w': //------------------------------------------------------------- w
				if ( c[++i] =='h' &&  c[++i] =='i' &&  c[++i] =='l' &&  c[++i] =='e' ) {
					if ( isAN[c[++i]] )  { while ( isAN[c[++i]] ); I=i; return (Tok = STRING); }
					else		      { I=i; return (Tok = WHILE); }
				} else { while ( isAN[c[i]] ) i++; I=i; return (Tok = STRING); }

			default:
				if ( isAN[b] ) { while ( isAN[c[++i]] ); I=i; return (Tok = STRING); }
				else           { I = ++i; return (Tok = b); }  // char token
			}  // switch
		}  // while
	}  // try
	catch ( ArrayIndexOutOfBoundsException x ) { // loop termination performance hack
		if ( i > I0 ){                             // we have to check for a keyword
			I = c.length;                            // for safety (some jits optimize too far)
			String last = string();                  // at the very end of the input
			for ( int k=4; k<Keywords.length; k++ ){ // (done just once, otherwise some
				if ( last.equals( Keywords[k]) )       // ops would be required for EACH char)
					return (Tok = -k);                   // this is rare (degenerated) case anyway
			}
			return (Tok = STRING);
		}	
		return (Tok = UNKNOWN);
	}
}

public boolean skipBlock ( char delim1, char delim2 ) {  // { .. }
	int level = 1;
	byte a;

	int i = I;    // copied because of fieldref overhead
	byte[] c = C; // dito

	try {
		while ( true ){
			if ( (a = c[i]) == (byte) delim1 ) {
				level++;
				i++;
			}
			else if ( a == (byte) delim2 ){
				i++;
				if ( --level == 0 ) {
					I = i;  return true;
				}
			}
			else {
				switch ( a ) {

				case '\n':
					i++;
					Line++;
					break;

				case '/':
					switch ( c[++i] ) {
					case '/':
						I = i;  skipLineComment(); i = I;
						break;

					case '*':
						I = i;  skipComment(); i = I;
						break;

					default:
						i++;
					}
					break;

				case '\'': case '"':
						I = i; skipLiteral(); i = I;
						break;

					default:
						i++;
					}
				}
			}
		}
		catch ( ArrayIndexOutOfBoundsException x ) {
			I = i;  return false;
		}    
	}

public void skipComment () {
	byte[] c = C;  // shadowed because of getfield instruction overhead
	int i = I;

	try {
		while ( true ) {
			i++;
			if ( c[i] == '\n' )
				Line++;
			else if ( c[i] == '/' && c[i-1] == '*' )
				break;
		}
		I = ++i;
	}
	catch ( ArrayIndexOutOfBoundsException x ) { I = i; }
}

public boolean skipExpr () {
	byte[] c = C;  // shadowed because of getfield instruction overhead
	int i = I;

	try {
		while ( true ) {
			switch ( c[i] ) {
			case ' ':
			case '\t':
				i++;
				break;

			case ';':
			case ',':
				I = i;
				return true;

			case '\n':
				Line++;
				i++;
				break;;

			case '\'':
			case '"':
				I = i; skipLiteral(); i = I;
				break;

			case '/':
				switch ( c[++i] ) {
				case '/':
					I = i; skipLineComment(); i = I;
					break;
				case '*':
					I = i; skipComment(); i = I;
					break;
				default:
					i++;
				}
				break;

			case '(':
				i++;
				I = i; skipBlock( '(', ')'); i = I;
				break;

			case '{':
				i++;
				I = i; skipBlock( '{', '}'); i = I;
				break;

			default:
				i++;
			}
		}
	}
	catch ( ArrayIndexOutOfBoundsException x ) {
		I = i; return false;
	}
}

public void skipLineComment () {
	byte[] c = C;  // shadowed because of getfield instr overhead
	int i = I;

	try {
		while ( c[++i] != '\n' );
		Line++;
		I = ++i;
	}
	catch ( ArrayIndexOutOfBoundsException x ){ I = i; }
}

public void skipLiteral () {
	byte[] c = C; // shadowed because of getfield instr overhead
	int i = I;

	try {
		byte a = c[i];
		while ( c[++i] != a )
			if ( c[i] == '\\' ) i++;
		I = ++i;
	}
	catch ( ArrayIndexOutOfBoundsException x ) { I = i; }
}

public int skipToFirstOf ( char[] sep ) {
	byte[] c = C;  // shadowed because of getfield instr overhead
	int i = I;

	byte b;
	int n = sep.length;

	try {
		while ( true ) {
			switch ( (b=c[i]) ) {
			case '\n':
				Line++;
				i++;
				break;;

			case '\'': case '"':
					I = i; skipLiteral(); i = I;
					break;

				case '/':
					switch ( c[++i] ) {
					case '/':
						I = i; skipLineComment(); i = I;
						break;
					case '*':
						I = i; skipComment(); i = I;
						break;
					default:
						i++;
					}
					break;

				default:
					for ( int j=0; j<n; j++ ) {
						if ( b == sep[j] ){
							I = ++i;
							return b;
						}
					}
					i++;
				}
			}
		}
		catch ( ArrayIndexOutOfBoundsException x ){ I = i;  return 0; }
	}

public String tokenString() {
	if ( Tok > 0 )
		return "'" + (char)Tok + "'";
	else if ( Tok == UNKNOWN )
		return "UNKNOWN";
	else
		return string();
}
}
