package biss.jde;

import biss.FileLib;
import java.io.File;
import java.io.FileInputStream;
import java.util.BitSet;
import java.util.Vector;

/**
 * parser used to analyze Librowser level information (types, packages)
 * of CompileUnits (Java sources)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class LibParser
  extends Parser
{

public LibParser ( String fname, byte src[] ) {
	super ( fname, src);
}

void class_decl ( BitSet mods ) throws ParseException {
	CurNt = "class decl"; CurLn = Scan.Line;
	// logEnter( "class_decl");

	String id;
	String base;
	Vector interfaces;

	// match( JavaScanner.CLASS );
	id = matchString( "class name expected");
	ClassDecl cls = new ClassDecl( mods, id);
	TDecl = cls;
	CU.addTypeDecl( TDecl);

	if ( isMatch( JavaScanner.EXTENDS ) ){
		base = matchString( "base class name expected");
		cls.setSuper( base);
	}

	if ( isMatch( JavaScanner.IMPLEMENTS) ){
		interfaces = id_list();
		TDecl.setInterfaces( interfaces);
	}

	matchBlock();
	// logExit( id);
}

void interface_decl ( BitSet mods ) throws ParseException {
	CurNt = "interface"; CurLn = Scan.Line;
	// logEnter( "interface_decl");

	String id;
	Vector interfaces;


	// match( JavaScanner.INTERFACE );
	id = matchString( "interface name expected");
	InterfaceDecl ifc =new InterfaceDecl(mods,id);
	TDecl = ifc;
	CU.addTypeDecl( TDecl);
	if ( isMatch( JavaScanner.EXTENDS) ) {
		interfaces = id_list();
		TDecl.setInterfaces( interfaces);
	}

	matchBlock();
	// logExit( id);
}

public CompileUnit parseCompileUnit () throws ParseException {
	CU = null;
	Scan.nextToken();
	compile_unit();
	return CU;
}
}
