//////////////////////////////////////////////////////////////////////
// Jlpr.java
// Printer  class to print other applets
//
// (C) 1996 E.J.Friedman-Hill and Sandia National Labs
//////////////////////////////////////////////////////////////////////

/**
 * Prints applets using the PSGr PostScript Graphics context
 * @author E.J. Friedman-Hill (C)1996
 * @author      ejfried@ca.sandia.gov
 * @author      http://herzberg.ca.sandia.gov
*/

import java.awt.*;
import java.applet.*;
import java.net.*;
import java.io.*;
import java.lang.*;
import java.util.*;

public class Jlpr extends Applet implements Runnable {
  
  PrintMenu pm;
  String host, script, label, file;
  Thread menuThread, printThread;
  Button print,refresh;
  Choice c;
  TextField tf;
  Checkbox useFile, useNet;
  CheckboxGroup cbg;
  /**
    Constructor
    */
  
  public Jlpr() {
  }
    /**
     * Info.
     */
  public String getAppletInfo() {
    return "Jlpr by Ernest J. Friedman-Hill";
  }
  
  /**
   * Parameter Info
   */
  public String[][] getParameterInfo() {
    String[][] info = {
      {"LABEL", 	"string", 		"Displayed on button"},
      {"HOST",  	"string", 		"Internet host where file echoer lives"},
      {"SCRIPT", 	"string", 		"Path of script (i.e., /cgi-bin/echo"}
    };
    return info;
  }
  
  public void init() {

    host = getParameter("HOST");
    script = getParameter("SCRIPT");
    if (file == null && (host == null || script == null)) {
      showStatus("Sorry, failed to initialize Jlpr");
      return;
    }

    label = getParameter("LABEL");
    if (label == null)
      label = "Print";

    setLayout(new BorderLayout());

    Panel np = new Panel();
    np.setLayout(new FlowLayout());
    add("South", np);
    cbg = new CheckboxGroup();
    np.add(useNet = new Checkbox("Use Net", cbg, true));
    np.add(useFile = new Checkbox("Use File", cbg, false));
    np.add(tf = new TextField("jlpr.ps"));
    
    np = new Panel();
    np.setLayout(new FlowLayout());
    add("North", np);
    np.add(print = new Button(label));
    np.add(refresh = new Button("Refresh"));
    np.add(c = new Choice());
    c.addItem("Jlpr        ");
    pm = new PrintMenu(this);
    
  }

  /**
   * Start the applet by forking a thread
   * which will look for other applets -- note that start()
   * doesn't call run() for this class!
   */
  public void start() {
    if (menuThread == null) {
      menuThread = new Thread(pm);
      menuThread.start();
    }
  }

  /**
   * Stop the applet 
   */
  public void stop() {
    if (menuThread != null) {
      menuThread.stop();
      menuThread = null;
    }
    if (printThread != null) {
      printThread.stop();
      printThread = null;
    }
  }
  
  private Applet printWhat() {
    // what applet type is selected in choice?
    String type = c.getSelectedItem().trim();

    // Find an applet of this type
    Enumeration en = getAppletContext().getApplets();
    while (en.hasMoreElements()) {
      Object a = en.nextElement();
      if (a == null) continue;
      String atype = a.getClass().getName();
      if (type.equals(atype))
        return (Applet) a;
    }
    return null;
  }

  public void run() {
    // determine what to print
    Applet printThis = printWhat();
    if (printThis == null)
      return;
    String psdata;
    try {
      Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
      // first get the postscript as a big string.
      ByteArrayOutputStream baos = new ByteArrayOutputStream(600000);
      PSGr postscript = new PSGr(baos, getGraphics());
      
      // paint the applet and the components on top of it, recursively.
      paintInside(printThis,postscript);
      psdata = baos.toString();
    } catch (Throwable t) {
      showStatus("Error during rendering.");
      System.err.println(t);
      return;
    }
    if (cbg.getCurrent() == useFile) {
      file = tf.getText();
      if (file == null || file.length() == 0) {
        file = "jlpr.ps";
        tf.setText(file);
      }
    
      try {
        PrintStream f = new PrintStream(new FileOutputStream(file));
        f.println(psdata);
        f.println("showpage");
        f.close();
        URL u;
        u = new URL("file://" + file);
        // display the postscript in a new frame
        getAppletContext().showDocument(u,"_postscript");
        showStatus("Printing Complete.");
      } catch (Throwable t) {
        showStatus("Error while saving file.");
        System.out.println(t);
      }
    } else { // use net
      
      try {
        Socket lprs;
        lprs = new Socket(host, 80);
        
        DataInputStream dis;
        PrintStream dos;
        String newfile;
        dis = new DataInputStream(lprs.getInputStream());
        dos = new PrintStream(lprs.getOutputStream());
        
        dos.println("POST " + script + " HTTP/1.0");
        dos.print("Content-length: ");
        dos.println(psdata.length());
        dos.println("");
        dos.println(psdata);
        // end of page; not used in EPS
        dos.println("showpage");
        
        while (!(dis.readLine().equals(""))); // protocol responses
        newfile = dis.readLine();
        dis.close();
        dos.close();
        
        URL u;
        u = new URL(newfile);
        // display the postscript in a new frame
        getAppletContext().showDocument(u,"_postscript");
        showStatus("Printing Complete.");
      } catch (Throwable t) {
        showStatus("Error during data transmission.");
        System.out.println(t);
      }
    }
  }

  public boolean handleEvent(Event e) {
    if (e.target == c && e.id == Event.ACTION_EVENT) {
      // leave things alone on error
      return true;
    } else if (e.target == print && e.id == Event.ACTION_EVENT) {
      if (printThread == null || !printThread.isAlive()) { 
        printThread = new Thread(this);
        printThread.start();
        return true;
      }      
    } else if (e.target == refresh && e.id == Event.ACTION_EVENT) {
      if (menuThread != null) {
        menuThread.stop();
        menuThread = null;
      }
      start();
      return true;
    }
    return false;
  }
  
  public void paintInside(Component comp, PSGr g) {
    Point p = new Point(0,0);
    p = comp.location();

    // set the origin for this component
    g.translate(p.x, -p.y);

    // draw this component
    showStatus("Painting: " + comp.toString());
    updateComponent(comp,g);

    // now draw this component's children inside its coordinate system
    if (comp instanceof Container) {
      Component[] comps= ((Container) comp).getComponents();
      for (int i=0; i<comps.length; i++)
        paintInside(comps[i], g);
    }

    // restore the coordinate system
    g.translate(-p.x, p.y);
  }

  public void updateComponent(Component c, Graphics g) {
    // draw a few special types of Component
    Rectangle b = c.bounds();
    int halfheight = b.height/2;

    if (c instanceof Button) {
      if (c.getFont() != null)
        g.setFont(c.getFont());
      g.setColor(Color.white);
      g.fillRoundRect(0,0,b.width, b.height, 4,4);
      g.setColor(Color.black);
      g.drawRoundRect(0,0,b.width, b.height, 4,4);
      g.drawString(((Button) c).getLabel(), 2, halfheight+3);
    } else if (c instanceof Label) {
      if (c.getFont() != null)
        g.setFont(c.getFont());
      g.setColor(Color.black);
      g.drawString(((Label) c).getText(), 2, halfheight+3);
    } else if (c instanceof Choice) {
      if (c.getFont() != null)
        g.setFont(c.getFont());
      g.setColor(Color.black);
      g.drawRect(0,0,b.width+1, b.height+1);
      g.setColor(Color.white);
      g.fillRect(0,0,b.width, b.height);
      g.setColor(Color.black);
      g.drawRect(0,0,b.width, b.height);
      g.fillRect(b.width-7,halfheight-1, 6,2);
      g.drawString(((Choice) c).getSelectedItem(), 2, halfheight+3);
    } else if (c instanceof TextComponent) {
      if (c.getFont() != null)
        g.setFont(c.getFont());
      g.setColor(Color.white);
      g.fillRect(0,0,b.width, b.height);
      g.setColor(Color.black);
      g.drawRect(0,0,b.width, b.height);
      g.drawString(((TextComponent) c).getText().trim(), 2, halfheight+3);
    } else {
      // let it draw itself
      c.update(g);
    }
  }
}


class PrintMenu implements Runnable {
  Jlpr p;
  private static int exceptionCount = 0;

  public PrintMenu(Jlpr p) {
    this.p = p;
  }

  private boolean findInChoice(String s, Choice c) {
    for (int i=0; i< c.countItems(); i++)
      if (c.getItem(i).trim().equals(s))
        return true;
    return false;
  }
  
  public void run() {
    Choice c = p.c;
    Object a;
    String type;
    try {
      Enumeration e = p.getAppletContext().getApplets();

      // put all applets on the menu.
      while (e.hasMoreElements()) {
        a =  e.nextElement();
        if (a == null) continue;
        type = a.getClass().getName();
        if (!findInChoice(type,c))
          c.addItem(type);
      }

    } catch (Throwable ex) {
      // if anything bad happens, wait a bit, then try again, five times
      ++exceptionCount;
      try {
        System.err.println(ex);
        Thread.currentThread().sleep(200);
      } catch (java.lang.InterruptedException ex2) {
        // whatever
      }
      if (exceptionCount < 5)
        run();
    }
    c.layout();
    exceptionCount = 0;
  }

}




