
/* Copyright (c) Miguel Angel Sepulveda, 1998. */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#ifndef __GD_POLYMER_H 
#define __GD_POLYMER_H 1 
 
 
class GdPolymer {  
  /* A polymer object is an array of monomers joint by single bonds  */ 
   
public:  
  GdPolymer();  
  ~GdPolymer();  
 
  GdPolymer(int size);  
  GdPolymer(GdPolymer &); 
	  
  /* Operators defined in the class */  
  GdMonomer& operator[](int i);  
  GdPolymer& operator=(GdPolymer&);  
	  
  /* Selector Functions */  
  int getSize() const;                /* Return the number of monomers    */  
  double getVolume() const;           /* Get volumen for polymer          */  
  double bondLength() const;          /* Averag. bond length              */  
  void center(double&, double&, double&) const; /* Compute center of mass */  
	  
  /* Modifiers  */  
  void resetVelocity();               /* Set to zero monomer velocities   */  
  void resetAcceleration();           /* Set to zero monomer accelerations*/  
  void linear(double);                /* Set polymer in a linear config   */  
  void translate(double, double, double); /* Translate polymer by x y z   */  
  void moveTo(double, double, double); /* Move polymer to x y z coord     */  
  void random(unsigned long&, double); /* Random linear configuration     */  
	  
protected:  
  static long unsigned seed;  
  friend ostream& operator<<(ostream&, GdPolymer&);  
	  
private:  
  int numberMonomers;        /* Size of the polymer (Nr monomers)         */  
  GdMonomer *monomer;        /* Array of monomers in the polymer object   */  
};  
 
 
#endif 
