/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgInsert.c                                                   */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:45 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "Insert"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *image;
  int seq_start,seq_incr,seq_count;
  int count,insert_start,insert_incr,stdin_done,files_done;

  IFHELP
    {
      fprintf(stderr,"img%s - Insert images from seq files into the image stream\n",
	      PRGNAME);
      fprintf(stderr,"img%s basename [start [incr [count [insert_start [insert_count]]]]]\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Any\n");
      fprintf(stderr,"  stdout: Any\n");
      fprintf(stderr,"  files: Any\n");
      exit(0);
    }

  imgStart(PRGNAME);

  seq_start= -1;
  seq_incr=1;
  seq_count=999;
  insert_start=1;
  insert_incr=2;

  if(argc<2 || argc>7)
    ERROR("illegal arguments");
  if(argc>2)
    seq_start=atoi(argv[2]);
  if(argc>3)
    seq_incr=atoi(argv[3]);
  if(argc>4)
    seq_count=atoi(argv[4]);
  if(argc>5)
    insert_start=atoi(argv[5]);
  if(argc>6)
    insert_incr=atoi(argv[6]);
  
  if(seq_start<0)
    seq_count=1;
  
  count=0;
  stdin_done=0;
  files_done=0;
  while(!files_done || !stdin_done)
    {
      image=NULL;
      if(!files_done && (count==insert_start || stdin_done))
	{ 
	  /* Get image from file */
	  if((image=i_load_image(argv[1],seq_start,IT_ANY,IM_FRAGMENT))==NULL)
	    files_done=1;
	  seq_start+=seq_incr;
	  insert_start+=insert_incr;
	  seq_count--;
	  if(seq_count<1)
	    files_done=1;
	}
      if(!stdin_done && image==NULL)
	{
	  /* Get image from stdin */
	  if((image=i_read_image_file(stdin,IT_ANY,IM_FRAGMENT))==NULL)
	    ERROR("can't import image file");
	  if(feof(stdin))
	    stdin_done=1;
	}
      if(image!=NULL)
	{
	  /* Write the image */
	  i_write_image_file(stdout,image,IF_BINARY);
	  i_destroy_image(image);
	  count++;
	}
    }

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
