/*
 * Author:      Raphael S. de Moraes <raphael@land.ufrj.br> in April, 1999
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/wb_mcast.c,v 4.6 1999/11/12 19:40:39 william Exp $
 */

#define _INCLUDE_FROM_WB_MCAST_C_

#include "tgifdefs.h"

#include "wb_mcast.e"

#ifdef _TGIF_WB2

#include <sys/uio.h>
#include <pwd.h>

struct PCM_session_message PCM_SM[SM_TABLE_SIZE];
struct PCM_pack_struct PCM_hist[HIST_SIZE];
int PCM_socket=0;
int PCM_port=0;
char PCM_group[GROUP_NAME_SIZE];
struct sockaddr_in PCM_sockaddr;

FILE *PCM_logfp=NULL;
int PCM_myIP=0;
int PCM_myPID=0;
int PCM_Nseq=0;
int PCM_pos_hist=0;
int PCM_TSM=0, PCM_Tfunc=0;
int PCM_tcount=0, PCM_old_tcount=0;
int PCM_Nretrans=0;
float PCM_conf_recv=(float)0, PCM_conf_send=(float)0;

void (*PCM_func)()=NULL;

#ifdef ARGS_DECL_USED
void PCM_initialize(char *logfile)
#else /* ~ARGS_DECL_USED */
void PCM_initialize(logfile)
	char *logfile;
#endif /* ARGS_DECL_USED */
{
	struct in_addr in;

	PCM_initialize_SM(PCM_SM);
	PCM_initialize_hist();
	PCM_Nseq = 0;
	PCM_pos_hist = 0;
	PCM_tcount = 0;
	PCM_Nretrans = 0;

	PCM_conf_send = CONF_SEND;
	PCM_conf_recv = CONF_RECV;

	/* Pegar meu IP */
	PCM_myIP = gethostid();
	in.s_addr = PCM_myIP;
		
	/* Pegar meu PID */
	PCM_myPID = getpid();

	PCM_timer_run(PCM_TSM, PCM_send_SM);
	
       	/*if ((PCM_logfp = fopen(logfile,"wb"))==NULL)
	{
		printf("O arquivo de log nao pode ser criado\n");
		exit(1);
	}*/
}

#ifdef ARGS_DECL_USED
void PCM_setoption(int OptionName,int NewValue)
#else /* ~ARGS_DECL_USED */
void PCM_setoption(OptionName, NewValue)
	int OptionName, NewValue;
#endif /* ARGS_DECL_USED */
{
       switch (OptionName)
       case SM_INTERVAL : {
                          PCM_TSM = NewValue;
			  break;
	                  };
}

#ifdef ARGS_DECL_USED
void PCM_terminate(void)
#else /* ~ARGS_DECL_USED */
void PCM_terminate()
#endif /* ARGS_DECL_USED */
{
       	fclose(PCM_logfp);
}

#ifdef ARGS_DECL_USED
int PCM_joinGroup(char *group, int port)
#else /* ~ARGS_DECL_USED */
int PCM_joinGroup(group, port)
	char *group;
	int port;
#endif /* ARGS_DECL_USED */
{
	u_char loop;
	int s;
	u_char TimeToLive;
	struct sockaddr_in groupHost,groupStruct;
	struct ip_mreq mreq;

	TimeToLive = DEFAULT_MULTICAST_TTL_VALUE;

	groupHost.sin_family = AF_INET;
	groupHost.sin_port = htons(port);
	groupHost.sin_addr.s_addr = htonl(INADDR_ANY);

	if ((s = socket(PF_INET, SOCK_DGRAM, 0)) < 0)
	{
		printf("Impossivel criar socket\n");
		exit(1);
	}

	PCM_reusePort(s);
	if ((bind(s,(struct sockaddr *)&groupHost, sizeof(groupHost)) == -1))
	{
		printf("Erro no bind\n");
		exit(1);
	}

	PCM_setTTLvalue(s, &TimeToLive);
	loop = 1;
	PCM_setLoopback(s,loop);

	if ((groupStruct.sin_addr.s_addr = inet_addr(group)) == -1)
		printf("Erro no inet_addr\n");

	mreq.imr_multiaddr = groupStruct.sin_addr;
	mreq.imr_interface.s_addr = INADDR_ANY;

	if (setsockopt(s, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *)&mreq,
		sizeof(mreq)) == -1)
	{
		printf("Erro no join do grupo\n");
		exit(1);
	}

	PCM_socket = s;
	strcpy(PCM_group,group);
	PCM_port = port;

	PCM_sockaddr.sin_family = AF_INET;
	PCM_sockaddr.sin_port = htons(PCM_port);
	PCM_sockaddr.sin_addr.s_addr = inet_addr(PCM_group);

	return s;
}

#ifdef ARGS_DECL_USED
void PCM_leaveGroup(int sock, char *group)
#else /* ~ARGS_DECL_USED */
void PCM_leaveGroup(sock, group)
	int sock;
	char *group;
#endif /* ARGS_DECL_USED */
{
	struct sockaddr_in groupStruct;
	struct ip_mreq dreq;

	if ((groupStruct.sin_addr.s_addr = inet_addr(group)) == -1)
		printf("Erro no inet_addr\n");

	dreq.imr_multiaddr = groupStruct.sin_addr;
	dreq.imr_interface.s_addr = INADDR_ANY;

	if (setsockopt(sock,IPPROTO_IP, IP_DROP_MEMBERSHIP, (char *)&dreq,
		sizeof(dreq)) == -1)
	{
		printf("Erro na saida do grupo\n");
		exit(1);
	}

	close(sock);
	printf("Numero total de retransmissoes: %d\n",PCM_Nretrans);
	printf("Processo saindo do grupo multicast %s\n",group);
}

#ifdef ARGS_DECL_USED
void PCM_reusePort(int s)
#else /* ~ARGS_DECL_USED */
void PCM_reusePort(s)
	int s;
#endif /* ARGS_DECL_USED */
{
	int one = 1;

	if (setsockopt(s,SOL_SOCKET, SO_REUSEADDR, (char *)&one, sizeof(one)) == -1)
	{
		printf("Erro em setsockopt, SO_REUSEPORT\n");
		exit(1);
	}
}

#ifdef ARGS_DECL_USED
void PCM_setTTLvalue(int s, u_char *i)
#else /* ~ARGS_DECL_USED */
void PCM_setTTLvalue(s, i)
	int s;
	u_char *i;
#endif /* ARGS_DECL_USED */
{
	if (setsockopt(s,IPPROTO_IP, IP_MULTICAST_TTL, (char *)i,
		sizeof(u_char)) == -1)
	{
		printf("Erro setando valor de TTL\n");
	}
	
}

#ifdef ARGS_DECL_USED
void PCM_setLoopback(int s, u_char loop)
#else /* ~ARGS_DECL_USED */
void PCM_setLoopback(s, loop)
	int s;
	u_char loop;
#endif /* ARGS_DECL_USED */
{
	if (setsockopt(s,IPPROTO_IP, IP_MULTICAST_LOOP, (char *)&loop,
		sizeof(u_char)) == -1)
	{
		printf("Erro setando valor de loopback\n");
	}
}

#ifdef ARGS_DECL_USED
void PCM_timer_run(int sec, void (*func)())
#else /* ~ARGS_DECL_USED */
void PCM_timer_run(sec, func)
	int sec;
	void (*func)();
#endif /* ARGS_DECL_USED */
{
	struct sigaction act;
	struct itimerval value;
	
	PCM_func = func;
	PCM_old_tcount = PCM_tcount;
	PCM_Tfunc = sec;
	
	value.it_interval.tv_sec = sec;
	value.it_interval.tv_usec = 0;
	value.it_value.tv_sec = sec;
	value.it_value.tv_usec = 0;
	
	act.sa_handler = PCM_func;
	sigaction(SIGALRM, &act, NULL);
	setitimer(ITIMER_REAL,&value,NULL);
}

#ifdef ARGS_DECL_USED
void PCM_event(void)
#else /* ~ARGS_DECL_USED */
void PCM_event()
#endif /* ARGS_DECL_USED */
{
	PCM_tcount++;
	
	if ((PCM_tcount - PCM_old_tcount)==PCM_Tfunc)
	{
		(*PCM_func)();
		PCM_old_tcount = PCM_tcount;
	}
	if ((PCM_tcount % PCM_TSM)==0) PCM_send_SM();
}

#ifdef ARGS_DECL_USED
void PCM_log_packet(struct PCM_pack_struct *Pack, enum PCM_pack_type ptype)
#else /* ~ARGS_DECL_USED */
void PCM_log_packet(Pack, ptype)
	struct PCM_pack_struct *Pack;
	enum PCM_pack_type ptype;
#endif /* ARGS_DECL_USED */
{
	/*
	struct PCM_log_struct log;
		
	// Armazena informacoes sobre o pacote recebido em arquivo
	log.IP = Pack->IP_origem;
	log.PID = Pack->PID_origem;
	log.Nseq = Pack->Nseq;
	log.time = time(NULL);
	log.ptype = ptype;
	
	if (fwrite(&log, sizeof(struct PCM_log_struct),1,PCM_logfp) != 1)
	{
		printf("Erro na escrita em arquivo de log\n");
	}
	*/
}

#ifdef ARGS_DECL_USED
int PCM_cache(struct PCM_pack_struct *Pack)
#else /* ~ARGS_DECL_USED */
int PCM_cache(Pack)
	struct PCM_pack_struct *Pack;
#endif /* ARGS_DECL_USED */
{
	int i,encontrou;
	
	i = 0;
	encontrou = 0;
	
	/* Armazena pacote recebido no historico de pacotes */
	while ((i<HIST_SIZE) && (!encontrou))
	{
		if ((PCM_hist[i].IP_origem == Pack->IP_origem) &&
		    (PCM_hist[i].PID_origem == Pack->PID_origem) &&
		    (PCM_hist[i].Nseq == Pack->Nseq)) encontrou = 1;
		else i++;    
	}
	
	if (!encontrou)
	{
		i = PCM_pos_hist;
		PCM_pos_hist = (int)((PCM_pos_hist+1) % HIST_SIZE);
		PCM_hist[i].IP_origem = Pack->IP_origem;
		PCM_hist[i].PID_origem = Pack->PID_origem;
		PCM_hist[i].Nseq = Pack->Nseq;
		memcpy(PCM_hist[i].Data,Pack->Data,DATASIZE);
		return 1;
	}
	else return -1;
}

#ifdef ARGS_DECL_USED
int PCM_sendto(int Socket, char *Buffer, int Bufsize, int flag,
		struct sockaddr *Dest, int Size)
#else /* ~ARGS_DECL_USED */
int PCM_sendto(Socket, Buffer, Bufsize, flag, Dest, Size)
	int Socket;
	char *Buffer;
	int Bufsize;
	int flag;
	struct sockaddr *Dest;
	int Size;
#endif /* ARGS_DECL_USED */
{
	int val,size;
	struct PCM_pack_struct Pack;
	char SendBuffer[PACKSIZE];


	if (!PCM_good_toss(PCM_conf_send))
	  {
	    return -1;
	  }

	memset(SendBuffer,'\0',PACKSIZE);	
	Pack.IP_origem = PCM_myIP;
	Pack.PID_origem = PCM_myPID;
	Pack.Nseq = PCM_Nseq;
	memcpy(Pack.Data, Buffer, Bufsize);	
	size = PCM_copy_pack_buffer(&Pack,SendBuffer);
	
	val = sendto(Socket, SendBuffer, size, flag, Dest, Size);
	val = PCM_cache(&Pack);
	PCM_update_SM(&Pack);
	PCM_log_packet(&Pack,TRANSMIT);
	PCM_Nseq++;
	return val;
}

#ifdef ARGS_DECL_USED
int PCM_recv(int Socket, char *Buffer, int Bufsize, int flag)
#else /* ~ARGS_DECL_USED */
int PCM_recv(Socket, Buffer, Bufsize, flag)
	int Socket;
	char *Buffer;
	int Bufsize;
	int flag;
#endif /* ARGS_DECL_USED */
{
	int val,size;
	struct PCM_pack_struct Pack;
	char ReceiveBuffer[PACKSIZE];
	struct PCM_header_struct header;
	
	val = recv(Socket, ReceiveBuffer, PACKSIZE, flag);

	memcpy(&header,ReceiveBuffer,sizeof(header));

       	if ((header.IP == PCM_myIP)&&(header.PID == PCM_myPID)) return -1;

	if (!PCM_good_toss(PCM_conf_recv))
	  {
	    if (header.pnature == DATAPACK) printf("Perdi pacote...\n");
	    else printf("Perdi SM...\n");
	    return -1;
	  }

	if (header.pnature == DATAPACK)
	{
		size = PCM_copy_buffer_pack(&Pack,ReceiveBuffer);
		memcpy(Buffer, Pack.Data, Bufsize);
		val = PCM_cache(&Pack);
		PCM_update_SM(&Pack);
		PCM_log_packet(&Pack,RECEIVE);
	}
	else if (header.pnature == SMPACK)
	{
	        printf("Recebendo SM...\n");
		PCM_get_SM(ReceiveBuffer);
		val = -1;
	}
	return val;
}

#ifdef ARGS_DECL_USED
void PCM_update_SM(struct PCM_pack_struct *Pack)
#else /* ~ARGS_DECL_USED */
void PCM_update_SM(Pack)
	struct PCM_pack_struct *Pack;
#endif /* ARGS_DECL_USED */
{
	int encontrou,i,j,k;
	
	encontrou = 0;
	i = 0;
	
	while((!encontrou) && (i<SM_TABLE_SIZE))
	{
		if ((PCM_SM[i].IP == Pack->IP_origem) 
			&& (PCM_SM[i].PID == Pack->PID_origem)) encontrou=1;
		else if ((PCM_SM[i].IP == 0) && (PCM_SM[i].PID == 0))
		{
			PCM_SM[i].First = Pack->Nseq;
			PCM_SM[i].Last = Pack->Nseq;
			encontrou=1;
		}
		else i++;
	}
	
	/*
         * Nao ha espaco na SM (mais de SM_TABLE_SIZE membros no grupo
         *	multicast)
         */
	if (!encontrou) exit(1);
	
	PCM_SM[i].IP = Pack->IP_origem;
	PCM_SM[i].PID = Pack->PID_origem;
	
	if ((Pack->Nseq - PCM_SM[i].Last)==1) PCM_SM[i].Last = Pack->Nseq;
	
	else if ((Pack->Nseq - PCM_SM[i].Last)>1)
	{
		k = 0;
		for (j=PCM_SM[i].Last+1;j<Pack->Nseq;j++)
		{
			while ((PCM_SM[i].Lost[k]!=-1)&&(k<MAX_LOST)) k++;
			PCM_SM[i].Lost[k]=j;
			PCM_SM[i].Num_lost++;
		}
		PCM_SM[i].Last = Pack->Nseq;
	}
	
	else if (Pack->Nseq < PCM_SM[i].Last)
	{
		encontrou = 0;
		for (j=0;(j<MAX_LOST) && (!encontrou);j++)
			if (PCM_SM[i].Lost[j] == Pack->Nseq)
			{
				PCM_SM[i].Lost[j]=-1;
				PCM_SM[i].Num_lost--;
				encontrou=1;
			}
	}
}

#ifdef ARGS_DECL_USED
void PCM_initialize_SM(struct PCM_session_message *SM)
#else /* ~ARGS_DECL_USED */
void PCM_initialize_SM(SM)
	struct PCM_session_message *SM;
#endif /* ARGS_DECL_USED */
{
	int i,j;
	
	for (i=0;i<SM_TABLE_SIZE;i++)
	{
		SM[i].IP = 0;
		SM[i].PID = 0;
		SM[i].First = -1;
		SM[i].Last = -1;
		SM[i].Num_lost = 0;
		for (j=0;j<MAX_LOST;j++) SM[i].Lost[j]=-1;
	}	
}

#ifdef ARGS_DECL_USED
void PCM_send_SM(void)
#else /* ~ARGS_DECL_USED */
void PCM_send_SM()
#endif /* ARGS_DECL_USED */
{
        int size;
	char SendBuffer[SMSIZE];

	memset(SendBuffer,'\0',SMSIZE);
	size = PCM_copy_SM_buffer(PCM_SM,SendBuffer);
	
	sendto(PCM_socket,SendBuffer,size,0,
		(struct sockaddr *)&PCM_sockaddr,sizeof(PCM_sockaddr));
}		

#ifdef ARGS_DECL_USED
void PCM_get_SM(char *Buffer)
#else /* ~ARGS_DECL_USED */
void PCM_get_SM(Buffer)
	char *Buffer;
#endif /* ARGS_DECL_USED */
{
	struct PCM_session_message SM_AUX[SM_TABLE_SIZE];
	int encontrou,i,j,k,Lost;
	int size;
	
	j=0;
	PCM_initialize_SM(SM_AUX);
	size = PCM_copy_buffer_SM(SM_AUX,Buffer);

	while (PCM_SM[j].IP != 0)
	{
		i=0;
		encontrou=0;
		while((i<SM_TABLE_SIZE) && (!encontrou))
		{
			if ((PCM_SM[j].IP == SM_AUX[i].IP)
				&& (PCM_SM[j].PID == SM_AUX[i].PID)) encontrou=1;
			else i++;	
		}
		
		if (encontrou)
		{
			for (k=0;k<MAX_LOST;k++)
			{
				Lost = SM_AUX[i].Lost[k];
				if ((Lost != -1) && (PCM_SM[j].Last >= Lost))
				{
					PCM_retrans(SM_AUX[i].IP,SM_AUX[i].PID,Lost);
				}
			}
		
			if (PCM_SM[j].Last > SM_AUX[i].Last)
			{
				for (k=SM_AUX[i].Last+1;k<=PCM_SM[j].Last;k++)
				  {
					PCM_retrans(SM_AUX[i].IP,SM_AUX[i].PID,k);
				  }
			}
		}
		
		j++;
	}
}

#ifdef ARGS_DECL_USED
void PCM_retrans(int IP, int PID, int Nseq)
#else /* ~ARGS_DECL_USED */
void PCM_retrans(IP, PID, Nseq)
	int IP, PID, Nseq;
#endif /* ARGS_DECL_USED */
{
	int encontrou,i,size;
	char SendBuffer[PACKSIZE];
	struct PCM_pack_struct Pack;
	
	if (!PCM_good_toss(PCM_conf_send))
	  {
	    return;
	  }

	encontrou = 0;
	i = 0;
	
	printf ("Pedido de retrans para %d %d %d\n",IP,PID,Nseq);
	while ((!encontrou) && (i<HIST_SIZE))
	{
		if ((PCM_hist[i].IP_origem == IP) && (PCM_hist[i].PID_origem == PID)
			&& (PCM_hist[i].Nseq == Nseq)) encontrou=1;
		else i++;	
	}
	
	if (!encontrou)
	  {
	    printf("Nao possuo mais dado pedido no CACHE!\n");
	    return;
	  }
	  
	PCM_Nretrans++;
	
	memset(SendBuffer,'\0',PACKSIZE);
	Pack.IP_origem = IP;
	Pack.PID_origem = PID;
	Pack.Nseq = Nseq;
	memcpy(Pack.Data, PCM_hist[i].Data, DATASIZE);
	size = PCM_copy_pack_buffer(&Pack,SendBuffer);
	
	printf("Retransmitindo pacote...\n");
	sendto(PCM_socket,SendBuffer,size,0,
		(struct sockaddr *)&PCM_sockaddr,sizeof(PCM_sockaddr));
	PCM_log_packet(&Pack,RETRANSMIT);

}

#ifdef ARGS_DECL_USED
void PCM_initialize_hist(void)
#else /* ~ARGS_DECL_USED */
void PCM_initialize_hist()
#endif /* ARGS_DECL_USED */
{
	int i;
	for (i=0;i<HIST_SIZE;i++)
	{
		PCM_hist[i].IP_origem = 0;
		PCM_hist[i].PID_origem = 0;
		PCM_hist[i].Nseq = 0;
	}
}

#ifdef ARGS_DECL_USED
int PCM_good_toss(float ratio)
#else /* ~ARGS_DECL_USED */
int PCM_good_toss(ratio)
	float ratio;
#endif /* ARGS_DECL_USED */
{
	float valor;
	srand(time(NULL));
	valor = (float)rand()/RAND_MAX;
	
	if (valor <= ratio) return 1;
	else return 0;
}

#ifdef ARGS_DECL_USED
int PCM_copy_SM_buffer(struct PCM_session_message *SM, char *buffer)
#else /* ~ARGS_DECL_USED */
int PCM_copy_SM_buffer(SM, buffer)
	struct PCM_session_message *SM;
	char *buffer;
#endif /* ARGS_DECL_USED */
{
	int PosBuffer;
	int i,j;
	struct PCM_header_struct header;
	
	PosBuffer = 0;
	i = 0;
	while (SM[i].IP != 0) i++;	
	header.pnature = SMPACK;
	header.Num_blocs = i;
	header.IP = PCM_myIP;
	header.PID = PCM_myPID;
	header.timer = time(NULL);
	
	memcpy(buffer,&header,sizeof(header));
	PosBuffer = PosBuffer + sizeof(header);
		
	for (i=0;i<header.Num_blocs;i++)
	{
		memcpy(&buffer[PosBuffer],&SM[i],sizeof(int)*5);
		PosBuffer = PosBuffer + sizeof(int)*5;
		
		for (j=0;j<MAX_LOST;j++)
		{
			if (SM[i].Lost[j] != -1)
			{
				memcpy(&buffer[PosBuffer],&SM[i].Lost[j],sizeof(int));
				PosBuffer = PosBuffer + sizeof(int);
			}
		}
	}
	
	return PosBuffer;
}

#ifdef ARGS_DECL_USED
int PCM_copy_buffer_SM(struct PCM_session_message *SM, char *buffer)
#else /* ~ARGS_DECL_USED */
int PCM_copy_buffer_SM(SM, buffer)
	struct PCM_session_message *SM;
	char *buffer;
#endif /* ARGS_DECL_USED */
{
	int PosBuffer;
	int i,j;
	struct PCM_header_struct header;
	
	PosBuffer = 0;
	memcpy(&header,buffer,sizeof(header));
	PosBuffer = PosBuffer + sizeof(header);
	
	for (i=0;i<header.Num_blocs;i++)
	{
		memcpy(&SM[i],&buffer[PosBuffer],sizeof(int)*5);
		PosBuffer = PosBuffer + sizeof(int)*5;	

		for (j=0;j<SM[i].Num_lost;j++)
		{
			memcpy(&SM[i].Lost[j],&buffer[PosBuffer],sizeof(int));
			PosBuffer = PosBuffer + sizeof(int);
		}
	}
		
	return PosBuffer;
}

#ifdef ARGS_DECL_USED
int PCM_copy_pack_buffer(struct PCM_pack_struct *Pack, char *buffer)
#else /* ~ARGS_DECL_USED */
int PCM_copy_pack_buffer(Pack, buffer)
	struct PCM_pack_struct *Pack;
	char *buffer;
#endif /* ARGS_DECL_USED */
{
	int PosBuffer;
	struct PCM_header_struct header;
	
	PosBuffer = 0;
	header.pnature = DATAPACK;
	header.Num_blocs = 1;
	header.IP = PCM_myIP;
	header.PID = PCM_myPID;
	header.timer = time(NULL);
	
	memcpy(buffer,&header,sizeof(header));
	PosBuffer = PosBuffer + sizeof(header);
		
	memcpy(&buffer[PosBuffer],Pack,sizeof(int)*3);
	PosBuffer = PosBuffer + sizeof(int)*3;
	
	memcpy(&buffer[PosBuffer],Pack->Data,DATASIZE);
	PosBuffer = PosBuffer + DATASIZE;
	
	return PosBuffer;
}

#ifdef ARGS_DECL_USED
int PCM_copy_buffer_pack(struct PCM_pack_struct *Pack, char *buffer)
#else /* ~ARGS_DECL_USED */
int PCM_copy_buffer_pack(Pack, buffer)
	struct PCM_pack_struct *Pack;
	char *buffer;
#endif /* ARGS_DECL_USED */
{
	int PosBuffer;
	struct PCM_header_struct header;
	
	PosBuffer = 0;
	
	memcpy(&header,buffer,sizeof(header));
	PosBuffer = PosBuffer + sizeof(header);
		
	memcpy(Pack,&buffer[PosBuffer],sizeof(int)*3);
	PosBuffer = PosBuffer + sizeof(int)*3;
	
	memcpy(Pack->Data,&buffer[PosBuffer],DATASIZE);
	PosBuffer = PosBuffer + DATASIZE;
	
	return PosBuffer;
}

#endif /* _TGIF_WB2 */
