/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  char *STstrDots (const char Si[], int Maxchar)

Purpose:
  Generate a text with at most Maxchar characters (terminated with ...)

Description:
  This routine copies an input string to an output string.  The output string
  is at most Maxchar characters long.  If the input string is longer than
  Maxchar characters long, the algorithm below tries to truncate the line at
  a blank and add "..." to the output string.  The intention is that this
  routine be used in error messages.

  Let the length of the input string be N.  The maximum length of the output
  string is 80; let M = min(80,Maxchar).
  1: N <= M
    The output string is equal to the input string.
  2: N > M, M >= 20
    Look for a blank at positions [M-10, M-4] in the input string.  Call the
    position of the blank i.  Copy the first i+1 characters (includes the
    blank) of the input string to the output string.  If no blank is found,
    copy M-3 characters to the output string.  Append "..." to the output
    string.
  3: N > M, 6 <= M < 20
    Copy the first M-3 characters of the input string to the output string.
    Append "..." to the output string.
  4: N > M, M < 6
    Copy the first M characters of the input string to the output string.

  Examples:
      input : "It was the best of times, it was the worst"
               012345678901234567890123456789012345678901
               0         10       20        30        40 
        M = 60
      output: "It was the best of times, it was the worst"
        M = 40
      output: "It was the best of times, it was the ..."
        M = 20
      output: "It was the best ..."

      input : "Address http://www.TSP.EE.McGill.CA/software.html"
        M = 30
      output: "Address http://www.TSP.EE.M..."

Parameters:
 <-   char *STstrDots
      Output string.  This string is in an internally allocated area and is
      overwritten each time this routine is called.
   -> const char Si[]
      Input character string
   -> int Maxchar
      Maximum number of characters (not including the trailing null character)
      for the output string.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.1 $  $Date: 1997/03/03 22:35:48 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STstrDots.c 1.1 1997/03/03 libtsp-v3r0 $";

#include <string.h>
#include <libtsp/nucleus.h>

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define MAXM		80
#define MINM		20

char *
STstrDots (Si, Maxchar)

     const char Si[];
     int Maxchar;

{
  int nc, i, N, M;
  static char Line[MAXM+1];

  N = strlen (Si);
  M = MINV (MAXM, Maxchar);

  if (N <= M)
    /* No truncation */
    strcpy (Line, Si);

  else if (M >= MINM) {
    nc = M - 3;
    for (i = M-4; i >= M-10; --i) {
      if (Si[i] == ' ') {
	nc = i + 1;
	break;
      }
    }
    strncpy (Line, Si, nc);
    strcpy (&Line[nc], "...");
  }
  else if (M >= 6) {
    strncpy (Line, Si, M-3);
    strcpy (&Line[M-3], "...");
  }
  else {
    strncpy (Line, Si, M);
    Line[M] = '\0';
  }

  return Line;
}
