
/*
 * SPOOL.C	- Spool server state machine
 *
 * (c)Copyright 1998, Matthew Dillon, All Rights Reserved.  Refer to
 *    the COPYRIGHT file in the base directory of this distribution
 *    for specific rights granted.
 */

#include "defs.h"

Prototype void NNSpoolCommand1(Connection *conn);

void NNSpoolResponse1(Connection *conn);
void NNSpoolResponse2(Connection *conn);
void NNSpoolResponse3(Connection *conn);
void NNSpoolResponseScrap(Connection *conn);

void
NNSpoolCommand1(Connection *conn)
{
    ServReq *sreq = conn->co_SReq;

    printf("NNSpoolCommand1: article %s\n", sreq->sr_MsgId);

    MBPrintf(&conn->co_TMBuf, "article %s\r\n", sreq->sr_MsgId);
    NNSpoolResponse1(conn);
}

/*
 * Retrieve return code
 */

void
NNSpoolResponse1(Connection *conn)
{
    ServReq *sreq = conn->co_SReq;
    char *buf;
    int len;

    conn->co_Func = NNSpoolResponse1;
    conn->co_State = "spres1";

    if ((len = MBReadLine(&conn->co_RMBuf, &buf)) > 0) {
	if (strtol(buf, NULL, 10) == 220) {
	    /*
	     * sr_CConn may be NULL if client was terminated while
	     * server operation was still in progress.
	     */
	    if (conn->co_SReq->sr_CConn) {
		MBFree(&conn->co_SReq->sr_CConn->co_ArtBuf);

		switch(sreq->sr_CConn->co_ArtMode) {
		case COM_BODYNOSTAT:
		    break;
		case COM_STAT:
		case COM_HEAD:
		case COM_BODY:
		case COM_ARTICLE:
		    MBPrintf(&sreq->sr_CConn->co_ArtBuf, "%03d 0 %s %s\r\n",
			GoodRC(sreq->sr_CConn),
			sreq->sr_MsgId,
			GoodResId(sreq->sr_CConn)
		    );
		    break;
		case COM_BODYWVF:
		    MBPrintf(&sreq->sr_CConn->co_ArtBuf, "%03d %d %s %s\r\n",
			GoodRC(sreq->sr_CConn),
			sreq->sr_CConn->co_ArtNo,
			sreq->sr_MsgId,
			GoodResId(sreq->sr_CConn)
		    );
		    break;
		case COM_ARTICLEWVF:
		    {
			const char *ovdata;
			const char *msgid;
			int ovlen;

			if ((ovdata = NNRetrieveHead(sreq->sr_CConn, &ovlen, &msgid)) != NULL) {
			    MBPrintf(&sreq->sr_CConn->co_TMBuf, "%03d %d %s %s\r\n",
				GoodRC(sreq->sr_CConn),
				sreq->sr_CConn->co_ArtNo,
				sreq->sr_MsgId,
				GoodResId(sreq->sr_CConn)
			    );
			    DumpOVHeaders(sreq->sr_CConn, ovdata, ovlen);
			    MBPrintf(&sreq->sr_CConn->co_TMBuf, "\r\n"); 
			    sreq->sr_CConn->co_ArtMode = COM_BODYNOSTAT;
			} else {
			    NNSpoolResponseScrap(conn);
			    return; /* bleh */
			}
		    }
		    break;
		}
	    }
	    NNSpoolResponse2(conn);
	    return;
	}
	if (sreq->sr_CConn == NULL)
	    NNFinishSReq(conn, NULL, 0);
	else if (sreq->sr_CConn->co_ArtMode == COM_BODYNOSTAT)
	    NNFinishSReq(conn, "(article not available)\r\n.\r\n", 1);
	else
	    NNFinishSReq(conn, "430 No such article\r\n", 1);
    } else if (len < 0) {
	NNServerTerminate(conn);
    } /* else we haven't got the response yet */
}

/*
 * Retrieve headers
 */

void
NNSpoolResponse2(Connection *conn)
{
    char *buf;
    int len;
    ServReq *sreq = conn->co_SReq;

    conn->co_Func = NNSpoolResponse2;
    conn->co_State = "spres2";

    while ((len = MBReadLine(&conn->co_RMBuf, &buf)) > 0) {
	if (len == 2 && strcmp(buf, "\r") == 0) {
	    if (sreq->sr_Cache)
		fwrite("\r\n", 1, 2, sreq->sr_Cache);

	    if (sreq->sr_CConn) {
		switch(sreq->sr_CConn->co_ArtMode) {
		case COM_ARTICLE:
		    MBPrintf(&sreq->sr_CConn->co_ArtBuf, "\r\n");
		    break;
		}
	    }
	    NNSpoolResponse3(conn);
	    return;
	}
	if (len == 3 && strcmp(buf, ".\r") == 0) {
	    if (sreq->sr_CConn == NULL)
		NNFinishSReq(conn, NULL, 0);
	    else if (sreq->sr_CConn->co_ArtMode == COM_BODYNOSTAT)
		NNFinishSReq(conn, "(article not available)\r\n.\r\n", 1);
	    else
		NNFinishSReq(conn, "430 No such article\r\n", 1);
	    return;
	}

	/*
	 * do not include Xref: headers, the wrong Xref: header can blow up
	 * news readers.
	 */

	if (strncasecmp(buf, "Xref:", 5) == 0 && ValidXRef(buf, len) < 0)
	    len = 0;

	if (len) {
	    buf[len-1] = '\n';

	    if (sreq->sr_Cache)
		fwrite(buf, 1, len, sreq->sr_Cache);

	    /*
	     * sr_CConn may be NULL if the client terminated or if an
	     * autonomous lookahead request was issued.
	     */

	    if (sreq->sr_CConn) {
		switch(sreq->sr_CConn->co_ArtMode) {
		case COM_HEAD:
		case COM_ARTICLE:
		    MBWrite(&sreq->sr_CConn->co_ArtBuf, buf, len);
		    break;
		}
	    }
	}

    }
    if (len < 0) {
	NNServerTerminate(conn);
    } /* else we are still waiting for input */
}

/*
 * Retrieve the body, place in client's ArtBuf
 */

void
NNSpoolResponse3(Connection *conn)
{
    char *buf;
    ServReq *sreq = conn->co_SReq;

    conn->co_Func = NNSpoolResponse3;
    conn->co_State = "spres3";

    for (;;) {
	int len = MBReadLine(&conn->co_RMBuf, &buf);
	int error = 0;

	/*
	 * If an error occurs and we are not in FastCopyOpt mode,
	 * we can simply terminate the server and the request will be
	 * retried.  If we are an FastCopyOpt mode we have already 
	 * started writing the article back to the client and cannot
	 * simply cut things off.  We simulate an ending, make sure
	 * we do not commit the article to the cache, and *then*
	 * terminate the server.
	 */

	if (len < 0) {
	    if (FastCopyOpt == 0) {
		NNServerTerminate(conn);
		return;
	    }
	    len = 3;
	    buf = ".\r";
	    error = 1;
	}

	/*
	 * If len is 0, we have nothing to do
	 */

	if (len == 0)
	    break;


	if (len == 3 && strcmp(buf, ".\r") == 0) {
	    if (sreq->sr_CConn) {
		MBCopy(
		    &sreq->sr_CConn->co_ArtBuf,
		    &sreq->sr_CConn->co_TMBuf
		);
	    }
	    if (sreq->sr_Cache) {
		fflush(sreq->sr_Cache);
		if (ferror(sreq->sr_Cache) || error)
		    AbortCache(fileno(sreq->sr_Cache), sreq->sr_MsgId, 0);
		else
		    CommitCache(fileno(sreq->sr_Cache), sreq->sr_MsgId, 0);
		fclose(sreq->sr_Cache);
		sreq->sr_Cache = NULL;
	    }
	    if (sreq->sr_CConn == NULL) {
		NNFinishSReq(conn, NULL, 0);
	    } else {
		switch(sreq->sr_CConn->co_ArtMode) {
		case COM_ARTICLE:
		case COM_BODY:
		case COM_BODYWVF:
		case COM_BODYNOSTAT:
		case COM_HEAD:
		    if (error)
			MBPrintf(&sreq->sr_CConn->co_TMBuf, "(spool server died prior to completion of the article dump)\r\n");
		    NNFinishSReq(conn, ".\r\n", 0);
		    break;
		case COM_STAT:
		    NNFinishSReq(conn, "", 0);
		    break;
		default:
		    NNFinishSReq(conn, "(something blew up in the spool code)\r\n.\r\n", 0);
		    break;
		}
	    }

	    /*
	     * If an error occured ( can only happen if we were in FastCopyOpt
	     * mode ), we have to terminate the server now, after we've
	     * finished processing the client request.
	     */
	    if (error) {
		NNServerTerminate(conn);
	    }
	    return;
	}
	if (len > 0)
	    buf[len-1] = '\n';

	if (sreq->sr_CConn) {
	    switch(sreq->sr_CConn->co_ArtMode) {
	    case COM_ARTICLE:
	    case COM_BODY:
	    case COM_BODYWVF:
	    case COM_BODYNOSTAT:
		MBWrite(&sreq->sr_CConn->co_ArtBuf, buf, len);
		break;
	    }
	}
	if (sreq->sr_Cache)
	    fwrite(buf, 1, len, sreq->sr_Cache);
    }
    if (FastCopyOpt && sreq->sr_CConn) {
        MBCopy(
            &sreq->sr_CConn->co_ArtBuf,
            &sreq->sr_CConn->co_TMBuf
        );
    }
    /* still waiting for input */
}

void
NNSpoolResponseScrap(Connection *conn)
{
    char *buf;
    int len;
    ServReq *sreq = conn->co_SReq;

    conn->co_Func = NNSpoolResponse3;
    conn->co_State = "spres3";

    while ((len = MBReadLine(&conn->co_RMBuf, &buf)) > 0) {
	if (len == 3 && strcmp(buf, ".\r") == 0) {
	    if (sreq->sr_Cache) {
		fflush(sreq->sr_Cache);
		if (ferror(sreq->sr_Cache))
		    AbortCache(fileno(sreq->sr_Cache), sreq->sr_MsgId, 0);
		else
		    CommitCache(fileno(sreq->sr_Cache), sreq->sr_MsgId, 0);
		fclose(sreq->sr_Cache);
		sreq->sr_Cache = NULL;
	    }
	    if (sreq->sr_CConn == NULL)
		NNFinishSReq(conn, NULL, 0);
	    else
		NNFinishSReq(conn, "430 No such article\r\n", 1);
	    return;
	}
    }
    if (len < 0) {
	NNServerTerminate(conn);
    } /* else we are still waiting for input */
}

