/********************************************************************************
* Copyright (c) Erik Kunze 1998 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if defined(AIX) && !defined(NAS_AUDIO) && !defined(OSS_AUDIO)
#ifndef lint
static char rcsid[] = "$Id: aix.c,v 1.3 1999/03/16 11:35:38 erik Rel $";
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include <UMS/UMSAudioDevice.h>
#include <UMS/UMSBAUDDevice.h>
#include <errno.h>
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "main.h"
#include "audio.h"
static UMSAudioDeviceMClass audio_device_class;
static UMSAudioDevice_ReturnCode rc;
static UMSBAUDDevice audio_device = (UMSBAUDDevice)-1;
static Environment *ev;
static UMSAudioTypes_Buffer buffer;
static UMSAudioDeviceMClass_ErrorCode audio_device_class_error;
static sigset_t blockingSet;
int
OsdOpenAudioDevice(char *device, int sample)
{
long outSample;
ev = somGetGlobalEnvironment();
audio_device = UMSBAUDDeviceNew();
rc = UMSAudioDevice_open(audio_device, ev, "/dev/paud0", "PLAY",
UMSAudioDevice_BlockingIO);
if (audio_device == (UMSBAUDDevice)0)
{
Msg(M_ERR, "couldn't create audio device object");
return -1;
}
rc = UMSAudioDevice_set_volume(audio_device, ev, 100);
rc = UMSAudioDevice_set_balance(audio_device, ev, 0);
rc = UMSAudioDevice_set_time_format(audio_device, ev, UMSAudioTypes_Msecs);
rc = UMSAudioDevice_set_byte_order(audio_device, ev, "LSB");
rc = UMSAudioDevice_set_bits_per_sample(audio_device, ev, 8);
rc = UMSAudioDevice_set_audio_format_type(audio_device, ev, "PCM");
rc = UMSAudioDevice_set_number_format(audio_device, ev, "TWOS_COMPLEMENT");
rc = UMSAudioDevice_set_sample_rate(audio_device, ev, sample, &outSample);
rc = UMSAudioDevice_set_number_of_channels(audio_device, ev, 1);
sigemptyset(&blockingSet);
sigaddset(&blockingSet, SIGALRM);
return (int)outSample;
}
void
OsdCloseAudioDevice(void)
{
if (audio_device != (UMSBAUDDevice)-1)
{
rc = UMSAudioDevice_play_remaining_data(audio_device, ev, TRUE);
UMSAudioDevice_stop(audio_device, ev);
UMSAudioDevice_close(audio_device, ev);
_somFree(audio_device);
audio_device = (UMSBAUDDevice)-1;
}
}
int
OsdDrainAudioDevice(void)
{
return 0;
}
size_t
OsdGetAudioFreespace(void)
{
int i = -1;
rc = UMSAudioDevice_write_buff_remain(audio_device, ev, &i);
return (size_t)(i < 0 ? -1 : i);
}
size_t
OsdPlayAudioBuffer(unsigned char *buf, size_t len)
{
sigset_t oldSet;
int written;
(void)sigprocmask(SIG_BLOCK, &blockingSet, &oldSet);
rc = UMSAudioDevice_write(audio_device, ev, &buf, len, &written);
if (!sigismember(&oldSet, SIGALRM))
{
(void)sigprocmask(SIG_UNBLOCK, &blockingSet, NULL);
}
return (size_t)written;
}
#endif
