/********************************************************************************
* Copyright (c) Erik Kunze 1996 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#ifdef AUDIO
#ifndef lint
static char rcsid[] = "$Id: audio.c,v 1.12 1999/04/09 08:39:34 erik Rel $";
#endif
#include <string.h>
#ifdef HAVE_MEMORY_H
# include <memory.h>
#endif
#include "debug.h"
#include "resource.h"
#include "machine.h"
#include "util.h"
#include "audio.h"
#define AU_MIX(a,b)		(((a) + (b)) >> 1)
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
static void audioDummyOutByte(void);
#endif
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
AudioSettings Audio;
#endif
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
void
AudioInit(void)
{
int sample;
memset(&Audio, 0, sizeof(Audio));
#ifdef SPEAKER_AUDIO
SpeakerOutByte = (void (*)(uns8))audioDummyOutByte;
#endif
#ifdef AYCHIP_AUDIO
AyOutByte = (void (*)(uns8, uns8))audioDummyOutByte;
#endif
sample = OsdOpenAudioDevice(GETCFG(audioDevice), GETCFG(audioSample));
if (sample <= 0)
{
Msg(M_WARN, "audio initialisation failed");
OsdCloseAudioDevice();
SETCFG(audioActive, -1);
return;
}
SETCFG(audioSample, sample);
Audio.active = 1;
Audio.sampleRate = sample;
Audio.samplesPerFrame =
Audio.sampleRate * 2 / (GETCFG(speed) ? GETCFG(speed) : 100);
Audio.tstatesPerSample =
Machine->tstatesPerFrame / Audio.samplesPerFrame;
DEB(Msg(M_DEBUG, "AU: sampleRate %11u", Audio.sampleRate);
Msg(M_DEBUG, "AU: tstatesPerSample %5u", Audio.tstatesPerSample);
Msg(M_DEBUG, "AU: samplesPerFrame %6u", Audio.samplesPerFrame););
#ifdef SPEAKER_AUDIO
SpeakerInit();
if ((Audio.spOn = GETCFG(audioActive)))
{
Audio.spVol = 2;
if (!GETCFG(fast))
{
SpeakerOutByte = SpeakerOut;
}
}
#endif
#ifdef AYCHIP_AUDIO
AyInit();
if ((Audio.ayOn = GETCFG(audioActive)))
{
Audio.ayVol = 4;
if (!GETCFG(fast))
{
AyOutByte = AyOut;
}
}
#endif
#ifdef REGISTERED
MixerInit();
#endif
}
#else
void
AudioInit(void)
{
}
#endif
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
void
AudioControl(int cmd)
{
if (!Audio.active)
{
return;
}
switch (cmd)
{
case AUC_REINIT:
Audio.samplesPerFrame =
Audio.sampleRate * 2 / (GETCFG(speed) ? GETCFG(speed) : 100);
Audio.tstatesPerSample =
Machine->tstatesPerFrame / Audio.samplesPerFrame;
DEB(Msg(M_DEBUG,
"AU: tstatesPerSample %5u", Audio.tstatesPerSample);
Msg(M_DEBUG,
"AU: samplesPerFrame %6u", Audio.samplesPerFrame););
#ifdef SPEAKER_AUDIO
SpeakerReInit();
#endif
#ifdef AYCHIP_AUDIO
AyReInit();
#endif
#ifdef REGISTERED
MixerReInit();
#endif
break;
case AUC_ON:
(void)OsdDrainAudioDevice();
break;
case AUC_OFF:
break;
case AUC_FASTON:
#ifdef SPEAKER_AUDIO
SpeakerOutByte = (void (*)(uns8))audioDummyOutByte;
#endif
#ifdef AYCHIP_AUDIO
AyOutByte = (void (*)(uns8, uns8))audioDummyOutByte;
#endif
break;
case AUC_FASTOFF:
#ifdef SPEAKER_AUDIO
if (Audio.spOn)
{
SpeakerOutByte = SpeakerOut;
}
#endif
#ifdef AYCHIP_AUDIO
if (Audio.ayOn)
{
AyOutByte = AyOut;
}
#endif
break;
#ifdef SPEAKER_AUDIO
case AUC_SPON:
Audio.spOn = 1;
if (!GETCFG(fast))
{
SpeakerOutByte = SpeakerOut;
}
break;
case AUC_SPOFF:
Audio.spOn = 0;
if (!GETCFG(fast))
{
SpeakerOutByte = (void (*)(uns8))audioDummyOutByte;
}
break;
#endif
#ifdef AYCHIP_AUDIO
case AUC_AYON:
Audio.ayOn = 1;
if (!GETCFG(fast))
{
AyOutByte = AyOut;
}
break;
case AUC_AYOFF:
Audio.ayOn = 0;
if (!GETCFG(fast))
{
AyOutByte = (void (*)(uns8, uns8))audioDummyOutByte;
}
break;
#endif
}
}
#endif
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
void
AudioPlayBuffer(void)
{
#ifdef REGISTERED
MixerPlayBuffer();
#else
unsigned char *buf;
if (!Audio.active || GETCFG(fast))
{
return;
}
buf = NULL;
#ifdef SPEAKER_AUDIO
SpeakerFillBuffer();
if (Audio.spOn)
{
buf = Audio.spBuf;
}
#endif
#ifdef AYCHIP_AUDIO
AyFillBuffer();
if (Audio.ayOn)
{
buf = Audio.ayBuf;
}
#endif
if (buf && GETCFG(speed))
{
#if defined(SPEAKER_AUDIO) && defined(AYCHIP_AUDIO)
if (Audio.spOn && Audio.ayOn)
{
unsigned char *bp1 = &(Audio.spBuf[Audio.samplesPerFrame - 1]);
unsigned char *bp2 = &(Audio.ayBuf[Audio.samplesPerFrame - 1]);
while (bp2 >= buf)
{
*bp2 = AU_MIX(*bp1, *bp2);
bp1--;
bp2--;
}
}
#endif
if (OsdPlayAudioBuffer(buf, (size_t)Audio.samplesPerFrame) !=
(size_t)Audio.samplesPerFrame)
{
Msg(M_ERR, "couldn't write all bytes to audio device");
}
}
#endif
}
#endif
#if defined(SPEAKER_AUDIO) || defined(AYCHIP_AUDIO)
static void
audioDummyOutByte(void)
{
}
#endif
#endif
