/********************************************************************************
* Copyright (c) Erik Kunze   1998 - 1999
*               Andrew Petry 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Erik Kunze
*          Andrew Petry
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if defined(sun) && !defined(SYSV) && !defined(NAS_AUDIO) && !defined(OSS_AUDIO)
#ifndef lint
static char rcsid[] = "$Id: sunos.c,v 1.11 1999/03/30 20:06:40 erik Rel $";
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include <sun/audioio.h>
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "lin2ulaw.h"
#include "audio.h"
#define ABSDIFF(x,y)	((x > y) ? (x - y) : (y - x))
#define NELEM(a)		(sizeof(a) / sizeof(a[0]))
#ifdef DEBUG
#define DEB(x)			{ if (GETCFG(debug) & D_AUDIO) { x } }
#else
#define DEB(x)
#endif
static int audioFd = -1;
static sigset_t blockingSet;
#ifdef AUDIO_GETDEV
static unsigned int samprates[11] = {
8000, 9600, 11025, 16000, 18900, 22050, 32000, 37800, 44100, 48000, 100000
};
#endif
int
OsdOpenAudioDevice(char *device, int sample)
{
#ifdef AUDIO_GETDEV
int audioDev;
audio_info_t audioInf;
#endif
if ((audioFd = open(device, O_WRONLY | O_NDELAY | O_NONBLOCK)) < 0)
{
Msg(M_PERR, "couldn't open audio device <%s> for writing", device);
return -1;
}
(void)ioctl(audioFd, AUDIO_DRAIN, 0);
#ifdef AUDIO_GETDEV
if (ioctl(audioFd, AUDIO_GETDEV, &audioDev) < 0)
{
Msg(M_PERR, "couldn't get audio device type");
goto error;
}
DEB(Msg(M_DEBUG, "AU: audio device is %d (%s)",
audioDev,
audioDev == 1 ? "AMD" :
audioDev == 2 ? "Dbri with speakerbox" :
audioDev == 3 ? "Dbri with internal speaker" : "unknown"););
if (ioctl(audioFd, AUDIO_GETINFO, &audioInf) < 0)
{
Msg(M_PERR, "couldn't get audio settings");
goto error;
}
DEB(Msg(M_DEBUG, "AU: sample rate      %d", audioInf.play.sample_rate);
Msg(M_DEBUG, "AU: channels         %d", audioInf.play.channels);
Msg(M_DEBUG, "AU: precision        %d", audioInf.play.precision);
Msg(M_DEBUG, "AU: encoding         %d", audioInf.play.encoding););
if (audioDev == AUDIO_DEV_AMD)
{
if (sample != 8000)
{
Msg(M_WARN, "audio device supports 8000 Hz sample rate only");
sample = 8000;
}
}
else
{
int i, j, k;
j = 50000;
for (i = 0; i < NELEM(samprates); i++)
{
if (!(k = ABSDIFF(sample, samprates[i])))
{
break;
}
else
{
if (k > j)
{
Msg(M_WARN, "sample rate set to nearest legal value %d",
samprates[i - 1]);
sample = samprates[i - 1];
break;
}
j = k;
}
}
}
AUDIO_INITINFO(&audioInf);
audioInf.play.sample_rate = sample;
audioInf.play.channels = 1;
audioInf.play.precision = 8;
audioInf.play.encoding = AUDIO_ENCODING_ULAW;
if (ioctl(audioFd, AUDIO_SETINFO, &audioInf) < 0)
{
Msg(M_PERR, "couldn't initialise audio device");
goto error;
}
#else
DEB(Msg(M_DEBUG, "AU: audio device is AMD 79c30 (old version)");
Msg(M_DEBUG, "AU: sample rate      8000");
Msg(M_DEBUG, "AU: channels         1");
Msg(M_DEBUG, "AU: precision        8");
Msg(M_DEBUG, "AU: encoding         1"););
if (sample != 8000)
{
Msg(M_WARN, "this audio device supports 8000 Hz sample rate only");
sample = 8000;
}
#endif
sigemptyset(&blockingSet);
sigaddset(&blockingSet, SIGALRM);
return sample;
error:
(void)close(audioFd);
audioFd = -1;
return -1;
}
void
OsdCloseAudioDevice(void)
{
if (audioFd != -1)
{
(void)close(audioFd);
audioFd = -1;
}
}
int
OsdDrainAudioDevice(void)
{
return (ioctl(audioFd, AUDIO_DRAIN, 0));
}
size_t
OsdGetAudioFreespace(void)
{
return (size_t)1024;
}
size_t
OsdPlayAudioBuffer(unsigned char *buf, size_t len)
{
sigset_t oldSet;
size_t written, i;
for (i = 0; i < len; i++)
{
buf[i] = Lin2Ulaw[buf[i] ^ 0x80];
}
(void)sigprocmask(SIG_BLOCK, &blockingSet, &oldSet);
if ((written = write(audioFd, buf, len)) < 0)
{
Msg(M_PERR, "couldn't write to audio device");
}
if (!sigismember(&oldSet, SIGALRM))
{
(void)sigprocmask(SIG_UNBLOCK, &blockingSet, NULL);
}
return written;
}
#endif
