/********************************************************************************
* Copyright (c) Erik Kunze 1999
*
* The archive is a part of the registered Spectrum emulator package 'XZX',
* and may not be distributed.  The copyright holder makes no representations
* about the suitability of this software for any purpose.  It is provided "as
* is" without express or implied warranty. THE CODE MAY NOT BE MODIFIED OR
* REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
static char rcsid[] = "$Id: breakpoint.c,v 1.2 1999/01/14 16:54:34 erik Rel $";
#include <stdio.h>
#include <assert.h>
#include "mem.h"
#include "util.h"
#include "dis.h"
#include "breakpoint.h"
static int bpCompare(void *, void *);
static Llist *breakpointList = (Llist *)0;
static unsigned int breakpointCount = 0;
unsigned int
BpSet(int page, uns16 addr)
{
Breakpoint *bpp;
unsigned int bpno;
uns8 opcode[4];
int bytes, address;
if ((bpno = BpLookup(page, addr)) != -1U)
{
return -1U;
}
bpp = (Breakpoint *)Malloc(sizeof(Breakpoint), "BpSet");
breakpointList = AppendElemList(breakpointList, (void *)bpp);
breakpointCount++;
bpp->page = page;
bpp->addr = addr;
address = addr;
for (bytes = 0; bytes < 4 && address <= 0x3fff; bytes++, address++)
{
opcode[bytes] = RealMemory[page][address];
}
bytes = Disassemble2(bpp->opstr, opcode, addr);
if ((int)addr + bytes > 0x3fff)
{
bpp->opstr[0] = '?';
bpp->opstr[1] = '\0';
}
bpp->opcode = RealMemory[page][addr];
RealMemory[page][addr] = 0xc7;
return (breakpointCount - 1);
}
void
BpUnset(unsigned int bpno)
{
Breakpoint *bpp;
bpp = (Breakpoint *)RetrieveElemList(breakpointList, bpno);
assert(bpp != (Breakpoint *)0);
RealMemory[bpp->page][bpp->addr] = bpp->opcode;
breakpointList = RemoveElemList(bpp, bpCompare, breakpointList, NULL);
breakpointCount--;
}
unsigned int
BpUnsetAll(void)
{
unsigned int bpno;
for (bpno = 0; bpno < breakpointCount; bpno++)
{
BpUnset(bpno);
}
return bpno;
}
void
BpDestroy(unsigned int bpno)
{
Breakpoint *bpp;
bpp = (Breakpoint *)RetrieveElemList(breakpointList, bpno);
assert(bpp != (Breakpoint *)0);
breakpointList = RemoveElemList(bpp, bpCompare, breakpointList, NULL);
breakpointCount--;
}
unsigned int
BpDestroyAll(void)
{
unsigned int bpno = breakpointCount;
DestroyList(breakpointList, NULL);
breakpointList = (Llist *)0;
breakpointCount = 0;
return bpno;
}
Breakpoint *
BpRetrieve(unsigned int bpno)
{
return ((Breakpoint *)RetrieveElemList(breakpointList, bpno));
}
unsigned int
BpLookup(int page, uns16 addr)
{
Breakpoint *bp;
unsigned int bpno;
for (bpno = 0; bpno < breakpointCount; bpno++)
{
bp = (Breakpoint *)RetrieveElemList(breakpointList, bpno);
assert(bp != (Breakpoint *)0);
if (bp->page == page && bp->addr == addr)
{
return bpno;
}
}
return -1U;
}
static int
bpCompare(void *bpp1, void *bpp2)
{
return (!(((Breakpoint *)bpp1)->page == ((Breakpoint *)bpp2)->page
&& ((Breakpoint *)bpp1)->addr == ((Breakpoint *)bpp2)->addr));
}
