/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Martin Smith (msmith@lssec.bt.co.uk)
*          Erik Kunze
*
* $Id: if1.h,v 4.14 1998/11/16 17:53:51 erik Rel $
*******************************************************************************/
#ifndef _XZX_IF1_H
#define _XZX_IF1_H
#include "resource.h"
#include "mem.h"
#include "io.h"
#include "machine.h"
#define RS232_IP_BPT	0xfe
#define RS232_OP_BPT	0xff
#define CHECK_AND_PAGEIN_IF1(pc) \
{																		\
\
if (GETCFG(if1Active) > 0											\
&& ((pc) == 0x0008 || (pc) == 0x1708)							\
&& RPAGE(0) == Machine->basicRom)								\
{																	\
Machine->pageIn(0, IF1ROM);										\
}																	\
}
#define CHECK_AND_PAGEOUT_IF1(pc) \
{																		\
\
if (GETCFG(if1Active) > 0											\
&& (pc) == 0x0700												\
&& RPAGE(0) == IF1ROM)											\
{																	\
Machine->pageIn(0, Machine->basicRom);							\
}																	\
}
#define OUTBYTE_IF1(port, val) \
{																		\
if (GETCFG(if1Active) > 0)											\
{																	\
if (LOWBYTE(port) == P_MDCONTROL)								\
{																\
If1ControlOutByte(val);										\
}																\
else if (LOWBYTE(port) == P_MDDATA)								\
{																\
If1DataOutByte(val);										\
}																\
}																	\
}
#define INBYTE_IF1(port) \
{																		\
if (GETCFG(if1Active) > 0)											\
{																	\
if (LOWBYTE(port) == P_MDCONTROL)								\
{																\
return (If1ControlInByte());								\
}																\
else if (LOWBYTE(port) == P_MDDATA)								\
{																\
return (If1DataInByte());									\
}																\
}																	\
}
extern void If1Init(void);
extern int If1InsertCart(int);
extern void If1EjectCart(int);
extern char *If1CartName(int);
extern void If1ControlOutByte(uns8);
extern void If1DataOutByte(uns8);
extern uns8 If1ControlInByte(void);
extern uns8 If1DataInByte(void);
extern void If1Rs232In(void);
extern void If1Rs232Out(void);
#endif
