/********************************************************************************
* Copyright (c) Des Herriott 1993, 1994
*               Erik Kunze   1995 - 1999
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Authors: Des Herriott
*          Erik Kunze
*******************************************************************************/
#ifndef lint
static char z80_edops_c[] = "$Id: z80_edops.c,v 4.19 1999/01/14 16:59:54 erik Rel $";
#endif
#define LD_NN_DD(regh, regl) \
{																		\
uns16 t16 = Z80_RDMEM(PC++);										\
t16 |= Z80_RDMEM(PC++) << 8;										\
Z80_WRMEM(t16++, (regl));											\
Z80_WRMEM(t16, (regh));												\
}
#define LD_DD_NN(regh, regl) \
{																		\
uns16 t16 = Z80_RDMEM(PC++);										\
t16 |= Z80_RDMEM(PC++) << 8;										\
(regl) = Z80_RDMEM(t16++);											\
(regh) = Z80_RDMEM(t16);											\
}
#define ADC_HL(reg) \
{																		\
uns32 temp32 = HL + (reg) + (F & C_FLAG);							\
uns8 idx = ((HL & 0x8800) >> 9) |									\
(((reg) & 0x8800) >> 10) |								\
((temp32 & 0x8800) >> 11);								\
HL = (uns16)temp32;													\
F = (H & (S_FLAG | B5_FLAG | B3_FLAG)) |							\
(HL ? 0 : Z_FLAG) |												\
halfCarryTbl[idx & 0x7] |										\
overflowTbl[idx >> 4] |											\
(temp32 & 0x10000 ? C_FLAG : 0);								\
}
#define SBC_HL(reg) \
{																		\
uns32 temp32 = HL - (reg) - (F & C_FLAG);							\
uns8 idx = ((HL & 0x8800) >> 9) |									\
(((reg) & 0x8800) >> 10) |								\
((temp32 & 0x8800) >> 11);								\
HL = (uns16)temp32;													\
F = (H & (S_FLAG | B5_FLAG | B3_FLAG)) |							\
(HL ? 0 : Z_FLAG) |												\
subHalfCarryTbl[idx & 0x7] |									\
subOverflowTbl[idx >> 4] |										\
N_FLAG |														\
(temp32 & 0x10000 ? C_FLAG : 0);								\
}
#define IN(reg) \
{																		\
(reg) = Z80_IN(BC);													\
F = (F & C_FLAG) | SZ53P((reg));									\
}
#define OUT(reg) \
{																		\
Z80_OUT(BC, (reg));													\
}
case 0x40:
TSTATES += 12;
IN(B);
break;
case 0x41:
TSTATES += 12;
OUT(B);
break;
case 0x42:
TSTATES += 15;
SBC_HL(BC);
break;
case 0x43:
TSTATES += 20;
LD_NN_DD(B, C);
break;
case 0x44:
case 0x4c:
case 0x54:
case 0x5c:
case 0x64:
case 0x6c:
case 0x74:
case 0x7c:
TSTATES += 8;
{
uns8 t8 = A;
A = 0;
SUB(t8);
}
break;
case 0x45:
case 0x55:
case 0x5d:
case 0x65:
case 0x6d:
case 0x75:
case 0x7d:
TSTATES += 14;
RETN();
break;
case 0x46:
case 0x4e:
case 0x66:
case 0x6e:
TSTATES += 8;
IM = 0;
break;
case 0x47:
TSTATES += 9;
I = A;
break;
case 0x48:
TSTATES += 12;
IN(C);
break;
case 0x49:
TSTATES += 12;
OUT(C);
break;
case 0x4A:
TSTATES += 15;
ADC_HL(BC);
break;
case 0x4B:
TSTATES += 20;
LD_DD_NN(B, C);
break;
case 0x4D:
TSTATES += 14;
RETN();
break;
case 0x4F:
TSTATES += 9;
#ifdef DEBUG_R_REGISTER
Msg(M_DEBUG, "ld r,a at %04x", PC - 2);
#endif
R = A;
R7 = R & 0x80;
break;
case 0x50:
TSTATES += 12;
IN(D);
break;
case 0x51:
TSTATES += 12;
OUT(D);
break;
case 0x52:
TSTATES += 15;
SBC_HL(DE);
break;
case 0x53:
TSTATES += 20;
LD_NN_DD(D, E);
break;
case 0x56:
case 0x76:
TSTATES += 8;
IM = 1;
break;
case 0x57:
TSTATES += 9;
A = I;
F = (F & C_FLAG) | SZ53(A) | (IFF2 ? P_FLAG : 0);
break;
case 0x58:
TSTATES += 12;
IN(E);
break;
case 0x59:
TSTATES += 12;
OUT(E);
break;
case 0x5A:
TSTATES += 15;
ADC_HL(DE);
break;
case 0x5B:
TSTATES += 20;
LD_DD_NN(D, E);
break;
case 0x5E:
case 0x7e:
TSTATES += 8;
IM = 2;
break;
case 0x5F:
TSTATES += 9;
#ifdef DEBUG_R_REGISTER
Msg(M_DEBUG, "ld a,r at %04x", PC - 2);
#endif
A = (R & 0x7f) | R7;
F = (F & C_FLAG) | SZ53(A) | (IFF2 ? P_FLAG : 0);
break;
case 0x60:
TSTATES += 12;
IN(H);
break;
case 0x61:
TSTATES += 12;
OUT(H);
break;
case 0x62:
TSTATES += 15;
SBC_HL(HL);
break;
case 0x63:
TSTATES += 20;
LD_NN_DD(H, L);
break;
case 0x67:
TSTATES += 18;
{
uns8 t8 = Z80_RDMEM(HL);
Z80_WRMEM(HL, (t8 >> 4) | (A << 4));
A = (A & 0xf0) | (t8 & 0x0f);
}
F = (F & C_FLAG) | SZ53P(A);
break;
case 0x68:
TSTATES += 12;
IN(L);
break;
case 0x69:
TSTATES += 12;
OUT(L);
break;
case 0x6A:
TSTATES += 15;
ADC_HL(HL);
break;
case 0x6B:
TSTATES += 20;
LD_DD_NN(H, L);
break;
case 0x6F:
TSTATES += 18;
{
uns8 t8 = Z80_RDMEM(HL);
Z80_WRMEM(HL, (t8 << 4) | (A & 0x0f));
A = (A & 0xf0) | (t8 >> 4);
}
F = (F & C_FLAG) | SZ53P(A);
break;
case 0x70:
TSTATES += 12;
{
uns8 t8;
IN(t8);
}
break;
case 0x71:
TSTATES += 12;
OUT(0);
break;
case 0x72:
TSTATES += 15;
SBC_HL(SP);
break;
case 0x73:
TSTATES += 20;
LD_NN_DD(HSP, LSP);
break;
case 0x77:
case 0x7f:
TSTATES += 8;
break;
case 0x78:
TSTATES += 12;
IN(A);
break;
case 0x79:
TSTATES += 12;
OUT(A);
break;
case 0x7A:
TSTATES += 15;
ADC_HL(SP);
break;
case 0x7B:
TSTATES += 20;
LD_DD_NN(HSP, LSP);
break;
case 0xA0:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
Z80_WRMEM(DE, t8);
DE++; HL++; BC--;
F = (F & (S_FLAG | Z_FLAG | C_FLAG)) | (BC ? V_FLAG : 0);
t8 += A;
F |= (t8 & 2 ? B5_FLAG : 0) | (t8 & B3_FLAG);
}
break;
case 0xA1:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
uns16 t16 = A - t8;
uns8 idx = ((A & 0x88) >> 1) | ((t8 & 0x88) >> 2) | ((t16 & 0x88) >> 3);
HL++; BC--;
F = (F & C_FLAG) |
(t16 & S_FLAG) |
(t16 & 0xff ? 0 : Z_FLAG) |
subHalfCarryTbl[idx & 0x7] |
(BC ? V_FLAG | N_FLAG : N_FLAG);
if (F & H_FLAG)
{
t16--;
}
F |= (t16 & 2 ? B5_FLAG : 0) | (t16 & B3_FLAG);
}
break;
case 0xA2:
TSTATES += 16;
{
uns8 t8 = Z80_IN(BC);
Z80_WRMEM(HL, t8);
B--; HL++;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C + 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
break;
case 0xA3:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
B--;
Z80_OUT(BC, t8);
HL++;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C + 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
break;
case 0xA8:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
Z80_WRMEM(DE, t8);
DE--; HL--; BC--;
F = (F & (S_FLAG | Z_FLAG | C_FLAG)) | (BC ? V_FLAG : 0);
t8 += A;
F |= (t8 & 2 ? B5_FLAG : 0) | (t8 & B3_FLAG);
}
break;
case 0xA9:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
uns16 t16 = A - t8;
uns8 idx = ((A & 0x88) >> 1) | ((t8 & 0x88) >> 2) | ((t16 & 0x88) >> 3);
HL--; BC--;
F = (F & C_FLAG) |
(t16 & S_FLAG) |
(t16 & 0xff ? 0 : Z_FLAG) |
subHalfCarryTbl[idx & 0x7] |
(BC ? V_FLAG | N_FLAG : N_FLAG);
if (F & H_FLAG)
{
t16--;
}
F |= (t16 & 2 ? B5_FLAG : 0) | (t16 & B3_FLAG);
}
break;
case 0xAA:
TSTATES += 16;
{
uns8 t8 = Z80_IN(BC);
Z80_WRMEM(HL, t8);
B--; HL--;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C - 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
break;
case 0xAB:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
B--;
Z80_OUT(BC, t8);
HL--;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C - 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
break;
case 0xB0:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
Z80_WRMEM(DE, t8);
HL++; DE++; BC--;
F = (F & (S_FLAG | Z_FLAG | C_FLAG)) | (BC ? V_FLAG : 0);
t8 += A;
F |= (t8 & 2 ? B5_FLAG : 0) | (t8 & B3_FLAG);
}
if (BC)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xB1:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
uns16 t16 = A - t8;
uns8 idx = ((A & 0x88) >> 1) | ((t8 & 0x88) >> 2) | ((t16 & 0x88) >> 3);
HL++; BC--;
F = (F & C_FLAG) |
(t16 & S_FLAG) |
(t16 & 0xff ? 0 : Z_FLAG) |
subHalfCarryTbl[idx & 0x7] |
(BC ? V_FLAG | N_FLAG : N_FLAG);
if (F & H_FLAG)
{
t16--;
}
F |= (t16 & 2 ? B5_FLAG : 0) | (t16 & B3_FLAG);
}
if ((F & (Z_FLAG | V_FLAG)) == V_FLAG)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xB2:
TSTATES += 16;
{
uns8 t8 = Z80_IN(BC);
Z80_WRMEM(HL, t8);
B--; HL++;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C + 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
if (B)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xB3:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
B--;
Z80_OUT(BC, t8);
HL++;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C + 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
if (B)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xB8:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
Z80_WRMEM(DE, t8);
HL--; DE--; BC--;
t8 += A;
F = (F & (S_FLAG | Z_FLAG | C_FLAG)) | (BC ? V_FLAG : 0);
t8 += A;
F |= (t8 & 2 ? B5_FLAG : 0) | (t8 & B3_FLAG);
}
if (BC)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xB9:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
uns16 t16 = A - t8;
uns8 idx = ((A & 0x88) >> 1) | ((t8 & 0x88) >> 2) | ((t16 & 0x88) >> 3);
HL--; BC--;
F = (F & C_FLAG) |
(t16 & S_FLAG) |
(t16 & 0xff ? 0 : Z_FLAG) |
subHalfCarryTbl[idx & 0x7] |
(BC ? V_FLAG | N_FLAG : N_FLAG);
if (F & H_FLAG)
{
t16--;
}
F |= (t16 & 2 ? B5_FLAG : 0) | (t16 & B3_FLAG);
}
if ((F & (Z_FLAG | V_FLAG)) == V_FLAG)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xBA:
TSTATES += 16;
{
uns8 t8 = Z80_IN(BC);
Z80_WRMEM(HL, t8);
B--; HL--;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C - 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
if (B)
{
TSTATES += 5;
PC -= 2;
}
break;
case 0xBB:
TSTATES += 16;
{
uns8 t8 = Z80_RDMEM(HL);
B--;
Z80_OUT(BC, t8);
HL--;
F = SZ53(B) | (t8 & 0x80 ? N_FLAG : 0);
if (((uns16)t8 + ((uns16)(C - 1) & 0xff)) & 0x100)
{
F |= H_FLAG | C_FLAG;
}
}
if (B)
{
TSTATES += 5;
PC -= 2;
}
break;
#ifndef NO_ED_TRAPS
#ifdef XBELL_AUDIO
case BELL_BPT:
TSTATES += 8;
if (RPAGE(PC) != Machine->basicRom)
{
goto illegal;
}
{
int f = 1750000 / ((HL + 30) << 2);
int t = (1000 * DE) / f;
RingBell(f, t);
}
break;
#endif
case 0xFB:
TSTATES += 8;
LevelLoaderTrap();
break;
case LOAD_BPT:
TSTATES += 8;
if (RPAGE(PC) != Machine->basicRom)
{
goto illegal;
}
TpLoadBlock();
break;
case SAVE_BPT:
TSTATES += 8;
if (RPAGE(PC) != Machine->basicRom)
{
goto illegal;
}
TpSaveBlock();
break;
#ifdef XZX_IF1
case RS232_IP_BPT:
TSTATES += 8;
if (RPAGE(PC) != IF1ROM)
{
goto illegal;
}
If1Rs232In();
break;
case RS232_OP_BPT:
TSTATES += 8;
if (RPAGE(PC) != IF1ROM)
{
goto illegal;
}
If1Rs232Out();
break;
#endif
#endif
default:
TSTATES += 8;
#ifndef NO_ED_TRAPS
illegal:
#endif
#ifdef DEBUG
if (GETCFG(debug) & D_ILLOPS)
{
Msg(M_DEBUG, "unimplemented instruction ED %02X at <%04x>",
Z80_RDMEM(PC - 1), PC - 2);
}
#endif
break;
#undef LD_NN_DD
#undef LD_DD_NN
#undef ADC_HL
#undef SBC_HL
#undef IN
#undef OUT
