/********************************************************************************
* Copyright (c) Erik Kunze 1995 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*
* $Id: z80_macros.h,v 1.9 1998/10/11 13:08:51 erik Rel $
*******************************************************************************/
#ifndef _XZX_Z80_MACROS_H
#define _XZX_Z80_MACROS_H
#define PARITY(reg)		parityTbl[(reg)]
#define SZ53P(reg)		sz53pTbl[(reg)]
#define SZ53(reg)		sz53Tbl[(reg)]
#define INC_R() \
{																		\
R = (R & 0x80) | (++R & 0x7f);										\
}
#define DEC_R() \
{																		\
R = (R & 0x80) | (--R & 0x7f);										\
}
#define SCF() \
{																		\
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) |								\
(A & (B5_FLAG | B3_FLAG)) | C_FLAG;								\
}
#define CCF() \
{																		\
F = (F & (S_FLAG | Z_FLAG | V_FLAG)) |								\
(A & (B5_FLAG | B3_FLAG)) |										\
(F & C_FLAG ? H_FLAG : C_FLAG);									\
}
#define INC(reg) \
{																		\
++(reg);															\
F = (F & C_FLAG) |													\
SZ53((reg)) |													\
((reg) & 0xf ? 0 : H_FLAG) |									\
((reg) == 0x80 ? V_FLAG : 0);									\
}
#undef DEC
#define DEC(reg) \
{																		\
F = (F & C_FLAG) |													\
((reg) & 0xf ? 0 : H_FLAG) |									\
((reg) == 0x80 ? V_FLAG : 0) |									\
N_FLAG;															\
--(reg);															\
F |= SZ53((reg));													\
}
#define ADD(val) \
{																		\
uns16 temp16 = A + (val);											\
uns8 idx = ((A & 0x88) >> 1) |										\
(((val) & 0x88) >> 2) |									\
((temp16 & 0x88) >> 3);									\
A = (uns8)temp16;													\
F = SZ53(A) |														\
halfCarryTbl[idx & 0x7] |										\
overflowTbl[idx >> 4] |											\
(temp16 & 0x100 ? C_FLAG : 0);									\
}
#define ADC(val) \
{																		\
uns16 temp16 = A + (val) + (F & C_FLAG);							\
uns8 idx = ((A & 0x88) >> 1) |										\
(((val) & 0x88) >> 2) |									\
((temp16 & 0x88) >> 3);									\
A = (uns8)temp16;													\
F = SZ53(A) |														\
halfCarryTbl[idx & 0x7] |										\
overflowTbl[idx >> 4] |											\
(temp16 & 0x100 ? C_FLAG : 0);									\
}
#define SUB(val) \
{																		\
uns16 temp16 = A - (val);											\
uns8 idx = ((A & 0x88) >> 1) |										\
(((val) & 0x88) >> 2) |									\
((temp16 & 0x88) >> 3);									\
A = (uns8)temp16;													\
F = SZ53(A) |														\
subHalfCarryTbl[idx & 0x7] |									\
subOverflowTbl[idx >> 4] |										\
N_FLAG |														\
(temp16 & 0x100 ? C_FLAG : 0);									\
}
#define SBC(val) \
{																		\
uns16 temp16 = A - (val) - (F & C_FLAG);							\
uns8 idx = ((A & 0x88) >> 1) |										\
(((val) & 0x88) >> 2) |									\
((temp16 & 0x88) >> 3);									\
A = (uns8)temp16;													\
F = SZ53(A) |														\
subHalfCarryTbl[idx & 0x7] |									\
subOverflowTbl[idx >> 4] |										\
N_FLAG |														\
(temp16 & 0x100 ? C_FLAG : 0);									\
}
#define OR(val) \
{																		\
A |= (val);															\
F = SZ53P(A);														\
}
#define AND(val) \
{																		\
A &= (val);															\
F = SZ53P(A) | H_FLAG;												\
}
#define XOR(val) \
{																		\
A ^= (val);															\
F = SZ53P(A);														\
}
#define CMP(val) \
{																		\
uns16 temp16 = A - (val);											\
uns8 idx = ((A & 0x88) >> 1) |										\
(((val) & 0x88) >> 2) |									\
((temp16 & 0x88) >> 3);									\
F = (temp16 & S_FLAG) |												\
(temp16 & 0xff ? 0 : Z_FLAG) |									\
(val & (B5_FLAG | B3_FLAG)) |									\
subHalfCarryTbl[idx & 0x7] |									\
subOverflowTbl[idx >> 4] |										\
N_FLAG |														\
(temp16 & 0x100 ? C_FLAG : 0);									\
}
#define RLC(reg) \
{																		\
(reg) = ((reg) << 1) | ((reg) >> 7);								\
F = SZ53P((reg)) | ((reg) & C_FLAG);								\
}
#define RRC(reg) \
{																		\
F = (reg) & C_FLAG;													\
(reg) = ((reg) >> 1) | ((reg) << 7);								\
F |= SZ53P((reg));													\
}
#define RL(reg) \
{																		\
uns8 temp8_2 = (reg) >> 7;											\
(reg) = ((reg) << 1) | (F & C_FLAG);								\
F = SZ53P((reg)) | temp8_2;											\
}
#define RR(reg) \
{																		\
uns8 temp8_2 = (reg) & C_FLAG;										\
(reg) = ((reg) >> 1) | (F << 7);									\
F = SZ53P((reg)) | temp8_2;											\
}
#define SLA(reg) \
{																		\
F = (reg) >> 7;														\
(reg) <<= 1;														\
F |= SZ53P((reg));													\
}
#define SRA(reg) \
{																		\
F = (reg) & C_FLAG;													\
(reg) = ((reg) & 0x80) | ((reg) >> 1);								\
F |= SZ53P((reg));													\
}
#define SLI(reg) \
{																		\
F = (reg) >> 7;														\
(reg) = ((reg) << 1) | 0x01;										\
F |= SZ53P((reg));													\
}
#define SRL(reg) \
{																		\
F = (reg) & C_FLAG;													\
(reg) >>= 1;;														\
F |= SZ53P((reg));													\
}
#define BIT(bit, reg) \
{																		\
F = (F & C_FLAG) |													\
((reg) & (0x01 << (bit)) & S_FLAG) |							\
((reg) & (B5_FLAG | B3_FLAG)) |									\
((reg) & (0x01 << (bit)) ?										\
H_FLAG : (Z_FLAG | H_FLAG | P_FLAG));				\
}
#define PUSH(regh, regl) \
{																		\
Z80_WRMEM(--SP, (regh));											\
Z80_WRMEM(--SP, (regl));											\
}
#define POP(regh, regl) \
{																		\
(regl) = Z80_RDMEM(SP++);											\
(regh) = Z80_RDMEM(SP++);											\
}
#define RET() \
{																		\
POP(HPC, LPC);														\
}
#define RETN() \
{																		\
RET();																\
IFF1 = IFF2;														\
}
#endif
