#include "cs.h"
#include "control.h"

extern void DisplaySliders(int);
extern int GetSliderValue(int);
extern void SetSliderValue(int, int);
extern void SetSliderMin(int, int);
extern void SetSliderMax(int, int);

void cntrl_set(CNTRL *p)
{
    POLL_EVENTS();
    DisplaySliders((int)*p->kcntl);
}

void control(CNTRL *p)
{
    POLL_EVENTS();
    DisplaySliders((int)*p->kcntl);
    /* Get value from slider kcntl */
    *p->kdest = (float)GetSliderValue((int)*p->kcntl);
}

void ocontrol(SCNTRL *p)
{
    int c = (int)*p->which;
    POLL_EVENTS();
    DisplaySliders((int)*p->kcntl);
    switch (c) {
    case 0:			/* Set value */
      SetSliderValue((int)*p->kcntl, (int)*p->val);
      return;
    case 1:
      SetSliderMin((int)*p->kcntl, (int)*p->val);
      return;
    case 2:
      SetSliderMax((int)*p->kcntl, (int)*p->val);
      return;
    }
}
