/*
 * $Id: getlongopts.c,v 1.8 1999/04/24 14:18:14 nicb Exp $
 *
 * written by Fred Floberg (emng@geocities.com) - some small additions
 * by Nicola Bernardini (nicb@axnet.it)
 */
#include <stdarg.h>
#include "config.h"
#include "cs.h"
#include "soundio.h"
#include "getlongopts.h"

/* Option string for getopt_long_only() */
#define OPTSTR "8AB:CDEF:GH:IJK::L:M:NOP:Q:RSTU:V:WXYZab:cdefghi:jk:lm:no:pqr:st:uvwxyz::"

Csound_Options opts_n_help[] = {

	{"EEEE",		no_argument,		NULL, 'E',
	"",
	"Flag not used",
	bogus_opt
	},
	{"OOOO",		no_argument,		NULL, 'O',
	"",
	"Flag not used",
	bogus_opt
	},
	{"SSSS",		no_argument,		NULL, 'S', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"XXXX",		no_argument,		NULL, 'X', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"YYYY",		no_argument,		NULL, 'Y', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"ZZZZ",		no_argument,		NULL, 'Z', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"aiff",		no_argument,		NULL, 'A',
	"",
	"Create an AIFF format output soundfile",
	aiff_opt
	},
	{"alaw",		no_argument,		NULL, 'a', 
	"",
	"Alaw sound samples",
	alaw_opt
	},
	{"ascii",		no_argument,		NULL, 'g',
	"",
	"Suppress graphics, use ascii displays",
	ascii_opt
	},
	{"chars",		no_argument,		NULL, 'c', 
	"",
	"8-bit signed_char sound samples",
	chars_opt
	},
	{"cscoresco",		no_argument,		NULL, 'C',
	"",
	"Use Cscore processing of scorefile",
	cscoresco_opt
	},
	{"defergen01",		no_argument,		NULL, 'D',
	"",
	"Defer GEN01 soundfile loads until performance time",
	defergen01_opt
	},
	{"eeee",		no_argument,		NULL, 'e', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"extract",		required_argument,	NULL, 'x',
	"fnam",
	"Extract from score.srt using extract file 'fnam'",
	extract_opt
	},
	{"floats",		no_argument,		NULL, 'f', 
	"",
	"Float sound samples",
	floats_opt
	},
	{"hardbuffer",		required_argument,	NULL, 'B',
	"N",
	"Samples per hardware sound I/O buffer",
	hardbuffer_opt
	},
	{"heartbeat",		required_argument,	NULL, 'H',
	"N",
	"Print a heartbeat style 1, 2 or 3 at each soundfile write",
	heartbeat_opt
	},
	{"help",		no_argument,		NULL, 0x100,
	"",
	"This help screen",
	help_opt
	},
	{"incard",		required_argument,	NULL, 0x102,
	"N",
	"Specify audio card used for input samples (ALSA only)",
	incard_opt
	},
	{"infile",		required_argument,	NULL, 'i', 
	"fnam",
	"Sound input filename",
	infile_opt
	},
	{"ircam",		no_argument,		NULL, 'J',
	"",
	"Create an IRCAM format output soundfile",
	ircam_opt
	},
	{"itimerun",		no_argument,		NULL, 'I',
	"",
	"I-time only orch run",
	itimerun_opt
	},
	{"jjjj",		no_argument,		NULL, 'j', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"krate",		required_argument,	NULL, 'k', 
	"N",
	"Orchestra krate override",
	krate_opt
	},
	{"lineeventdev",	required_argument,	NULL, 'L',
	"dnam",
	"Read Line-oriented realtime score events from device 'dnam'",
	lineeventdev_opt
	},
	{"longs",		no_argument,		NULL, 'l', 
	"",
	"Long_int sound samples",
	longs_opt
	},
	{"message",		required_argument,	NULL, 'm', 
	"N",
	"tty message level. Sum of: 1=note amps, 2=out-of-range msg, 4=warnings",
	message_opt
	},
	{"midieventdev",	required_argument,	NULL, 'M',
	"dnam",
	"Read MIDI realtime events from device 'dnam'",
	midieventdev_opt
	},
	{"midifile",		required_argument,	NULL, 'F',
	"dnam",
	"Read MIDI realtime events from device 'dnam'",
	midifile_opt
 	},
	{"midihardware",	required_argument,	NULL, 'Q',
	"N",
	"Select MIDI interface hardware (0 to N)",
	midihardware_opt
	},
	{"midiport",		optional_argument,	NULL, 'K',
	"port",
	"Assign a MIDI input port",
	midiport_opt
	},
	{"midisustain",		required_argument,	NULL, 'P',
	"N",
	"MIDI sustain pedal threshold (0 - 128)",
	midisustain_opt
	},
	{"nodiskoutput",	no_argument,		NULL, 'n', 
	"",
	"No sound onto disk",
	nodiskoutput_opt
	},
	{"nodisplay",		no_argument,		NULL, 'd',
	"",
	"Suppress all graphic displays",
	nodisplay_opt
	},
	{"nographics",		no_argument,		NULL, 'G',
	"",
	"Suppress graphics, use Postscript displays",
	nographics_opt
	},
	{"noheader",		no_argument,		NULL, 'h',
	"",
	"No header on output soundfile",
	noheader_opt
	},
	{"notify",		no_argument,		NULL, 'N',
	"",
	"Notify (ring the bell) when score or miditrack is done",
	notify_opt
	},
	{"opcodes",		optional_argument,	NULL, 'z',
	"N",
	"List opcodes in this version. If N is present and is > 0, list params too.",
	opcodes_opt
	},
	{"outcard",		required_argument,	NULL, 0x103,
	"N",
	"Specify audio card used for output samples (ALSA only)",
	outcard_opt
	},
	{"outfile",		required_argument,	NULL, 'o', 
	"fnam",
	"Sound output filename",
	outfile_opt
	},
	{"pppp",		no_argument,		NULL, 'p', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"qqqq",		no_argument,		NULL, 'q', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"rewrite",		no_argument,		NULL, 'R',
	"",
	"Continually rewrite header while writing soundfile (WAV/AIFF)",
	rewrite_opt
	},
	{"sched",		no_argument,		NULL, 0x101,
	"",
	"Enable High Priority Task Scheduling. Only valid during real-time output",
	sched_opt
	},
	{"shorts",		no_argument,		NULL, 's', 
	"",
	"Short_int sound samples",
	shorts_opt
	},
	{"sked",		no_argument,		NULL, 0x101,
	"",
	"See --sched (alternate spelling for the typo-prone :-)",
	sched_opt
	},
	{"softbuffer",		required_argument,	NULL, 'b',
	"N",
	"Sample frames (or -kprds) per software sound I/O buffer",
	softbuffer_opt
	},
	{"srate",		required_argument,	NULL, 'r',
	"N",
	"Orchestra srate override",
	srate_opt
	},
	{"tempo",		required_argument,	NULL, 't', 
	"N",
	"Use uninterpreted beats of the score, initially at tempo <N>",
	tempo_opt
	},
	{"terminate",		no_argument,		NULL, 'T',
	"",
	"Terminate the performance when miditrack is done",
	terminate_opt
	},
	{"uchars",		no_argument,		NULL, '8',
	"",
	"Use 8-bit unsigned_char sound samples",
	uchars_opt
	},
	{"ulaw",		no_argument,		NULL, 'u', 
	"",
	"Ulaw sound samples",
	ulaw_opt
	},
	{"utility",		required_argument,	NULL, 'U',
	"unam",
	"Run utility program 'unam'",
	utility_opt
	},
	{"verbose",		no_argument,		NULL, 'v', 
	"",
	"Verbose orch translation",
	verbose_opt
	},
	{"volume",		required_argument,	NULL, 'V',
	"N",
	"Set real-time audio output volume to N (1 to 100) (Not with ALSA driver)",
	volume_opt
	},
	{"wav",			no_argument,		NULL, 'W',
	"",
	"Create a WAV format output soundfile",
	wav_opt
	},
	{"wwww",		no_argument,		NULL, 'w', 
	"",
	"Flag not used",
	bogus_opt
	},
	{"yyyy",		no_argument,		NULL, 'y', 
	"",
	"Flag not used",
	bogus_opt
	},

	{NULL, 0, NULL, 0, NULL, NULL, NULL}
};

/* Local func to supplant the code at label outtyp: in main.c */
void bad_outtype(void)
{
	do_opts_help("output soundfile cannot be both AIFF and WAV\n");
}

/* Local func to supplant the code at label outform: in main.c */
void bad_outform(char outformch, char *arg)
{
	do_opts_help("sound output format cannot be both -%c and -%c\n", outformch, *arg);
}

#define OPT_FIELD_LEN 40

/* Print out currently available options as neatly as possible (shyeah, right!) and exit. */
void _do_opts_help(const char * exit_string, va_list ap)
{
	int i = 0, n, lines, cols, diff, optlen;
	char *envcols, *help_index, line[256], *p;

	if((envcols = getenv("COLUMNS")) == NULL) /* Get display width */
		envcols = "80";			/* Or use default */

	cols = strtoul(envcols, (char **)NULL, 10); /* Convert to int */

	vprintf(exit_string, ap);
	printf("Arguments in square brackets [] are optional.\n");
	do {
               if(!strcmp("Flag not used", opts_n_help[i].help)) /* Test for magic phrase and ignore */
                       continue;

		optlen = strlen(opts_n_help[i].opt.name);

		if(isalnum(opts_n_help[i].opt.val)){     /* Test for options that have short form */
			if(opts_n_help[i].opt.has_arg == 1){	/* Option takes required argument. Show both forms */
				printf("-%c %s or --%s=%s", opts_n_help[i].opt.val, opts_n_help[i].arg,
							opts_n_help[i].opt.name, opts_n_help[i].arg);
				optlen += strlen(opts_n_help[i].arg) * 2;
				optlen += 10;
			} else if(opts_n_help[i].opt.has_arg == 2){ /* Option takes optional argument. Show both forms */
				printf("-%c [%s] or --%s[=%s]", opts_n_help[i].opt.val, opts_n_help[i].arg,
							opts_n_help[i].opt.name, opts_n_help[i].arg);
				optlen += strlen(opts_n_help[i].arg) * 2;
				optlen += 14;
			} else {			/* Option does not take argument */
				printf("-%c or --%s", opts_n_help[i].opt.val, opts_n_help[i].opt.name);
				optlen += 8;
			}
		} else {					/* Print options with long form only */
			printf("--%s", opts_n_help[i].opt.name);
			optlen += 2;
			if(opts_n_help[i].opt.has_arg == 1){	/* Option takes required argument. Add to long form */
				printf("=%s", opts_n_help[i].arg);
				optlen += (strlen(opts_n_help[i].arg) +1);
			} else if(opts_n_help[i].opt.has_arg == 2){   /* Option takes optional argument. Add to long form */
				printf("[=%s]", opts_n_help[i].arg);
				optlen += (strlen(opts_n_help[i].arg) +1);
				optlen += 6;
			}
		}

		help_index = strcpy(line, opts_n_help[i].help);

		/* Automagically wrap only the description field of a help line based on display width */
		lines = 0;
		while(1){
			diff = OPT_FIELD_LEN + strlen(help_index) - cols; /* Diff between line len & display width */ 
			if(diff > 0){
				p = rindex(help_index, '\0'); /* Move to end of string */
				p -= diff; /* Move back to display width */
				while( *p != ' ') --p; /* Search backward from there for a space char */
				*p = 0; /* Sever string at that point */
				if(lines) {
					for(n = 0; n < OPT_FIELD_LEN; ++n) /* Pad with spaces */
						putchar(' ');
						putchar(' ');
				} else {
					putchar(' ');
					for(n = 0; n < (OPT_FIELD_LEN - 2) - optlen; ++n) /* Ditto if 1st line */
						putchar('.');
					putchar(' ');
				}
				puts(help_index); /* Print chunk of string */
				++p;
				help_index = p; /* Move to next chunk */
				++lines;
			} else { /* Trivial case: Line len does not exceed display width. Just pad and print */
				if(lines) {
					for(n = 0; n < OPT_FIELD_LEN; ++n)
						putchar(' ');
						putchar(' ');
				} else {
					putchar(' ');
					for(n = 0; n < (OPT_FIELD_LEN - 2) - optlen; ++n)
						putchar('.');
					putchar(' ');
				}
				puts(help_index);
				break;
			}
		}
	} while(opts_n_help[++i].opt.name != NULL);
	exit(0);
}

void
do_opts_help(const char *exit_string, ...)
{
	va_list ap;
	va_start(ap, exit_string);
	_do_opts_help(exit_string, ap);
	va_end(ap);
}

/* Per-option option processing functions. */

int incard, outcard; /* Used in ALSArtaudio.c */
int scheduler_priority; /* Used in setscheduler.c */

int outformch, stdinassgn;
char *envoutyp_from_main; /* Great jumpin Cheeses on a lawn mower!! */
char *xfilename_from_main;

int argc_from_main;
char **argv_from_main;

/*
 * optarg checker to avoid bombing at every missing argument
 * [added by nicb@axnet.it]
 */

inline static void
check_arg(const char *arg, const char *arg_name)
{
	if (arg == (const char *) NULL)
		dieu("%s: missing argument", arg_name);
}

void	aiff_opt(char *arg)
{
				if (O.filetyp == TYP_WAV) {
		if (envoutyp_from_main == NULL) bad_outtype();
					warning("-A overriding local default WAV out");
				}
				if (O.outformat == AE_FLOAT) {
					warning("Overriding File Type to AIFF-C for AIFF float format");
					O.filetyp = TYP_AIFC;
				}
				else O.filetyp = TYP_AIFF;     /* AIFF output request*/
}

void	alaw_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "a");
	outformch = 'a';
	O.outformat = AE_ALAW;    /* a-law soundfile */
}

void	ascii_opt(char *arg)
{
	O.graphsoff = 1;
}

void	bogus_opt(char *arg)
{
	do_opts_help(arg);
}

void	chars_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "c");
	outformch = 'c';
	O.outformat = AE_CHAR;    /* signed 8-bit char soundfile */
}

void	cscoresco_opt(char *arg)
{
				O.usingcscore = 1;
}

void	defergen01_opt(char *arg)
{
				O.gen01defer = 1;
}

void	extract_opt(char *arg)
{
	check_arg(arg, "-x");
	sscanf(arg,"%s", xfilename_from_main);
}

void	floats_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "f");
	outformch = 'f';
	O.outformat = AE_FLOAT;   /* float soundfile */
	if (O.filetyp == TYP_AIFF) {
		warning("Overriding File Type to AIFF-C for float output");
		O.filetyp = TYP_AIFC;
	}
}

void	hardbuffer_opt(char *arg)
{
	check_arg(arg, "-B");
	sscanf(arg, "%d", &O.oMaxLag);
}

void	heartbeat_opt(char *arg)
{
	check_arg(arg, "-H");
	if (isdigit(*arg))
		sscanf(arg, "%d", &O.heartbeat);
	else
		O.heartbeat = 1;
}

void	help_opt(char *arg)
{
	do_opts_help("Available Options:");
}

void	incard_opt(char *arg)
{
	check_arg(arg, "--incard");
	O.infilename = mmalloc(256);
	strcpy(O.infilename, "adc"); /* The use of --incard implies real-time audio input */
	sscanf(arg, "%d", &incard);
	O.sfread = 1;
}

void	infile_opt(char *arg)
{
	check_arg(arg, "-i");
	O.infilename = mmalloc(256);   /* soundin name */
	strcpy(O.infilename, arg);
	if (strcmp(O.infilename,"stdout") == 0)
		do_opts_help("-i cannot be stdout");
	if (strcmp(O.infilename,"stdin") == 0) {
					if (stdinassgn)
			do_opts_help("-i: stdin previously assigned");
					stdinassgn = 1;
				}
	O.sfread = 1;
}

void	ircam_opt(char *arg)
{
				if (O.filetyp == TYP_AIFF || O.filetyp == TYP_WAV) {
		if (envoutyp_from_main == NULL) bad_outtype();
					warning("-J overriding local default AIFF/WAV out");
				}
				O.filetyp = TYP_IRCAM;      /* IRCAM output request */
}

void	itimerun_opt(char *arg)
{
	O.initonly = 1;
	O.sfwrite = 0;
}

void	krate_opt(char *arg)
{
	check_arg(arg, "-k");
	sscanf(arg,"%d",&O.kr_override);
}

void	lineeventdev_opt(char *arg)
{
	check_arg(arg, "-L");
				O.Linename = mmalloc(256);     /* Linein device name */
	strcpy(O.Linename, arg);
				if (!strcmp(O.Linename,"stdin")) {
					if (stdinassgn)
						do_opts_help("-L: stdin previously assigned");
					stdinassgn = 1;
				}
				O.Linein = 1;
}

void	longs_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "l");
	outformch = 'l';
	O.outformat = AE_LONG;   /* long_int soundfile*/
}

void	message_opt(char *arg)
{
	check_arg(arg, "-m");
	sscanf(arg,"%d",&O.msglevel);
}

void	midieventdev_opt(char *arg)
{
	check_arg(arg, "-M");
				O.Midiname = mmalloc(256);     /* Midi device name */
	strcpy(O.Midiname, arg);
				if (!strcmp(O.Midiname,"stdin")) {
					if (stdinassgn)
						do_opts_help("-M: stdin previously assigned");
					stdinassgn = 1;
				}
				O.Midiin = 1;
}

void	midifile_opt(char *arg)
{
	check_arg(arg, "-F");
	O.FMidiname = mmalloc(256);    /* Midifile name */
	strcpy(O.FMidiname, arg);
	if (!strcmp(O.FMidiname,"stdin")) {
		if (stdinassgn)
		do_opts_help("-F: stdin previously assigned");
		stdinassgn = 1;
	}
	O.FMidiin = 1;          /***************/
}

void	midihardware_opt(char *arg)
{
	extern	int midi_out;
	check_arg(arg, "-Q");

				midi_out = -1;
	if (isdigit(*arg)) {
		sscanf(arg,"%d",&midi_out);
					openMIDIout();
				}
}

void	midiport_opt(char *arg)
{
	/* optional midi port number */
	int num = 0;
	check_arg(arg, "-K");

	if (arg && isdigit(*arg)) {
		sscanf(arg,"%d",&num); 
		setport_num(num);
	}
	O.Midiname = "sbmidi";
	O.Midiin = 1;
}

void	midisustain_opt(char *arg)
{
	check_arg(arg, "-P");
	sscanf(arg,"%d",&O.SusPThresh);
}

void	nodiskoutput_opt(char *arg)
{
	O.sfwrite = 0;
}

void	nodisplay_opt(char *arg)
{
	O.displays = 0;
}

void	nographics_opt(char *arg)
{
	O.postscript = 1;
}

void	noheader_opt(char *arg)
{
	O.sfheader = 0;
}

void	notify_opt(char *arg)
{
	O.ringbell = 1;
}

void	opcodes_opt(char *arg)
{
	int full = 0;
	check_arg(arg, "-z");

	if(arg)
		sscanf(arg,"%d", &full);
	else
		full = 0;

	list_opcodes(full);
	exit(0);
}

void	outcard_opt(char *arg)
{
	check_arg(arg, "--outcard");
	O.outfilename = mmalloc(256);
	strcpy(O.outfilename, "dac"); /* The use of --outcard implies real-time audio output */
	sscanf(arg, "%d", &outcard);
}

void	outfile_opt(char *arg)
{
	check_arg(arg, "-o");
	O.outfilename = mmalloc(256);          /* soundout name */
	strcpy(O.outfilename, arg);
	if (strcmp(O.outfilename,"stdin") == 0)
		do_opts_help("-o cannot be stdin");
	if (strcmp(O.outfilename,"stdout") == 0) 
		if ((O.stdoutfd = dup(1)) < 0) /* redefine stdout */
			do_opts_help("too many open files");
	dup2(2,1);                /* & send 1's to stderr */
}

void	rewrite_opt(char *arg)
{
				O.rewrt_hdr = 1;
}

void	sched_opt(char *arg)
{
	O.displays = 0; /* Until X11 support gets fixed, --sked implies -d to prevent lock-outs */
	scheduler_priority = 1;
}

void	shorts_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "s");
	outformch = 's';
	O.outformat = AE_SHORT;   /* short_int soundfile*/
}

void	softbuffer_opt(char *arg)
{
	check_arg(arg, "-b");
	sscanf(arg, "%d", &O.outbufsamps);
	O.inbufsamps = O.outbufsamps;
}

void	srate_opt(char *arg)
{
	check_arg(arg, "-r");
	sscanf(arg,"%d",&O.sr_override);
}

void	tempo_opt(char *arg)
{
	check_arg(arg, "-t");
	sscanf(arg,"%d",&O.cmdTempo);/* use this tempo .. */
	if (O.cmdTempo <= 0) do_opts_help("illegal tempo");
	O.Beatmode = 1;       /* on uninterpreted Beats */
}

void	terminate_opt(char *arg)
{
				O.termifend = 1;
}

void	uchars_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "8");
	outformch = '8';
	O.outformat = AE_UNCH;    /* unsigned 8-bit soundfile */
}

void	ulaw_opt(char *arg)
{
	if (O.outformat) bad_outform(outformch, "u");
	outformch = 'u';
	O.outformat = AE_ULAW;    /* mu-law soundfile */
}

void    utility_opt(char *arg)
{
        check_arg(arg, "-U");
        if(arg){
                argv_from_main++;
                argc_from_main--;
		if(!strcmp("-U", *argv_from_main)){
 			argv_from_main++;
 			argc_from_main--;
		}
		if(!strcmp("cvanal", arg)){
						printf("util CVANAL:\n");
                        cvanal(argc_from_main, argv_from_main);
                } else if(!strcmp("hetro", arg)){
                                                printf("util HETRO:\n");
                        hetro(argc_from_main, argv_from_main);
                } else if(!strcmp("lpanal", arg)){
                                                printf("util LPANAL:\n");
                        lpanal(argc_from_main, argv_from_main);
                } else if(!strcmp("pvanal", arg)){
                                                printf("util PVANAL:\n");
                        pvanal(argc_from_main, argv_from_main);
                } else if(!strcmp("sndinfo", arg)){
                                                printf("util SNDINFO:\n");
                        sndinfo(argc_from_main, argv_from_main);
                                        }
                                } else
                                        do_opts_help("Unknown utility");
}

void	verbose_opt(char *arg)
{
	O.odebug = odebug = 1;
}

void	volume_opt(char *arg)
{
	check_arg(arg, "-V");
	sscanf(arg,"%d",&O.Volume);
}

void	wav_opt(char *arg)
{
				if (O.filetyp == TYP_AIFF) {
		if (envoutyp_from_main == NULL) bad_outtype();
					warning("-W overriding local default AIFF out");
				}
				O.filetyp = TYP_WAV;      /* WAV output request */
}

/* Grab a chunk of memory for the array of option structs and fill with opts members from opts_n_help */
struct option *init_options(void) /* With thanks to Nicola Bernardini for help with the pointer arith */
{
	struct option *actual_options;
	struct option *popt;
	struct Csound_Options *pcopt;
	int num_elements = sizeof(opts_n_help)/sizeof(struct Csound_Options);

	actual_options = (struct option *) malloc(sizeof(struct option) * num_elements);
	popt = actual_options;
	pcopt = opts_n_help;

	while (pcopt->help != (char *) NULL) {
		memcpy(popt, &(pcopt->opt), sizeof(struct option));
		++popt;
		++pcopt;
	}

	return actual_options;
}

/* Main option parsing func. Called from main.c */
void csound_getopts(int argc, char **argv, char *envoutyp, char *xfilename)
{
	extern  char *orchname;
	extern  char *scorename;
	void parse_rc();
	struct	option *actual_options_pointer;
	int c;

	if(argc < 2)
		do_opts_help("Insufficient Number of Arguments\n");

	actual_options_pointer = init_options();

	envoutyp_from_main = envoutyp; /* gUrG!! */
	xfilename_from_main = xfilename; /* gRaRgG!! */
	argc_from_main = argc;
	argv_from_main = argv;

	parse_rc();

	while ((c = getopt_long (argc, argv, OPTSTR, actual_options_pointer, NULL)) != -1) {
		switch (c) {
			case 0: break;
			case '8':	/* 8-bit unsigned_char sound samples */
				uchars_opt(optarg);
				break;
			case 'A':	/* create an AIFF format output soundfile */
				aiff_opt(optarg);
				break;
			case 'B':	/* N    samples per hardware sound I/O buffer */
				hardbuffer_opt(optarg);
				break;
			case 'C':	/* use Cscore processing of scorefile */
				cscoresco_opt(optarg);
				break;
			case 'D':	/* defer GEN01 soundfile loads until performance time */
				defergen01_opt(optarg);
				break;
			case 'E':bogus_opt("-E flag not used");	/* NOT USED */
			case 'F':	/* fnam read MIDIfile event stream from file 'fnam' */
				midifile_opt(optarg);
				break;
			case 'G':	/* suppress graphics, use Postscript displays */
				nographics_opt(optarg);
				break;
			case 'H':	/* #     print a heartbeat style 1, 2 or 3 at each soundfile write */
				heartbeat_opt(optarg);
				break;
			case 'I':	/* I-time only orch run */
				itimerun_opt(optarg);
				break;
			case 'J':	/* create an IRCAM format output soundfile */
				ircam_opt(optarg);
				break;
			case 'K':	/* portno       assign a MIDI input port */
				midiport_opt(optarg);
				break;
			case 'L':	/* dnam read Line-oriented realtime score events from device 'dnam' */
				lineeventdev_opt(optarg);
				break;
			case 'M':	/* dnam read MIDI realtime events from device 'dnam' */
				midieventdev_opt(optarg);
				break;
			case 'N':	/* notify (ring the bell) when score or miditrack is done */
				notify_opt(optarg);
				break;
			case 'O':bogus_opt("-O flag not used");	/* NOT USED */
			case 'P':	/* N    MIDI sustain pedal threshold (0 - 128) */
				midisustain_opt(optarg);
				break;
			case 'Q':	/* N    select MIDI interface hardware (0 to n) */
				midihardware_opt(optarg);
				break;
			case 'R':	/* continually rewrite header while writing soundfile (WAV/AIFF) */
				rewrite_opt(optarg);
				break;
			case 'S':bogus_opt("-S flag not used");	/* NOT USED */
			case 'T':	/* terminate the performance when miditrack is done */
				terminate_opt(optarg);
				break;
			case 'U':	/* unam run utility program unam */
				utility_opt(optarg);
				break;
			case 'V':	/* N    set real-time audio output volume to N (1 to 100) */
				volume_opt(optarg);
				break;
			case 'W':	/* create a WAV format output soundfile */
				wav_opt(optarg);
				break;
			case 'X': bogus_opt("-X flag not used");	/* NOT USED */
				break;
			case 'Y': bogus_opt("-Y flag not used");	/* NOT USED */
				break;
			case 'Z': bogus_opt("-Z flag not used");	/* NOT USED */
				break;
			case 'a':	/* alaw sound samples */
				alaw_opt(optarg);
				break;

			case 'b':	/* N    sample frames (or -kprds) per software sound I/O buffer */
				softbuffer_opt(optarg);
				break;
			case 'c':	/* 8-bit signed_char sound samples */
				chars_opt(optarg);
				break;
			case 'd':	/* suppress all displays */
				nodisplay_opt(optarg);
				break;
			case 'e':bogus_opt("-e flag not used");	/* NOT USED */
			case 'f':	/* float sound samples */
				floats_opt(optarg);
				break;
			case 'g':	/* suppress graphics, use ascii displays */
				ascii_opt(optarg);
				break;
			case 'h':	/* no header on output soundfile */
				noheader_opt(optarg);
				break;
			case 'i':	/* fnam sound input filename */
				infile_opt(optarg);
				break;
			case 'j':bogus_opt("-j flag not used");		/* NOT USED */
				break;
			case 'k':	/* N    orchestra krate override */
				krate_opt(optarg);
				break;
			case 'l':	/* long_int sound samples */
				longs_opt(optarg);
				break;
			case 'm':	/* N tty message level. Sum of: 1=amps, 2=out-of-range, 4=warnings */
				message_opt(optarg);
				break;
			case 'n':	/* no sound onto disk */
				nodiskoutput_opt(optarg);
				break;
			case 'o':	/* fnam sound output filename */
				outfile_opt(optarg);
				break;
			case 'p':bogus_opt("-p flag not used");		/* NOT USED */
				break;
			case 'q':bogus_opt("-q flag not used");		/* NOT USED */
                              break;
			case 'r':	/* N    orchestra srate override */
				srate_opt(optarg);
				break;
			case 's':	/* short_int sound samples */
				shorts_opt(optarg);
				break;
			case 't':	/* N    use uninterpreted beats of the score, initially at tempo N */
				tempo_opt(optarg);
				break;
			case 'u':	/* ulaw sound samples */
				ulaw_opt(optarg);
				break;
			case 'v':	/* verbose orch translation */
				verbose_opt(optarg);
				break;
			case 'w':bogus_opt("-w flag not used");		/* NOT USED */
				break;
			case 'x':	/* fnam extract from score.srt using extract file 'fnam' */
				extract_opt(optarg);
				break;
			case 'y':bogus_opt("-y flag not used");		/* NOT USED */
				break;
			case 'z':	/* List opcodes in this version */
				opcodes_opt(optarg);
				break;
			case 0x100:	/* --help */
				do_opts_help("");
				break;
			case 0x101:	/* --sched or --sked */
				sched_opt(optarg);
				break;
                        case 0x102:     /* --incard N (implies real-time input audio) */
                                incard_opt(optarg);
                                break;
                        case 0x103:     /* --outcard N (implies real-time output audio) */
                                outcard_opt(optarg);
				break;
			case '?':
			default: do_opts_help("Unrecognized flag");
		} /* switch */
	} /* while */

	free(actual_options_pointer);

	/* get orc and sco filenames from argv[] */
	if(orchname == NULL)
		orchname = argv[argc - 2];
	if(scorename == NULL)
		scorename = argv[argc - 1];
}
