/* sliders and other MIDI opcodes by Gabriel Maldonado */

#ifdef GAB_RT
#include "cs.h" 
#include "midiops.h"
#include "midiops3.h"
#include <math.h>

extern int midi_in_p_num;

extern INSDS    *curip;    
#define f7bit  127.0f
#define oneTOf7bit (float)(1./127.)
#define f14bit  16383.0f
#define oneTOf14bit  (float)(1/16383.)
#define f21bit 2097151.0f
#define oneTOf21bit	 (float)(1/2097151.)
void dieu_gab(char *s, char *title); /* gab */
void midi_in_error(char *op);
extern MCHNBLK *m_chnbp[16];

char sbuf[255];

void midi_in_error(char *op)
{
	char text[100];
	sprintf(text,"An error occurred while allocating '%s' opcode: MIDI IN PORT not enabled.\nFor using '%s' opcode you must set '-K' flag in command line!",op,op);
	dieu_gab(text, "Csound: MIDI IN error!");
	exit(0)	;
}
/*--------------------------------------------------------*/

void slider_init8(SLIDER8 *p)
{
	char chan=  p->slchan = (char) ((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider8");    
		return;
	}
    if (chan  < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLD *sld=p->s;
    register char *slnum = p->slnum;
    register float *min = p->min, *max= p->max;
    register FUNC **ftp = p->ftp; 
    
    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;
    
    while (j++ < 8) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;
			
		value =  (*(sld++)->initvalue - *min) / (*max++ - *min++);
		chanblock[*slnum++] =  (float)((int)(value * f7bit + .5));
	}
			}
}

void slider8(SLIDER8 *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;

	while (j++ < 8) 
	{
		value = (float) (chanblock[*slnum++] * oneTOf7bit);
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); /* no interpolation */
	   	**result++ = value * (*max++ - *min) + *min++;   /* scales the output */
	}
}


void slider_init16(SLIDER16 *p)
{
	char chan=  p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider16");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLD *sld=p->s;
    register char *slnum = p->slnum;
    register float *min = p->min, *max= p->max;
    register FUNC **ftp = p->ftp; 
    
    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 16) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			initerror("illegal control number");
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		
		value =  (*(sld++)->initvalue - *min) / (*max++ - *min++);
		chanblock[*slnum++] =  (float)((int)(value * f7bit + .5));
	}
			}
}


void slider16(SLIDER16 *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;

	while (j++ < 16) 
	{
		value = (float)(chanblock[*slnum++] * oneTOf7bit);
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); /* no interpolation */
	   	**result++ = value * (*max++ - *min) + *min++;   /* scales the output */
	}
}




void slider_init32(SLIDER32 *p)
{
	char chan= p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider32");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLD *sld=p->s;
    register char *slnum = p->slnum;
    register float *min = p->min, *max= p->max;
    register FUNC **ftp = p->ftp; 
    
    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 32) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		
		value =  (*(sld++)->initvalue - *min) / (*max++ - *min++);
		chanblock[*slnum++] =  (float)((int)(value * f7bit + .5));
	}
			}
}


void slider32(SLIDER32 *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;

	while (j++ < 32) 
	{
		value = (float)(chanblock[*slnum++] * oneTOf7bit);
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); /* no interpolation */
	   	**result++ = value * (*max++ - *min) + *min++;   /* scales the output */
	}
}



void slider_init64(SLIDER64 *p)
{
	char chan= p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider64");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLD *sld=p->s;
    register char *slnum = p->slnum;
    register float *min = p->min, *max= p->max;
    register FUNC **ftp = p->ftp; 
    
    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 64) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		
		value =  (*(sld++)->initvalue - *min) / (*max++ - *min++);
		chanblock[*slnum++] =  (float)(int)(value * f7bit + .5f);
	}
			}
}


void slider64(SLIDER64 *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;

	while (j++ < 64) 
	{
		value = chanblock[*slnum++] * oneTOf7bit;
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); /* no interpolation */
	   	**result++ = value * (*max++ - *min) + *min++;   /* scales the output */
	}
}

/*==============================*/
void slider_init8f(SLIDER8f *p)
{
	char chan= p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider8f");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLDf *sld=p->s;
    register char *slnum = p->slnum;
    register float *min = p->min, *max= p->max;
	register FUNC **ftp = p->ftp; 
    
	register float	b;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;
    while (j++ < 8) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		
		value =  (*sld->initvalue - *min) / (*max++ - *min++);
		chanblock[*slnum++] =  (float)(int)(value * f7bit + .5);

		/*----- init filtering coeffs*/
		*yt1++ = 0;
		b = (float)(2. - cos((double)(*(sld++)->ihp * tpidsr * ksmps)));
		*c2 = (float)(b - sqrt((double)(b * b - 1.)));
		*c1++ = 1.0f - *c2++;
		
	}
			}
}

void slider8f(SLIDER8f *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	while (j++ < 8) 
	{
		value = chanblock[*slnum++] * oneTOf7bit;
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); 
	 	value = value * (*max++ - *min) + *min++; 	/* scales the output */
	   	**result++ = *yt1++ = *c1++  * value + *c2++ * *yt1;  /* filters the output */

		/* yt1++; c1++;  c2++; */
	}
}


void slider_init16f(SLIDER16f *p)
{
	char chan = p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider16f");    
		return;
	}
    if (chan < 0 || chan > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLDf *sld=p->s;
    register char *slnum = p->slnum;
    

    register float *min = p->min, *max= p->max;
	register FUNC **ftp = p->ftp; 
    
	register float	b;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 16) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		value =  (*sld->initvalue - *min) / (*max++ - *min++);

		chanblock[*slnum++] =  (float)(int)(value * f7bit + .5);
	
		/*----- init filtering coeffs*/
		*yt1++ = 0;
		b = (float)(2. - cos((double)(*(sld++)->ihp * tpidsr * ksmps)));
		*c2 = (float)(b - sqrt((double)(b * b - 1.)));
		*c1++ = 1.0f - *c2++;
	}
			}
}

void slider16f(SLIDER16f *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	while (j++ < 16) 
	{
		value = chanblock[*slnum++] * oneTOf7bit;
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); 
	 	value = value * (*max++ - *min) + *min++; 	/* scales the output */
	   	**result++ = *yt1++ = *c1++  * value + *c2++ * *yt1;  /* filters the output */
	}
}


void slider_init32f(SLIDER32f *p)
{
	char chan =  p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider32f");    
		return;
	}
    if (chan < 0 || chan > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLDf *sld=p->s;
    register char *slnum = p->slnum;
    

    register float *min = p->min, *max= p->max;
	register FUNC **ftp = p->ftp; 
    
	register float	b;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 32) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		value =  (*sld->initvalue - *min) / (*max++ - *min++);

		chanblock[*slnum++] =  (float)(int)(value * f7bit + .5);
		
		/*----- init filtering coeffs*/
		*yt1++ = 0;
		b = (float)(2. - cos((double)(*(sld++)->ihp * tpidsr * ksmps)));
		*c2 = (float)(b - sqrt((double)(b * b - 1.)));
		*c1++ = 1.0f - *c2++;
	}
			}
}

void slider32f(SLIDER32f *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	while (j++ < 32) 
	{
		value = chanblock[*slnum++] * oneTOf7bit;
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); 
	 	value = value * (*max++ - *min) + *min++; 	/* scales the output */
	   	**result++ = *yt1++ = *c1++  * value + *c2++ * *yt1;  /* filters the output */
	}
}


void slider_init64f(SLIDER64f *p)
{
	char chan =  p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider64f");    
		return;
	}
    if (chan < 0 || chan > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register SLDf *sld=p->s;
    register char *slnum = p->slnum;
    

    register float *min = p->min, *max= p->max;
	register FUNC **ftp = p->ftp; 
    
	register float	b;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 64) {
    	if( (*slnum = (char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		value =  (*sld->initvalue - *min) / (*max++ - *min++);

		chanblock[*slnum++] =  (float) (int)(value * f7bit + .5);
		
		/*----- init filtering coeffs*/
		*yt1++ = 0;
		b = (float)(2. - cos((double)(*(sld++)->ihp * tpidsr * ksmps)));
		*c2 = (float)(b - sqrt((double)(b * b - 1.)));
		*c1++ = 1.0f - *c2++;
	}
			}
}

void slider64f(SLIDER64f *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum = p->slnum;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;
	register float *yt1 = p->yt1, *c1=p->c1, *c2=p->c2;

	while (j++ < 64) 
	{
		value = chanblock[*slnum++] * oneTOf7bit;
		if (*(++ftp))                /* if valid ftable,use value as index   */    
			value = *( (*ftp)->ftable + (long)(value * (*ftp)->flen)); 
	 	value = value * (*max++ - *min) + *min++; 	/* scales the output */
	   	**result++ = *yt1++ = *c1++  * value + *c2++ * *yt1;  /* filters the output */
	}
}



/*===================================*/

void islider8(ISLIDER8 *p)
{
	char chan= (char) ((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("islider8");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register ISLD *sld=p->s;
    register char slnum ;
   	register float *chanblock = (float *) m_chnbp[chan]->ctl_val; 
	register FUNC *ftp;
	register float **result = p->r;
   
    while (j++ < 8) {
    	if( (slnum=(char) *sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}

		value = chanblock[slnum] * oneTOf7bit;
	
		if (*sld->ifn > 0)  { ftp = ftfind(sld->ifn); 
			value = *( ftp->ftable + (long)(value * ftp->flen)); /* no interpolation */
		}
		
	   	**result++ = value * (*sld->imax - *sld->imin) + *sld->imin;   /* scales the output */
		sld++;
			}
	}
}


void islider16(ISLIDER16 *p)
{
	char chan= (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("islider16");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register ISLD *sld=p->s;
    register char slnum ;
   	register float *chanblock = (float *) m_chnbp[chan]->ctl_val; 
	register FUNC *ftp;
	register float **result = p->r;
   
    while (j++ < 16) {
    	if( (slnum=(char)*sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}

		value = chanblock[slnum] * oneTOf7bit;
	
		if (*sld->ifn > 0)  { ftp = ftfind(sld->ifn); 
			value = *( ftp->ftable + (long)(value * ftp->flen)); /* no interpolation */
		}
		
	   	**result++ = value * (*sld->imax - *sld->imin) + *sld->imin;   /* scales the output */
		sld++;
	}
			}
}


void islider32(ISLIDER32 *p)
{
	char chan= (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("islider32");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register ISLD *sld=p->s;
    register char slnum ;
   	register float *chanblock = (float *) m_chnbp[chan]->ctl_val; 
	register FUNC *ftp;
	register float **result = p->r;
   
    while (j++ < 32) {
    	if( (slnum=(char)*sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}

		value = chanblock[slnum] * oneTOf7bit;
	
		if (*sld->ifn > 0)  { ftp = ftfind(sld->ifn); 
			value = *( ftp->ftable + (long)(value * ftp->flen)); /* no interpolation */
		}
		
	   	**result++ = value * (*sld->imax - *sld->imin) + *sld->imin;   /* scales the output */
		sld++;
	}
			}
}


void islider64(ISLIDER64 *p)
{
	char chan= (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("islider64");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register ISLD *sld=p->s;
    register char slnum ;
   	register float *chanblock = (float *) m_chnbp[chan]->ctl_val; 
	register FUNC *ftp;
	register float **result = p->r;
   
    while (j++ < 64) {
    	if( (slnum=(char)*sld->ictlno) < 0) {
			sprintf(sbuf, "illegal control number at position n.%d",j);
			initerror(sbuf);
			break;
		}

		value = chanblock[slnum] * oneTOf7bit;
	
		if (*sld->ifn > 0)  { ftp = ftfind(sld->ifn); 
			value = *( ftp->ftable + (long)(value * ftp->flen)); /* no interpolation */
		}
		
	   	**result++ = value * (*sld->imax - *sld->imin) + *sld->imin;   /* scales the output */
		sld++;
	}
			}
}


/*-------------------------------*/

void slider_init16bit14(SLIDER16BIT14 *p)
{
	char chan= p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider16");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int intvalue, j=0;
    register SLD14 *sld=p->s;
    register char *slnum_msb = p->slnum_msb;
	register char *slnum_lsb = p->slnum_lsb;
    register float *min = p->min, *max= p->max;
    register FUNC **ftp = p->ftp; 
    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 16) {
    	if( (*slnum_msb = (char)*sld->ictlno_msb) < 0) {
			sprintf(sbuf, "illegal msb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
    	if( (*slnum_lsb = (char)*sld->ictlno_lsb) < 0) {
			sprintf(sbuf, "illegal lsb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		
		intvalue = (int) (((*(sld++)->initvalue - *min) / (*max++ - *min++)) * f14bit+.5);
		chanblock[*slnum_msb++] =  (float) (intvalue >> 7);
		chanblock[*slnum_lsb++] =  (float) (intvalue & 0x7f);
	}
			}
}


void slider16bit14(SLIDER16BIT14 *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum_msb = p->slnum_msb;
	register char  *slnum_lsb = p->slnum_lsb;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;

	while (j++ < 16) {
		value = (float)((chanblock[*slnum_msb++]  * 128 
		       + chanblock[*slnum_lsb++]) * oneTOf14bit); 
		if (*(++ftp)) {                /* if valid ftable,use value as index   */    
			register float phase = value * (*ftp)->flen;
			register float *base = (*ftp)->ftable + (long)(phase);;
			value = *base + (*(base+1) - *base) * (phase - (long) phase);
		}			
			
	   	**result++ = value * (*max++ - *min) + *min++;   /* scales the output */
	}
}


void slider_init32bit14(SLIDER32BIT14 *p)
{
	char chan= p->slchan = (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("slider32");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int intvalue, j=0;
    register SLD14 *sld=p->s;
    register char *slnum_msb = p->slnum_msb;
	register char *slnum_lsb = p->slnum_lsb;
    register float *min = p->min, *max= p->max;
    register FUNC **ftp = p->ftp; 
    register float *chanblock = (float *) m_chnbp[chan]->ctl_val;

    while (j++ < 32) {
    	if( (*slnum_msb = (char)*sld->ictlno_msb) < 0) {
			sprintf(sbuf, "illegal msb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
    	if( (*slnum_lsb = (char)*sld->ictlno_lsb) < 0) {
			sprintf(sbuf, "illegal lsb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if	((value=*sld->initvalue) < (*min=*sld->imin) || value > (*max=*sld->imax) ) {
			sprintf(sbuf, "illegal initvalue at position n.%d",j);
			initerror(sbuf);
			break;
		}
		if (*sld->ifn > 0)   *ftp++ = ftfind(sld->ifn); 
		else  *ftp++ = NULL;	
		
		intvalue = (int) (((*(sld++)->initvalue - *min) / (*max++ - *min++)) * f14bit+.5);
		chanblock[*slnum_msb++] = (float)( intvalue >> 7);
		chanblock[*slnum_lsb++] =  (float)(intvalue & 0x7f);
	}
			}
}


void slider32bit14(SLIDER32BIT14 *p)
{
    register float value;
  	register int j=0;
	register FUNC **ftp = p->ftp-1;
	register float *chanblock = (float *) m_chnbp[p->slchan]->ctl_val; 
	register char  *slnum_msb = p->slnum_msb;
	register char  *slnum_lsb = p->slnum_lsb;
	register float *min = p->min, *max = p->max;
	register float **result = p->r;

	while (j++ < 32) {
		value = (chanblock[*slnum_msb++]  * 128 
		       + chanblock[*slnum_lsb++]) * oneTOf14bit; 
		if (*(++ftp)) {			/* linear interpolation routine */    
			register float phase = value * (*ftp)->flen;
			register float *base = (*ftp)->ftable + (long)(phase);;
			value = *base + (*(base+1) - *base) * (phase - (long) phase);
		}
              /* if valid ftable,use value as index   */    
		
	   	**result++ = value * (*max++ - *min) + *min++;   /* scales the output */
	}
}

/*--------------------------------*/
void islider16bit14(ISLIDER16BIT14 *p)
{
	char chan= (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("islider16");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register ISLD14 *sld=p->s;
    register char slnum_msb;
	register char slnum_lsb;
   	register float *chanblock = (float *) m_chnbp[chan]->ctl_val; 
	register float **result = p->r;
   
    while (j++ < 16) {
    	if( (slnum_msb=(char)*sld->ictlno_msb) < 0) {
			sprintf(sbuf, "illegal msb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
    	if( (slnum_lsb=(char)*sld->ictlno_lsb) < 0) {
			sprintf(sbuf, "illegal lsb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}

		value =	(float)((chanblock[slnum_msb]  * 128 
		       + chanblock[slnum_lsb]) * oneTOf14bit); 
		if (*sld->ifn > 0)  {  			/* linear interpolation routine */    
			register FUNC *ftp= ftfind(sld->ifn); 
			register float phase = value * ftp->flen;
			register float *base = ftp->ftable + (long)(phase);
			value = *base + (*(base + 1) - *base) * (phase - (long) phase);
		}
		
	   	**result++ = value * (*sld->imax - *sld->imin) + *sld->imin;   /* scales the output */
		sld++;
	}
			}
}

void islider32bit14(ISLIDER32BIT14 *p)
{
	char chan= (char)((*p->ichan)-1);
	if (midi_in_p_num < 0) {
		midi_in_error("islider32");    
		return;
	}
    if (chan < 0 || chan  > 15)  {
	    	initerror("illegal channel");
			return;
	}
      		{ 
   	register float value;
    register int j=0;
    register ISLD14 *sld=p->s;
    register char slnum_msb;
	register char slnum_lsb;
   	register float *chanblock = (float *) m_chnbp[chan]->ctl_val; 
	register float **result = p->r;
   
    while (j++ < 32) {
    	if( (slnum_msb=(char)*sld->ictlno_msb) < 0) {
			sprintf(sbuf, "illegal msb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}
    	if( (slnum_lsb=(char)*sld->ictlno_lsb) < 0) {
			sprintf(sbuf, "illegal lsb control number at position n.%d",j);
			initerror(sbuf);
			break;
		}

		value =	(chanblock[slnum_msb]  * 128 
		       + chanblock[slnum_lsb]) * oneTOf14bit; 
		if (*sld->ifn > 0)  { 
			/* linear interpolation routine */    
			register FUNC *ftp= ftfind(sld->ifn); 
			register float phase = value * ftp->flen;
			register float *base = ftp->ftable + (long)(phase);
			value = *base + (*(base + 1) - *base) * (phase - (long) phase);
		}
		
	   	**result++ = value * (*sld->imax - *sld->imin) + *sld->imin;   /* scales the output */
		sld++;
	}
			}
}
#endif /* GAB_RT */
