#include "cs.h"
#include "schedule.h"
#include <math.h>

extern INSTRTXT **instrtxtp;
extern OENTRY	opcodlst[];
extern INSDS   actanchor, *curip, *frstoff ,*instance(int);
extern float onedkr, ekr;
extern int   ksmps;
extern long  kcounter;
extern int   tieflag;
extern void    showallocs(void);
extern void    deact(INSDS *), schedofftim(INSDS *);

typedef struct rsched {
  void		*parent;
  INSDS  	*kicked;
  struct rsched *next;
} RSCHED;

static RSCHED *kicked = NULL;

INSDS *insert_event(float instr,
		    float when,
		    float dur,
		    int narg,
		    float **args,
		    int midi)
{
    int insno = (int)instr;
    EVTBLK *e = (EVTBLK *) mmalloc((long)sizeof(EVTBLK));
    int j;

    tieflag = 0;
    e->opcod = 'i';
    e->pcnt = narg; 			   
    e->offtim = when+dur;     /* indef perf */
    e->p[1] = instr;
    e->p[2] = when;
    e->p[3] = dur;
    e->p2orig = when;
    e->p3orig = dur;
    for (j= 0; j < narg-3; j++) {
      e->p[j+4] = *args[j];
    }
    if (instrtxtp[insno] == NULL) {  
      printf("schedule event ignored. instr %d undefined\n", insno);
      perferrcnt++;
    }
    else {			/* Insert this event into event queue */
      INSTRTXT  *tp;
      INSDS     *ip, *prvp, *nxtp;
      OPDS	*ids;	
      VMSG(printf("activating instr %d\n",insno);)
      inerrcnt = 0;
      tp = instrtxtp[insno];
      if (tp->mdepends & 04) {
	printf("instr %d expects midi event data, can't run from score\n",
	       insno);
	return NULL;
      }
      if ((ip = tp->instance) != NULL) { /* if allocs of text exist: */
	do {
	  if (ip->insno == insno 	/*	 if find this insno,  */
	      && ip->actflg		/*	  active	      */
	      && ip->offtim < 0		/*	  with indef (tie)    */
	      && ip->p1 == e->p[1]){ /*  & matching p1	*/
	    tieflag++;		
	    goto init;			/*	  continue that event */
	  }
	} while ((ip = ip->nxtinstance) != NULL);
	ip = tp->instance;		/*	 else get alloc of text */
	do {
	  if (!ip->actflg)		/*		that is free	*/
	    goto actlnk;		/*	      and use its space	*/
	} while ((ip = ip->nxtinstance) != NULL);
      }
      
      if (O.msglevel & 2) printf("new alloc for instr %d:\n",insno);
      ip = instance(insno);	/* else alloc new dspace  */
	
    actlnk: 
      ip->insno = insno;
      nxtp = &actanchor;	/* now splice into active list */
      while ((prvp = nxtp) && (nxtp = prvp->nxtact) != NULL)
	if (nxtp->insno > insno
	    || nxtp->insno == insno
	    && nxtp->p1 > e->p[1]) {
	  nxtp->prvact = ip;
	  break;
	}
      ip->nxtact = nxtp;
      ip->prvact = prvp;
      prvp->nxtact = ip;
      ip->actflg++;		/*	  and mark the instr active */
      {
	int    n;
	float  *flp, *fep;
	
      init:	
	if ((n = tp->pmax) != e->pcnt) {
	  sprintf(errmsg,"instr %d pmax = %d, note pcnt = %d",
		  insno, n, e->pcnt);
	  warning(errmsg);
	}
	if (e->p3orig >= 0.0)
	  ip->offbet = e->p2orig + e->p3orig;
	else ip->offbet = -1.0f;
	flp = &ip->p1;
	fep = &e->p[1];
	VMSG(printf("psave beg at %p\n",flp);)
	do	*flp++ = *fep++; /* psave	*/
	while (--n);
	VMSG(printf("   ending at %p\n",flp);)
      }
      ip->offtim = ip->p3;	/* & duplicate p3 for now */
      ip->xtratim = 0;
      ip->relesing = 0;
      curip = ip;
      ids = (OPDS *)ip;
      while ((ids = ids->nxti) != NULL) {  /* do init pass for this instr */
	VMSG(printf("init %s:\n",
		    opcodlst[ids->optext->t.opnum].opname);)
	  (*ids->iopadr)(ids);
      }
      tieflag = 0;
      if (inerrcnt || !ip->p3) {
	deact(ip);
	return ip;
      }
      if (!midi) { /* if not MIDI activated */
	if (ip->p3 > 0.0f) {	/* if still finite time, */
	  ip->offtim = ip->p2 + ip->p3;
	  schedofftim(ip);	/*	 put in turnoff list */
	}
	else ip->offtim = -1.0f; /* else mark indef */
      }
      VMSG({	printf("instr %d now active:\n",insno); showallocs(); })
      return ip;
    }
    mfree(e);
    return NULL;
}

/* ********** Need to add turnoff stuff *************** */
void schedule(SCHED *p)
{
    RSCHED *rr = kicked;        /* First ensure any stragglers die */
    RSCHED *ss = NULL;          /* really incase of reinit */
    while (rr!=NULL) {
      if (rr->parent==p) {
       if (rr->kicked->xtratim) { /*	  if offtime delayed  */
	rr->kicked->relesing = 1;/* 	enter reles phase     */
	rr->kicked->offtim = (kcounter + rr->kicked->xtratim) * onedkr;
	schedofftim(rr->kicked);	/*	    & put in offqueue */
       }
       else deact(rr->kicked); 	/*	  else off now	      */
       {
         RSCHED *tt = rr->next; 
         free(rr);
         rr = tt;
         if (ss==NULL) kicked = rr;
       }
      }
      else {
        ss = rr; rr = rr->next;
      }
    }

    if (*p->which >= curip->p1 || *p->when>0) {
      RSCHED *rr;
      /* if duration is zero assume MIDI schedule */
      float dur = *p->dur;
      p->midi = (dur<=0.0f);
      if (p->midi) {
	short *xtra;
	/* set 1 k-cycle of extratime in ordeto allow mtrnoff to
	   recognize whether the note is turned off */
	if (*(xtra = &(p->h.insdshead->xtratim)) < 1 )
	  *xtra = 1;
      }
      p->kicked = insert_event(*p->which, *p->when+kcounter*onedkr, dur,
			       p->INOCOUNT, p->argums, p->midi);
      if (p->midi) {
        rr = (RSCHED*) malloc(sizeof(RSCHED));
        rr->parent = p; rr->kicked = p->kicked; rr->next = kicked;
        kicked = rr;
      }
    }
    else
      VMSG({printf("Cannot schedule instr %d at inc time %f\n",
		   (int)*p->which, *p->when);})
}

void schedwatch(SCHED *p)
{				/* If MIDI case watch for release */
    if (p->midi && p->h.insdshead->relesing) {
      p->midi = 0;
      if (p->kicked==NULL) return;
      if (p->kicked->xtratim) { /*	  if offtime delayed  */
	p->kicked->relesing = 1; /* 	enter reles phase */
	p->kicked->offtim = (kcounter + p->kicked->xtratim) * onedkr;
	schedofftim(p->kicked);	/*		& put in offqueue */
      }
      else deact(p->kicked); 	/*	  else off now		  */
      {
        RSCHED *rr = kicked;
        RSCHED *ss = NULL;
        while (rr!=NULL) {
          if (rr->parent==p) {
            RSCHED *tt = rr->next; 
            free(rr);
            rr = tt;
            if (ss==NULL) kicked = rr;
    }
          else {
            ss = rr; rr = rr->next;
          }
        }
      }
      p->kicked = NULL;
    }
}

void ifschedule(WSCHED *p)
{			/* All we need to do is ensure the trigger is set */
    p->todo = 1;
    p->abs_when = curip->p2;		/* Adjust time */
    p->midi = 0;
}

void kschedule(WSCHED *p)
{
    if (p->todo && *p->trigger!=0.0) { /* If not done and trigger */
      RSCHED *rr;
      float dur = *p->dur;
      p->midi = (dur<=0.0f);
      p->todo = 0;
				/* Insert event */
      p->kicked = insert_event(*p->which, *p->when+p->abs_when, dur,
			       p->INOCOUNT, p->argums-1, p->midi);
      if (p->midi) {
        rr = (RSCHED*) malloc(sizeof(RSCHED));
        rr->parent = p; rr->kicked = p->kicked; rr->next = kicked;
        kicked = rr;
    }
    }
    else if (p->midi && p->h.insdshead->relesing) {
				/* If MIDI case watch for release */
      p->midi = 0;
      if (p->kicked==NULL) return;
      if (p->kicked->xtratim) { /*	  if offtime delayed  */
	p->kicked->relesing = 1;/* 	enter reles phase     */
	p->kicked->offtim = (kcounter + p->kicked->xtratim) * onedkr;
	schedofftim(p->kicked);	/*	    & put in offqueue */
      }
      else deact(p->kicked); 	/*	  else off now	      */
      {
        RSCHED *rr = kicked;
        RSCHED *ss = NULL;
        while (rr!=NULL) {
          if (rr->parent==p) {
            RSCHED *tt = rr->next; 
            free(rr);
            rr = tt;
            if (ss==NULL) kicked = rr;
          }
          else {
            ss = rr; rr = rr->next;
          }
        }
      }
      p->kicked = NULL;
    }
}

extern float kicvt;

/* tables are 4096 entries always */

#define MAXPHASE 0x1000000
#define MAXMASK  0x0ffffff
void lfoset(LFO *p)
{
  /* Types: 0:	sine
            1:  triangles
	    2:  square (biplar)
	    3:  square (unipolar)
	    4:  saw-tooth
	    5:  saw-tooth(down)
	    */
    int type = (int)*p->type;
    if (type == 0) {		/* Sine wave so need to create */
      int i;
      if (p->auxd.auxp==NULL) {
	auxalloc(sizeof(float)*4097L, &p->auxd);
	p->sine = (float*)p->auxd.auxp;
      }
      for (i=0; i<4096; i++)
	p->sine[i] = (float)sin(TWOPI*(double)i/4096.0);
/*        printf("Table set up (max is %d)\n", MAXPHASE>>10); */
    }
    else if (type>5 || type<0) {
      sprintf(errmsg, "LFO: unknown oscilator type %d", type);
      initerror(errmsg);
    }
    p->lasttype = type;
    p->phs = 0;
}

void lfok(LFO *p)
{
    long	phs;
    float	fract;
    float	res;
    long	iphs;

    phs = p->phs;
    switch (p->lasttype) {
    case 0:
      iphs = phs >> 12;
      fract = (float)(phs & 0xfff)/4096.0f;
      res = p->sine[iphs];
      res = res + (p->sine[iphs+1]-res)*fract;
      break;      
    case 1:			/* Trangular */
      res = (float)((phs<<2)&MAXMASK)/(float)MAXPHASE;
      if (phs < MAXPHASE/4) {}
      else if (phs < MAXPHASE/2)
	res = 1.0f - res;
      else if (phs < 3*MAXPHASE/4)
	res = - res;
      else
	res = res - 1.0f;
      break;
    case 2:			/* Bipole square wave */
      if (phs<MAXPHASE/2) res = 1.0f;
      else res = -1.0f;
      break;
    case 3:			/* Unipolar square wave */
      if (phs<MAXPHASE/2) res = 1.0f;
      else res = 0.0f;
      break;
    case 4:			/* Saw Tooth */
      res = (float)phs/(float)MAXPHASE;
      break;
    case 5:			/* Reverse Saw Tooth */
      res = 1.0f - (float)phs/(float)MAXPHASE;
      break;
    }
    phs += (long)(*p->xcps * MAXPHASE / ekr);
    phs &= MAXMASK;
    p->phs = phs;
    *p->res = *p->kamp * res;
}

void lfoa(LFO *p)
{
    int		nsmps = ksmps;
    long	phs;
    float	fract;
    float	res;
    long	iphs, inc;
    float	*ar, amp;

    phs = p->phs;
    if (p->lasttype) inc = (long)(*p->xcps * 4096.0f /esr);
    else inc = (long)(*p->xcps * (float)MAXPHASE /esr);
    
    amp = *p->kamp;
    ar = p->res;
    do {
      iphs = phs >> 12;
      switch (p->lasttype) {
      case 0:
	fract = (float)(phs & 0xfff)/4096.0f;
	res = p->sine[iphs];
	res = res + (p->sine[iphs+1]-res)*fract;
	break;      
      case 1:			/* Trangular */
	res = (float)((phs<<2)&MAXMASK)/(float)MAXPHASE;
	if (phs < MAXPHASE/4) {}
	else if (phs < MAXPHASE/2)
	  res = 1.0f - res;
	else if (phs < 3*MAXPHASE/4)
	  res = - res;
	else
	  res = res - 1.0f;
	break;
      case 2:			/* Bipole square wave */
	if (phs<MAXPHASE/2) res = 1.0f;
	else res = -1.0f;
	break;
      case 3:			/* Unipolar square wave */
	if (phs<MAXPHASE/2) res = 1.0f;
	else res = 0.0f;
	break;
      case 4:			/* Saw Tooth */
	res = (float)phs/(float)MAXPHASE;
	break;
      case 5:			/* Reverse Saw Tooth */
	res = 1.0f - (float)phs/(float)MAXPHASE;
	break;
      }
      phs += inc;
      phs &= MAXMASK;
      *ar++ = res * amp;
    } while (--nsmps);
    p->phs = phs;
}
