/*

------------------------------------------------------------------------------

A license is hereby granted to reproduce this software source code and
to create executable versions from this source code for personal,
non-commercial use.  The copyright notice included with the software
must be maintained in all copies produced.

THIS PROGRAM IS PROVIDED "AS IS". THE AUTHOR PROVIDES NO WARRANTIES
WHATSOEVER, EXPRESSED OR IMPLIED, INCLUDING WARRANTIES OF
MERCHANTABILITY, TITLE, OR FITNESS FOR ANY PARTICULAR PURPOSE.  THE
AUTHOR DOES NOT WARRANT THAT USE OF THIS PROGRAM DOES NOT INFRINGE THE
INTELLECTUAL PROPERTY RIGHTS OF ANY THIRD PARTY IN ANY COUNTRY.

Copyright (c) 1995, John Conover, All Rights Reserved.

Comments and/or bug reports should be addressed to:

    john@johncon.com (John Conover)

------------------------------------------------------------------------------

lexicon.h, general include file for lexicon.c

$Revision: 1.0 $
$Date: 1995/04/22 05:14:50 $
$Id: lexicon.h,v 1.0 1995/04/22 05:14:50 john Exp $
$Log: lexicon.h,v $
 * Revision 1.0  1995/04/22  05:14:50  john
 * Initial revision
 *

*/

#ifndef _LEXICON_H /* if not defined then lexicon.h has not yet been included */

#define _LEXICON_H

#define LEXICON_H_ID "$Id: lexicon.h,v 1.0 1995/04/22 05:14:50 john Exp $" /* module version */

/*

lexicon types of tokens, in order of increasing precedence, beginning
with a '(' and proceeding through the operators, and concluding with a
')', "a word/identifier," and, "no token:" the enum value will be the
precedence of the token

*/

enum token_type
{
    LEFT, /* '(' grouping operator */
    OR, /* "or" operator */
    AND, /* "and" operator */
    NOT, /* "not" operator */
    RIGHT, /* ')' grouping operator */
    IDENTIFIER, /* a word */
    NONE /* no token */
};

#ifdef __STDC__

extern enum token_type lexicon (char *buffer, unsigned char *token);

#else

extern enum token_type lexicon ();

#endif

#endif
