/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventInMFVec2f.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.MFVec2f;

public class EventInMFVec2f extends EventIn
{
  public void setValue (float[][] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (value == null)
      throw new IllegalArgumentException ();

    float[] data = new float[value.length * 2];

    int index = 0;
    for (int i = 0; i < value.length; i++)
    {
      if (value[i].length != 2)
        throw new IllegalArgumentException ();
      data[index] = value[i][0];
      data[index+1] = value[i][1];
      index += 2;
    }

    ((MFVec2f) eventin_).setValue (data);

    sendEvent ();

    scene_.redraw ();
  }

  public void set1Value (int index, float[] value) throws IllegalArgumentException
  {
    if (!scene_.getBehavior ())
      return;

    if (index < 0 || index >= ((MFVec2f) eventin_).getValueCount () || value == null || value.length != 2)
      throw new IllegalArgumentException ();

    float[] data = ((MFVec2f) eventin_).getValueData ();
    index *= 2;
    data[index] = value[0];
    data[index+1] = value[1];

    sendEvent ();

    scene_.redraw ();
  }
}
