/*
 * <copyright>
 *
 * Copyright (c) 1997
 * Institute for Information Processing and Computer Supported New Media (IICM),
 * Graz University of Technology, Austria.
 *
 * This file is part of the VRwave Java-EAI implementation.
 *
 * </copyright>
 */
/*
 * created: kwagen, 19970801
 *
 * changed: kwagen, 19970916
 *
 * $Id: EventOutSFImage.java,v 1.1 1997/09/17 11:52:53 kwagen Exp $
 */

package vrml.external.field;

import iicm.vrml.pw.SFImage;

public class EventOutSFImage extends EventOut
{
  public int getWidth ()
  {
    int[] data = ((SFImage) eventout_).getValueData ();
    return data[0];
  }

  public int getHeight ()
  {
    int[] data = ((SFImage) eventout_).getValueData ();
    return data[1];
  }

  public int getNumComponents ()
  {
    int[] data = ((SFImage) eventout_).getValueData ();
    return data[2];
  }

  public byte[] getPixels ()
  {
    int[] data = ((SFImage) eventout_).getValueData ();
    byte[] pixels = new byte[data[0] * data[1] * data[2]];

    int index = 0;
    switch (data[2])
    {
      case 1:
        for (int i = 0; i < data[0] * data[1]; i++)
          pixels[i] = (byte) data[3+i];
        break;
      case 2:
        for (int i = 0; i < data[0] * data[1]; i++)
        {
          pixels[index] = (byte) (data[3+i] >> 8);
          pixels[index+1] = (byte) (data[3+i] & 255);
          index += 2;
        }
        break;
      case 3:
        for (int i = 0; i < data[0] * data[1]; i++)
        {
          pixels[index] = (byte) (data[3+i] >> 16);
          pixels[index+1] = (byte) ((data[3+i] >> 8) & 255);
          pixels[index+2] = (byte) (data[3+i] & 255);
          index += 3;
        }
        break;
      case 4:
        for (int i = 0; i < data[0] * data[1]; i++)
        {
          pixels[index] = (byte) (data[3+i] >> 24);
          pixels[index+1] = (byte) ((data[3+i] >> 16) & 255);
          pixels[index+2] = (byte) ((data[3+i] >> 8) & 255);
          pixels[index+3] = (byte) (data[3+i] & 255);
          index += 4;
        }
        break;
    }

    return pixels;
  }
}
