#include <stdio.h>

#include <X11/Xlib.h>
#include "list.h"
#include "generic.h"

typedef struct {
	ltgenericd g;
	tdisplay dpy;
	XColor c;
	} ltcolord, *ltcolor;

typedef struct {
	ltgenericd g;
	tdisplay dpy;
	Display *xdpy;
	Colormap cmap;
	unsigned long pixel;
	ltcolor cl;
	tframe f;
	tpanel p;
	int width;
	tpbutton o, cancel;
	tpslider rs, gs, bs;
	tptext t;
	tcanvas cv;
	tcontext gc;
	void (*do_events)();
	} ltcolorchooserd, *ltcolorchooser;

list colors=NULL;

tcolor tcolor_new(where, name, red, green, blue)
titem where;
char *name;
int red, green, blue;
{
	Display *xdpy;
	Colormap cmap;
	tdisplay dpy;
	ltcolor tmp, q;

	if(where==NULL)
		return(NULL);
	dpy=(tdisplay)titem_display(where);
	xdpy=(Display *)tdisplay_X(dpy);
	cmap=(Colormap)tdisplay_XColormap(dpy);

	tmp=(ltcolor)titem_new(where, lt_color, sizeof(ltcolord));
	if(tmp==NULL)
		return(NULL);

	tmp->dpy=dpy;

	if(name!=NULL)
	{
		if(!XParseColor(xdpy, cmap, name, &tmp->c))
		{
			titem_free(tmp);
			return(NULL);
		}
	}
	else
	{
		tmp->c.red=red;
		tmp->c.green=green;
		tmp->c.blue=blue;
	}

	if(colors==NULL)
		colors=newlist();
	startlist(colors);
	while((q=listnext(colors))!=NULL)
		if(q->c.red==tmp->c.red &&
				q->c.blue==tmp->c.blue &&
				q->c.green==tmp->c.green)
			break;

	if(q==NULL)
	{
		if(!XAllocColor(xdpy, cmap, &tmp->c))
		{
			titem_free(tmp);
			return(NULL);
		}
		startlist(colors);
		addnode(colors, tmp);
	}
	else
	{
		titem_free(tmp);
		tmp=q;
	}
		
	return(tmp);
}

int tcolor_free(c)
ltcolor c;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_color)
		return(0);

	titem_free(c);
	return(1);
}

int tcolor_values(c, r, g, b)
ltcolor c;
int *r, *g, *b;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_color)
		return(0);

	*r=c->c.red;
	*g=c->c.green;
	*b=c->c.blue;
	return(1);
}

tcolor tcolor_black(where)
titem where;
{
	if(where==NULL)
		return(NULL);
	
	return(tcolor_new(where, NULL, 0, 0, 0));
}

tcolor tcolor_white(where)
titem where;
{
	if(where==NULL)
		return(NULL);
	return(tcolor_new(where, NULL, 65535, 65535, 65535));
}

XColor *tcolor_Xcolor(c)
ltcolor c;
{
	/* check type */
	if(c==NULL)
		return(NULL);
	if(titem_type(c)!=lt_color)
		return(NULL);
	
	return(&c->c);
}

unsigned long tcolor_Xpixel(c)
ltcolor c;
{
	/* check type */
	if(c==NULL)
		return(0);
	if(titem_type(c)!=lt_color)
		return(0);
	
	return(c->c.pixel);
}

tcolor_change_red(s, e, v)
tpslider s;
tevent e;
int v;
{
	ltcolorchooser ch;
	unsigned short new;
	Status result;

	ch=(tcolor)titem_get_intdata(s);
	new=65535*v/100;
	ch->cl->c.red=new;
	result=XStoreColor(ch->xdpy, ch->cmap, &ch->cl->c);
	tptext_set_val(ch->t, "");
}

tcolor_change_green(s, e, v)
tpslider s;
tevent e;
int v;
{
	ltcolorchooser ch;
	unsigned short new;
	Status result;

	ch=(tcolor)titem_get_intdata(s);
	new=65535*v/100;
	ch->cl->c.green=new;
	result=XStoreColor(ch->xdpy, ch->cmap, &ch->cl->c);
	tptext_set_val(ch->t, "");
}

tcolor_change_blue(s, e, v)
tpslider s;
tevent e;
int v;
{
	ltcolorchooser ch;
	unsigned short new;
	Status result;

	ch=(tcolor)titem_get_intdata(s);
	new=65535*v/100;
	ch->cl->c.blue=new;
	result=XStoreColor(ch->xdpy, ch->cmap, &ch->cl->c);
	tptext_set_val(ch->t, "");
}

tcolor_choose_ok(b, e)
tpbutton b;
tevent e;
{
	ltcolorchooser ch;

	ch=(tcolor)titem_get_intdata(b);

	if(ch->do_events!=NULL)
		(*ch->do_events)(ch->cl->c.red, ch->cl->c.green, ch->cl->c.blue);
	
}

tcolor_choose_cancel(b, e)
tpbutton b;
tevent e;
{
	ltcolorchooser ch;

	ch=(tcolor)titem_get_intdata(b);

	tframe_pull_pin(ch->f);
	tframe_hide(ch->f);
}

int draw_colored_square(c, e)
tcanvas c;
tevent e;
{
	ltcolorchooser ch;
	ch=(tcolor)titem_get_intdata(c);
	if(tevent_type(e)==te_repaint)
	{
		draw_filled_rect(c, ch->gc, 0, 0, ch->width, 100);
	}
}

int enter_color_name(t, e)
tptext t;
tevent e;
{
	ltcolorchooser ch=(ltcolorchooser)titem_get_intdata(t);
	char *s;
	XColor c;
	Status result;
	int rn, bn, gn; 

	if(tevent_type(e)==te_keydown)
	{
		s=tevent_string(e);
		if(s[0]=='\n' || s[0]=='\r')
		{
			s=tptext_get_val(t);
			if(!XParseColor(ch->xdpy, ch->cmap, s, &c))
				tnotice_no_choice(e,
					tevent_xview_x(e),
					tevent_xview_y(e),
					"Invalid color name");
			else
			{
				ch->cl->c.red=c.red;
				ch->cl->c.blue=c.blue;
				ch->cl->c.green=c.green;
				rn=c.red*100/65535;
				bn=c.blue*100/65535;
				gn=c.green*100/65535;
				tpslider_set_val(ch->rs, rn);
				tpslider_set_val(ch->bs, bn);
				tpslider_set_val(ch->gs, gn);
				result=XStoreColor(ch->xdpy, ch->cmap, &ch->cl->c);
			}
		}
		return(tptext_insert);
	}
}

tcolor_change_chooser_color(ch, c)
ltcolorchooser ch;
ltcolor c;
{
	int rn, bn, gn;
	Status result;

	if(ch==NULL || c==NULL)
		return(0);
	if(titem_type(ch)!=lt_colorchooser || titem_type(c)!=lt_color)
		return(0);
	
	ch->cl->c.red=c->c.red;
	ch->cl->c.green=c->c.green;
	ch->cl->c.blue=c->c.blue;
	rn=c->c.red*100/65535;
	bn=c->c.blue*100/65535;
	gn=c->c.green*100/65535;
	tpslider_set_val(ch->rs, rn);
	tpslider_set_val(ch->bs, bn);
	tpslider_set_val(ch->gs, gn);
	result=XStoreColor(ch->xdpy, ch->cmap, &ch->cl->c);
	tptext_set_val(ch->t, "");
}

tcolorchooser tcolor_new_chooser(where, args, do_events, s)
titem where;
targs args;
void (*do_events)();
char *s;
{
	ltcolorchooser ch;
	tdisplay dpy;
	Status result;
	unsigned long p_masks;

	if(where==NULL)
		return(NULL);
	dpy=(tdisplay)titem_display(where);
	ch=(ltcolorchooser)titem_new(dpy,
		lt_colorchooser, sizeof(ltcolorchooserd));
	ch->cl=(ltcolor)titem_new(dpy,
		lt_color, sizeof(ltcolord));
	ch->dpy=dpy;
	ch->cl->dpy=dpy;
	ch->cmap=tdisplay_XColormap(dpy);
	ch->xdpy=(Display *)tdisplay_X(dpy);
	result=XAllocColorCells(ch->xdpy, ch->cmap, False,
		&p_masks, 0,
		&ch->cl->c.pixel, 1);

	ch->cl->c.red=6500;
	ch->cl->c.green=1000;
	ch->cl->c.blue=0;
	ch->cl->c.flags=DoRed|DoGreen|DoBlue;
	XStoreColor(ch->xdpy, ch->cmap, &ch->cl->c);
	ch->f=tframe_new(where, 0, 0, 500, 500, 0, 1, 0, s, args);
	ch->p=(tpanel)tframe_dialog_panel(ch->f);
	ch->do_events=do_events;
	ch->o=(tpbutton)tpbutton_new(ch->p,	
		10, 10, 0, 0, NULL, NULL, "OK");
	tpbutton_set_event_procedure(ch->o, tcolor_choose_ok);
	titem_set_intdata(ch->o, ch);
	ch->cancel=(tpbutton)tpbutton_new(ch->p,	
		10, 10, 0, 0, ch->o, NULL, "Cancel");
	tpbutton_set_event_procedure(ch->cancel, tcolor_choose_cancel);
	titem_set_intdata(ch->cancel, ch);
	ch->rs=tpslider_new(ch->p, 10, 110, 0, 0, NULL, ch->o,
		"% Red    :", 0, 100);
	tpslider_hide_range(ch->rs);
	tpslider_set_event_procedure(ch->rs, tcolor_change_red);
	titem_set_intdata(ch->rs, ch);
	ch->gs=tpslider_new(ch->p, 10, 110, 0, 0, NULL, ch->rs,
		"% Green:", 0, 100);
	tpslider_hide_range(ch->gs);
	tpslider_set_event_procedure(ch->gs, tcolor_change_green);
	titem_set_intdata(ch->gs, ch);
	ch->bs=tpslider_new(ch->p, 10, 110, 0, 0, NULL, ch->gs,
		"% Blue  :", 0, 100);
	tpslider_hide_range(ch->bs);
	tpslider_set_event_procedure(ch->bs, tcolor_change_blue);
	titem_set_intdata(ch->bs, ch);
	ch->t=tptext_new(ch->p, 10, 10, 0, 0, NULL, ch->bs, "Choose by name:");
	tptext_set_displayed_characters(ch->t, 20);
	tptext_set_event_procedure(ch->t, enter_color_name);
	titem_set_intdata(ch->t, ch);
	tpanel_fit(ch->p);
	ch->width=tpanel_width(ch->p);
	ch->cv=(tcanvas)tcanvas_new_no_scrollbars(ch->f,
		0, 0, ch->width, 100, NULL, ch->p, 0, args);
	tcanvas_set_event_procedure(ch->cv, draw_colored_square);
	titem_set_intdata(ch->cv, ch);
	tcanvas_pages(ch->cv, 0);
	ch->gc=tcontext_new(where, args);
	tcontext_set_foreground(ch->gc, ch->cl);

	tframe_fit(ch->f);
	tpanel_set_width_to_frame(ch->p, ch->f);
	tframe_hide(ch->f);
	tptext_set_current(ch->t);
	return(ch);
}

int tcolor_hide_chooser(ch)
ltcolorchooser ch;
{
	if(ch==NULL)
		return(0);
	if(titem_type(ch)!=lt_colorchooser)
		return(0);
	
	tframe_hide(ch->f);
}

int tcolor_show_chooser(ch)
ltcolorchooser ch;
{
	if(ch==NULL)
		return(0);
	if(titem_type(ch)!=lt_colorchooser)
		return(0);
	
	tframe_show(ch->f);
}

int tcolor_move_chooser(ch, win, x, y)
ltcolorchooser ch;
void *win;
int x,y;
{
	if(ch==NULL)
		return(0);
	if(titem_type(ch)!=lt_colorchooser)
		return(0);
	
	tframe_move(ch->f, win, x, y);
}
