/*
** Copyright (c) Massachusetts Institute of Technology 1994, 1995, 1996.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. This code may not be re-distributed or modified
**        without permission from MIT (contact 
**        lclint-request@larch.lcs.mit.edu.)  
**
**        Modification and re-distribution are encouraged,
**        but we want to keep track of changes and
**        distribution sites.
*/
# ifndef EKIND_H
# define EKIND_H

/* need to maintain compatibility with libraries */

immut_typedef enum {
  KINVALID = -1, 
  KDATATYPE = 0, /* must dump datatypes first, so ctypes are ok */
  KCONST, KENUMCONST,
  KVAR, KFCN, KITER, KENDITER,
  KSTRUCTTAG, KUNIONTAG, KENUMTAG,
  KELIPSMARKER
  } ekind;

/*@constant ekind KELAST;@*/
# define KELAST KELIPSMARKER

extern bool ekind_equal (ekind, ekind) /*@*/ ;
# define ekind_equal(e1, e2) ((e1) == (e2))

extern ekind ekind_fromInt (int i) /*@*/ ;
extern int ekind_toInt (ekind k) /*@*/ ;

extern bool ekind_isFunction (ekind k) /*@*/ ;
# define ekind_isFunction(k) ((k) == KFCN)

extern /*@unused@*/ bool ekind_isVariable (ekind k) /*@*/ ;
# define ekind_isVariable(k) ((k) == KVAR)

extern bool ekind_isElipsis (ekind k) /*@*/ ;
# define ekind_isElipsis(k)  ((k) == KELIPSMARKER)

extern bool ekind_isConst (ekind k) /*@*/ ;
# define ekind_isConst(k) ((k) == KCONST)

extern bool ekind_isEnumConst (ekind k) /*@*/ ;
# define ekind_isEnumConst(k) ((k) == KENUMCONST)

# define ekind_toInt(k)     ((int)(k))

/*@constant ekind ekind_variable; @*/
# define ekind_variable ((ekind)KVAR)

/*@constant ekind ekind_function; @*/
# define ekind_function ((ekind)KFCN)

extern /*@observer@*/ cstring ekind_capName (ekind k) /*@*/ ;
extern /*@observer@*/ cstring ekind_unparse (ekind k) /*@*/ ;
extern /*@observer@*/ cstring ekind_unparseLong (ekind k) /*@*/ ;

# else
# error "Multiple include"
# endif
