/****************************************************************************
** $Id: qbuffer.h,v 2.0 1996/09/24 10:16:08 agulbra Exp $
**
** Definition of QBuffer class
**
** Created : 930812
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QBUFFER_H
#define QBUFFER_H

#include "qiodev.h"
#include "qstring.h"


class QBuffer : public QIODevice		// buffer I/O device class
{
public:
    QBuffer();
    QBuffer( QByteArray );
   ~QBuffer();

    QByteArray buffer() const { return a; }
    bool  setBuffer( QByteArray );

    bool  open( int );
    void  close();
    void  flush();

    uint  size() const;
    int	  at()	 const;
    bool  at( int );

    int	  readBlock( char *p, uint );
    int	  writeBlock( const char *p, uint );
    int	  readLine( char *p, uint );

    int	  getch();
    int	  putch( int );
    int	  ungetch( int );

protected:
    QByteArray a;

private:
    uint  a_len;
    uint  a_inc;

private:	// Disabled copy constructor and operator=
    QBuffer( const QBuffer & ) {}
    QBuffer &operator=( const QBuffer & ) { return *this; }
};


inline uint QBuffer::size() const
{ return a.size(); }

inline int QBuffer::at() const
{ return index; }


#endif // QBUFFER_H
