/****************************************************************************
** $Id: qgeneric.h,v 2.0 1996/09/24 10:16:11 agulbra Exp $
**
** Macros for pasting tokens; utilized by our generic classes
**
** Created : 920529
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QGENERIC_H
#define QGENERIC_H


#if defined(_CC_MPW_)

#include <generic.h>		/* MPW C++ has a non-standard preprocessor */

#else

#define USE_STDC_MACROS		/* comment out this line for K&R style cpp */

#if defined(USE_STDC_MACROS)

// Standard token-pasting macros for ANSI C preprocessors

#define name2(a,b)		_name2_aux(a,b)
#define _name2_aux(a,b)		a##b
#define name3(a,b,c)		_name3_aux(a,b,c)
#define _name3_aux(a,b,c)	a##b##c
#define name4(a,b,c,d)		_name4_aux(a,b,c,d)
#define _name4_aux(a,b,c,d)	a##b##c##d

#else

// Token-pasting macros for outdated K&R C preprocessors

#define name2(a,b)		a/**/b
#define name3(a,b,c)		a/**/b/**/c
#define name4(a,b,c,d)		a/**/b/**/c/**/d

#endif

#define declare(a,t)		name2(a,declare)(t)
#define implement(a,t)		name2(a,implement)(t)
#define declare2(a,t1,t2)	name2(a,declare2)(t1,t2)
#define implement2(a,t1,t2)	name2(a,implement2)(t1,t2)

#endif

#endif // QGENERIC_H
