/**********************************************************************
** $Id: qlabel.h,v 2.0 1996/09/24 10:16:18 agulbra Exp $
**
** Definition of QLabel widget class
**
** Created : 941215
**
** Copyright (C) 1992-1996 Troll Tech AS.  All rights reserved.
**
** This file is part of the non-commercial distribution of Qt 1.0
** see the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** (This file differs from the commercial version of Qt only by this comment.)
**
*****************************************************************************/

#ifndef QLABEL_H
#define QLABEL_H

#include "qframe.h"


class QLabel : public QFrame
{
    Q_OBJECT
public:
    QLabel( QWidget *parent=0, const char *name=0, WFlags f=0 );
    QLabel( const char *text, QWidget *parent=0, const char *name=0,
	    WFlags f=0 );
   ~QLabel();

    const char *text()		const	{ return ltext; }
    QPixmap    *pixmap()	const	{ return lpixmap; }

    int		alignment()	const	{ return align; }
    void	setAlignment( int );
    int		margin()	const	{ return extraMargin; }
    void	setMargin( int );

    bool	autoResize()	const	{ return autoresize; }
    void	setAutoResize( bool );
    QSize	sizeHint() const;

public slots:
    void	setText( const char * );
    void	setPixmap( const QPixmap & );
    void	setNum( int );
    void	setNum( double );

protected:
    void	drawContents( QPainter * );

private:
    void	updateLabel();
    QString	ltext;
    QPixmap    *lpixmap;
    int		extraMargin;
    int		align;
    bool	autoresize;

private:	// Disabled copy constructor and operator=
    QLabel( const QLabel & ) {}
    QLabel &operator=( const QLabel & ) { return *this; }
};


#endif // QLABEL_H
