.TH gk_miniText n "25 August 1995" "GroupKit"
.SH NAME
gk_miniText \- Create a miniature text view
.SH SYNOPSIS
.TP 
\fBgk_miniText \fI pathName \fR?\fIoptions\fR?

.SH "STANDARD OPTIONS"
.nf
.ta 4c 8c 12c
.VS
\fBbackground	insertBackground	selectBackground	tabs
\fBborderWidth	insertBorderWidth	selectBorderWidth	takeFocus
\fBcursor	insertOffTime	selectForeground	xScrollCommand
\fBexportSelection	insertOnTime	setGrid	yScrollCommand
\fBforeground	insertWidth	spacing1	width
\fBheight	padX	spacing2
\fBhighlightColor	padY	spacing3
\fBhighlightThickness	relief	state
.VE
.fi

See the ``options'' manual entry for details on the standard options.
.br
See the ``text'' manual entry for details on the inherited options.

.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.nf
Name:	\fBadjust\fR
Class:	\fBAdjust\fR
Command-Line Switch:	\fB\-adjust\fR
.fi
.IP
Specifies whether or not the view should be adjusted automatically
when the local user's highlighted portion is moved.  Valid values
are any Tk boolean values, the default value is true.  If the value
is true then the local user's highlighted portion is kept in view.
If the value is false then the view may or may not contain the local
user's highlighted portion.
.LP

.ta 4c
.nf
Name:	\fBcolor\fR
Class:	\fBColor\fR
Command-Line Switch:	\fB\-color\fR
.fi
.IP
Specifies the color of the highlighted portion in the miniature view
for the local user.  Default value is either the current value stored of
\fIuserprefs color\fR, this is usually specified in the \fI.groupkitrc\fR
file. Any valid Tk color may be used with this option.
.LP

.ta 4c
.nf
Name:	\fBtextid\fR
Class:	\fBTextId\fR
Command-Line Switch:	\fB\-textid\fR
.fi
.IP
Specifies the identifier for the miniature text environment.  Miniature
views used to represent different documents should have different
textid values - unexpected results may occur if they are the same.
The default value is ``gkMiniText''.
.LP

.ta 4c
.nf
Name:	\fBviewScroll\fR
Class:	\fBViewScroll\fR
Command-Line Switch:	\fB\-viewscroll\fR
.fi
.IP
Specifies a boolean value that determines whether or not enable the
local users view indicator (highlighted portion) can be scrolled/moved.
.LP

.ta 4c
.nf
Name:	\fBxScrollCommand\fR
Class:	\fBScrollCommand\fR
Command-Line Switch:	\fB\-xviewscrollcommand\fR
.fi
.IP
Specifies the prefix of a Tcl command to invoke to change
the xview in the widget associated with the miniText.
When a user requests a view change by manipulating their
highlighted portion, a Tcl command is invoked.  The \fI-viewscroll\fR 
option must be true in order to allow manipulation of the
highlighted portion.  The actual Tcl
command invoked consists of this option followed by \fImovto\fR and
a number.  The number is a fraction between 0 and 1, which
indicates the position in the document which corresponds to
the left side of the highlighted section.  This operates similar
to the scrollbar \fI-command\fR option.  
.LP

.ta 4c
.nf
Name:	\fByScrollCommand\fR
Class:	\fBScrollCommand\fR
Command-Line Switch:	\fB\-yviewscrollcommand\fR
.fi
.IP
Specifies the prefix of a Tcl command to invoke to change
the yview in the widget associated with the miniText.
When a user requests a view change by manipulating their
highlighted portion, a Tcl command is invoked.  The \fI-viewscroll\fR 
option must be true in order to allow manipulation of the
highlighted portion.  The actual Tcl
command invoked consists of this option followed by \fImovto\fR and
a number.  The number is a fraction between 0 and 1, which
indicates the position in the document which corresponds to
the left side of the highlighted section.  This operates similar
to the scrollbar \fI-command\fR option.  
.LP

.SH DESCRIPTION
The gk_miniText widget is a specialized text widget that miniaturizes
the text and has highlighted portions.  There is a highlighted
for each user and they are used to what the user is currently
viewing.  Movement of the highlighted sections is controlled by the 
widget commands.

.SH "WIDGET COMMAND"
The \fBgk_miniText\fR command creates a new Tcl command whose name is
\fIpathName\fR.  This command may be used to invoke various operations
on the widget.  It has the following general form:
.IP
\fIpathName option \fR?\fIarg arg ...\fR?
.LP
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.  Any of the commands that can be used with the Tk text widget
may be used, for further details see the ``text'' manual entry.
The following additional commands are possible for gk_miniText widgets:
.TP

\fIpathName \fBadduser \fItextid userid coordinates\fR
Add a user, highlighted portion, to the miniText.  This command is 
needed in order to operate with the ``gk_views'' widget and will not
be needed in a typical application.  The \fItextid\fR is the value
of the \fI-textid\fR option.  The \fIuserid\fR is a unique
string that identifies a particular user, typically the user number
assigned to the user be GroupKit is used.  The \fIcoordinates\fR are
numbers between 0 and 1 that specify where to place the highlighted
portion, which correspond respectively to the left top right left 
sides of the highlighted portion.  The numbers are fractions like
those used by the \fIxview\fR and \fIyview\fR commands.
.TP

\fIpathName \fBattributechanged \fI\fR
.TP

\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBgk_miniText\fR
command.
.TP

\fIpathName \fBcget \fIoption\fR
Returns  the  current value of the configuration option
given by option.  Option may have  any  of  the  values
accepted by the text command.
.TP

\fIpathName \fBdelete \fIindex1 ?index2?\f
This command is essentially the Tk text widget \fIdelete\fR command.
So for its exact  usage refer to the ``text'' manual entry.  The
difference is that since the miniature views state is normally 
disabled this command will first change the state to normal,
delete the text, then turn the state back to disabled.
.TP

\fIpathName \fBdeleteuser \fItextid userid\fR
Delete a user, highlighted portion, from the miniText.  This command is 
needed in order to operate with the ``gk_views'' widget and will not
be needed in a typical application.  The \fItextid\fR is the value
of the \fI-textid\fR option.  The \fIuserid\fR is a unique
string that identifies a particular user, typically the user number
assigned to the user be GroupKit is used, and is the same as the
one provided in the \fIadduser\fR command.
.TP

\fIpathName \fBinsert \fIindex1 chars "tagList chars tagList ...?\fR
This command is essentially the Tk text widget \fIinsert\fR command.
So for its exact  usage refer to the ``text'' manual entry.  The
difference is that since the miniature views state is normally 
disabled this command will first change the state to normal,
insert the text, then turn the state back to disabled.
.TP

\fIpathName \fBminixview \fI?left right?\fR
This command is used to query and change the horizontal position of
the highlighted portion for the local user.  The operation of this
command is much like the \fIxview\fR command.  If no arguments are
specified then it returns a list containing two elements.  Each element
is a real fraction between 0 and 1; together they describe the portion
of the highlighted horizontal span.  If the \fIleft\fR and \fIright\fR
arguments are specified then the highlighted portion is moved to these
position.  \fILeft\fR and \fIright\fR are expected to be real fractions
between 0 and 1, similar to the values passed to scrollbars via the
-xscrollcommand option. If the \Ileft\fR argument is specified then
\fIright\fR must be specified too.  Finally, the view is adjusted to
make sure that the highlighted portion is always visible.
.TP

\fIpathName \fBminiyview \fI?top bottom?\fR
This command is used to query and change the vertical position of
the highlighted portion for the local user.  The operation of this
command is much like the \fIyview\fR command.  If no arguments are
specified then it returns a list containing two elements.  Each element
is a real fraction between 0 and 1; together they describe the portion
of the highlighted horizontal span.  If the \fItop\fR and \fIbottom\fR
arguments are specified then the highlighted portion is moved to these
position.  \fITop\fR and \fIbottom\fR are expected to be real fractions
between 0 and 1, similar to the values passed to scrollbars via the
-xscrollcommand option. If the \Itop\fR argument is specified then
\fIbottom\fR must be specified too.  Finally, the view is adjusted to
make sure that the highlighted portion is always visible.
.TP

\fIpathName \fBmoveuser \fItextid userid coordinates\fR
Move a user, highlighted portion, on the miniText widget.  This command 
is needed in order to operate with the ``gk_views'' widget and will not
be needed in a typical application.  The \fItextid\fR is the value
of the \fI-textid\fR option.  The \fIuserid\fR is a unique
string that identifies a particular user, typically the user number
assigned to the user be GroupKit is used and will be the same as the
value given to the \fIadduser\fR command.  The \fIcoordinates\fR are
numbers between 0 and 1 that specify where to place the highlighted
portion, which correspond respectively to the left top right left 
sides of the highlighted portion.  The numbers are fractions like
those used by the \fIxview\fR and \fIyview\fR commands.
.TP

\fIpathName \fBsee \fIindex\fR
Adjust the view of the window so that the position given by \fIindex\fR
is completely visible.  If \fIindex\fR is already visible then the
command does nothing.  If \fIindex\fR is not visible the view is adjusted
just enough to make \fIindex\fR visible at the edge of it.  This differs
from the \fIsee\fR command for the text widget.  This command adjusts
the view based on the \fIindex\fR whereas the text widget adjust the
view based on the character given by \fIindex\fR.


.SH "DEFAULT BINDINGS"
Mouse button 1 over a highlighted portion will display the 
name of the user associated with the particular highlighted portion.
Mouse button 3 controls the scrolling of the highlighed portion for
the local users only - this is turned off or on based on the value
given for the \fI-viewscroll\fR option.
Other bindings include the normal Tk text widget bindings, see 
the ``text'' manual entry for more details.

.SH NOTE
This widget is built using the GroupKit class builder; see the
GroupKit User Manual for more information.
This widget also relies on the gk_views widget for much of it's
operation, see the manual page ``gk_views (n)'' for details.

.PP
The highlighted portions are implemented with tags.  The background
color for tags can only be changed if there is text in that portion
of the tag.  This is why the highlighted portions are often have more
than one pieced instead of one colored square.  Also tabs in inserted
text are treated as a single character instead of n, this can cause
some display problems.
.PP
Do too the amount of time required to do some of the calculations, the
scrolling can be slow.  If this widget is used with a scrollbar it can
cause the scrollbar to act like it was moved twice instead of once  In
order to prevent this from happening change the \fI-repeatdelay\fR option
for the scrollbar to something larger, 1000 should work.

.SH AUTHOR
Shannon Jaeger (jaeger@cpsc.ucalgary.ca)
