.TH gk_schedule n "9 Feb 1996" "GroupKit"
.SH NAME
gk_schedule, gk_cancelScheduled \- 
support periodic execution of commands
.SH SYNOPSIS
.TP 
\fBgk_schedule\fI tag command ?timer?\fR
.TP
\fBgk_cancelScheduled \fItag\fR

.SH DESCRIPTION
These commands allow you to deal with executing repetitive
commands (such as move object messages) so that commands do
not cause a backlog.  Commands (such as an update) are added
to a queue without duplicates, so only a single command will
be executed within a given time interval (default 1/10 second).

This facility provides a convenient front end to Tk's after
command, while avoiding queueing up multiple redundant messages.

.SH COMMANDS

.TP 
\fBgk_schedule\fI tag command ?timer?\fR
Schedule \fBcommand\fR to be executed sometime in the future.
If there is already a command with the same \fBtag\fR, do not
add this command to the queue.  By default, commands will be
queued up to execute in 100 milliseconds, but this can be
changed using the \fBtimer\fR parameter.

.TP
\fBgk_cancelScheduled \fItag\fR
Cancel a previously scheduled command, identified by \fBtag\fR,
if it has not already been run.

.SH AUTHOR
Mark Roseman (roseman@cpsc.ucalgary.ca)
