/*	Copyright (C) 1995 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * As a special exception, Free Software Foundation gives permission
 * for additional uses of the text contained in its release of this library.
 *
 * The exception is that, if you link this library with other files
 * to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking this library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by 
 * Free Software Foundation as part of this library.  If you copy
 * code from other releases distributed under the terms of the GPL into a copy of
 * this library, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from such code.
 *
 * If you write modifications of your own for this library, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.  
 */

#include <stdio.h>
#include "_scm.h"




/* {Weak Vectors}
 *
 * These are vectors very similar to ordinary scheme vectors, but their
 * slots are not marked during garbage collection.  When an object is
 * garbage collected, it's slot is marked as dead (SCM_UNDEFINED).
 * Dead slots can be freed by calling `scm_dead_slots' which returns a
 * list of the indices which were freed.
 */



PROC (s_make_weak_vector, "make-weak-vector", 1, 1, 0, scm_make_weak_vector);
#ifdef __STDC__
SCM
scm_make_weak_vector (SCM k, SCM fill)
#else
SCM
scm_make_weak_vector (k, fill)
     SCM k;
     SCM fill;
#endif
{
  SCM v;
  v = scm_make_vector (scm_sum (k, MAKINUM (1)), fill, SCM_UNDEFINED);
  DEFER_INTS;
  SETLENGTH(v, INUM (k), tc7_wvect);
  VELTS(v)[0] = (SCM)0;
  VELTS(v) = VELTS(v) + 1;
  ALLOW_INTS;
  return v;
}


PROC (s_weak_vector, "weak-vector", 0, 0, 1, scm_weak_vector);
#ifdef __STDC__
SCM
scm_weak_vector (SCM l)
#else
SCM
scm_weak_vector (l)
     SCM l;
#endif
{
  SCM res;
  register SCM *data;
  long i;

  i = scm_ilength (l);
  ASSERT (i >= 0, l, ARG1, s_weak_vector);
  res = scm_make_weak_vector (MAKINUM (i), UNSPECIFIED);
  data = VELTS (res);
  for(; NIMP (l); l = CDR (l)) *data++ = CAR (l);
  return res;
}


PROC (s_weak_vector_p, "weak-vector?", 1, 0, 0, scm_weak_vector_p);
#ifdef __STDC__
SCM
scm_weak_vector_p (SCM x)
#else
SCM
scm_weak_vector_p (x)
     SCM x;
#endif
{
  return ((NIMP (x) && WVECTP (x) && !SCM_IS_WHVEC (x))
	  ? BOOL_T
	  : BOOL_F);
}



PROC (s_weak_vector_length, "weak-vector-length", 1, 0, 0, scm_weak_vector_length);
#ifdef __STDC__
SCM
scm_weak_vector_length (SCM v)
#else
SCM
scm_weak_vector_length (v)
     SCM v;
#endif
{
  ASSERT (NIMP (v) && WVECTP (v), v, ARG1, s_weak_vector_length);
  return MAKINUM (LENGTH (v));
}





PROC (s_weak_vector_ref, "weak-vector-ref", 2, 0, 0, scm_weak_vector_ref);
#ifdef __STDC__
SCM
scm_weak_vector_ref (SCM v, SCM k)
#else
SCM
scm_weak_vector_ref (v, k)
     SCM v;
     SCM k;
#endif
{
  ASSERT (NIMP (v) && WVECTP (v), v, ARG1, s_weak_vector_ref);
  ASSERT (INUMP (k), k, ARG2, s_weak_vector_ref);
  ASSERT ((INUM (k) < LENGTH (v)) && (INUM (k) >= 0), k, OUTOFRANGE, s_weak_vector_ref);
  return VELTS (v)[((long) INUM (k))];
}



PROC (s_weak_vector_set_x, "weak-vector-set!", 3, 0, 0, scm_weak_vector_set_x);
#ifdef __STDC__
SCM
scm_weak_vector_set_x (SCM v, SCM k, SCM obj)
#else
SCM
scm_weak_vector_set_x (v, k, obj)
     SCM v;
     SCM k;
     SCM obj;
#endif
{
  ASSERT (NIMP (v) && WVECTP (v), v, ARG1, s_weak_vector_set_x);
  ASSERT (INUMP (k), k, ARG2, s_weak_vector_set_x);
  ASSERT ((INUM (k) < LENGTH (v)) && (INUM (k) >= 0), k, OUTOFRANGE, s_weak_vector_set_x);
  VELTS (v)[((long) INUM (k))] = obj;
  return UNSPECIFIED;
}






PROC (s_make_weak_hash_table, "make-weak-hash-table", 1, 0, 0, scm_make_weak_hash_table);
#ifdef __STDC__
SCM
scm_make_weak_hash_table (SCM k)
#else
SCM
scm_make_weak_hash_table (k)
     SCM k;
#endif
{
  SCM v;
  ASSERT (INUMP (k), k, ARG1, s_make_weak_hash_table);
  v = scm_make_weak_vector (k, EOL);
  DEFER_INTS;
  VELTS (v)[-1] = 1;
  ALLOW_INTS;
  return v;
}

PROC (s_weak_hash_table_p, "weak-hash-table?", 1, 0, 0, scm_weak_hash_table_p);
#ifdef __STDC__
SCM
scm_weak_hash_table_p (SCM x)
#else
SCM
scm_weak_hash_table_p (x)
     SCM x;
#endif
{
  return ((NIMP (x) && WVECTP (x) && SCM_IS_WHVEC(x))
	  ? BOOL_T
	  : BOOL_F);
}

PROC (s_weak_hash_table_length, "weak-hash-table-length", 1, 0, 0, scm_weak_hash_table_length);
#ifdef __STDC__
SCM
scm_weak_hash_table_length (SCM v)
#else
SCM
scm_weak_hash_table_length (v)
     SCM v;
#endif
{
  ASSERT (NIMP (v) && WHVECTP (v), v, ARG1, s_weak_hash_table_length);
  return MAKINUM (LENGTH (v));
}

PROC (s_weak_hash_table_ref, "weak-hash-table-ref", 2, 0, 0, scm_weak_hash_table_ref);
#ifdef __STDC__
SCM
scm_weak_hash_table_ref (SCM v, SCM k)
#else
SCM
scm_weak_hash_table_ref (v, k)
     SCM v;
     SCM k;
#endif
{
  ASSERT (NIMP (v) && WHVECTP (v), v, ARG1, s_weak_hash_table_ref);
  ASSERT (INUMP (k), k, ARG2, s_weak_hash_table_ref);
  ASSERT ((INUM (k) < LENGTH (v)) && (INUM (k) >= 0), k, OUTOFRANGE, s_weak_hash_table_ref);
  return VELTS (v)[((long) INUM (k))];
}


PROC (s_weak_hash_table_set_x, "weak-hash-table-set!", 3, 0, 0, scm_weak_hash_table_set_x);
#ifdef __STDC__
SCM
scm_weak_hash_table_set_x (SCM v, SCM k, SCM obj)
#else
SCM
scm_weak_hash_table_set_x (v, k, obj)
     SCM v;
     SCM k;
     SCM obj;
#endif
{
  ASSERT (NIMP (v) && WHVECTP (v), v, ARG1, s_weak_hash_table_set_x);
  ASSERT (INUMP (k), k, ARG2, s_weak_hash_table_set_x);
  ASSERT ((INUM (k) < LENGTH (v)) && (INUM (k) >= 0), k, OUTOFRANGE, s_weak_hash_table_set_x);
  VELTS (v)[((long) INUM (k))] = obj;
  return UNSPECIFIED;
}

#ifdef __STDC__
SCM
scm_weak_hash_get_handle (SCM table, SCM obj)
#else
SCM
scm_weak_hash_get_handle (table, obj)
     SCM table;
     SCM obj;
#endif
{
  int k;
  ASSERT (NIMP (table) && WHVECTP (table), table, ARG1, s_weak_vector_set_x);
  if (LENGTH (table) == 0)
    return EOL;
  k = WHASHFUNC (obj, LENGTH (table));
  return scm_assq (obj, VELTS (table)[k]);
}

#ifdef __STDC__
SCM
scm_weak_hash_create_handle (SCM table, SCM obj)
#else
SCM
scm_weak_hash_create_handle (table, obj)
     SCM table;
     SCM obj;
#endif
{
  int k;
  SCM it;

  ASSERT (NIMP (table) && WHVECTP (table), table, ARG1, s_weak_vector_set_x);
  if (LENGTH (table) == 0)
    return EOL;
  k = WHASHFUNC (obj, LENGTH (table));
  it = scm_assq (obj, VELTS (table)[k]);
  if (NIMP (it))
    return it;
  VELTS(table)[k] = scm_acons (obj, BOOL_F, VELTS (table)[k]);
  return VELTS(table)[k];
}

#ifdef __STDC__
SCM 
scm_weak_hash_insert (SCM table, SCM obj, SCM val)
#else
SCM 
scm_weak_hash_insert (table, obj, val)
     SCM table;
     SCM obj;
     SCM val;
#endif
{
  int k;
  SCM it;

  ASSERT (NIMP (table) && WHVECTP (table), table, ARG1, s_weak_vector_set_x);
  if (LENGTH (table) == 0)
    return EOL;
  k = WHASHFUNC (obj, LENGTH (table));
  it = scm_assq (obj, VELTS (table)[k]);
  if (IMP (it))
    VELTS(table)[k] = scm_acons (obj, val, VELTS (table)[k]);
  else
    SETCDR (it, val);
  return UNSPECIFIED;
}

#ifdef __STDC__
SCM 
scm_weak_hash_lookup (SCM table, SCM obj)
#else
SCM 
scm_weak_hash_lookup (table, obj)
     SCM table;
     SCM obj;
#endif
{
  int k;
  SCM it;

  ASSERT (NIMP (table) && WHVECTP (table), table, ARG1, s_weak_vector_set_x);
  if (LENGTH (table) == 0)
    return EOL;
  k = WHASHFUNC (obj, LENGTH (table));
  it = scm_assq (obj, VELTS (table)[k]);
  if (IMP (it))
    return BOOL_F;
  else
    return CDR (it);
}









#ifdef __STDC__
void
scm_init_weaks (void)
#else
void
scm_init_weaks ()
#endif
{
#include "weaks.x"
}

