/**
 *
 * $Id: VendorSEP.h,v 1.9 1996/04/09 08:56:37 u27113 Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_VENDOR_E_P_H
#define XM_VENDOR_E_P_H

#include <Xm/XmP.h>
#include <Xm/VendorS.h>
#include <Xm/MwmUtil.h>
#include <Xm/ExtObjectP.h>
#include <Xm/DesktopP.h>
#include <Xm/ShellEP.h>

#ifndef XmIsVendorShellExt
#define XmIsVendorShellExt(w) XtIsSubclass(w, xmVendorShellExtObjectClass)
#endif

typedef struct _XmVendorShellExtRec *XmVendorShellExtObject;
typedef struct _XmVendorShellExtClassRec *XmVendorShellExtObjectClass;
extern WidgetClass xmVendorShellExtObjectClass;

typedef struct _XmVendorShellExtClassPart{
    XtCallbackProc delete_window_handler;
    XtCallbackProc offset_handler;
    XtPointer extension;
} XmVendorShellExtClassPart, *XmVendorShellExtClassPartPtr;

typedef struct _XmVendorExtClassRec{
    ObjectClassPart object_class;
    XmExtClassPart ext_class;
    XmDesktopClassPart desktop_class;
    XmShellExtClassPart shell_class;
    XmVendorShellExtClassPart vendor_class;
} XmVendorShellExtClassRec;

typedef struct {
	Atom		property, protocol;
	int		num_callbacks;
	Boolean		active;
	XtCallbackList	cbl;
} _XmVendorProtocols;

typedef struct {
	Widget		w;
	String		s;
} _XmAcceleratorStruct;

typedef struct {
    XmFontList default_font_list;
    unsigned char focus_policy;
    XmFocusData focus_data;
    unsigned char delete_response;
    unsigned char unit_type;
    MwmHints mwm_hints;
    MwmInfo mwm_info;
    String mwm_menu;
    XtCallbackList focus_moved_callback;

    Widget old_managed;
    Position xAtMap, yAtMap, xOffset, yOffset;
    unsigned long lastOffsetSerial;
    unsigned long lastMapRequest;
    Boolean externalRepoosition;
    unsigned char mapStyle;
    XtCallbackList realize_callback;
    XtGrabKind grab_kind;
    unsigned char audible_warning;
    XmFontList button_font_list;
    XmFontList label_font_list;
    XmFontList text_font_list;
    String input_method_string;
    String preedit_type_string;
    unsigned int light_threshold;
    unsigned int dark_threshold;
    unsigned int foreground_threshold;
    unsigned int im_height;
    XtPointer im_info;
    Boolean im_vs_height_set;

/* LessTif Debugging support */
    String	debug_sources;

/* Protocols */
    _XmVendorProtocols	*protocols;
} XmVendorShellExtPart, *XmVendorShellExtPartPtr;

extern XmVendorShellExtClassRec  xmVendorShellExtClassRec;

typedef struct _XmVendorShellExtRec {
    ObjectPart object;
    XmExtPart ext;
    XmDesktopPart desktop;
    XmShellExtPart shell;
    XmVendorShellExtPart vendor;
} XmVendorShellExtRec;

#define VSEP_DefaultFontList(o) \
	(((XmVendorShellExtObject)o)->vendor.default_font_list)

#define VSEP_FocusPolicy(o) \
	(((XmVendorShellExtObject)o)->vendor.focus_policy)

#define VSEP_FocusData(o) \
	(((XmVendorShellExtObject)o)->vendor.focus_data)

#define VSEP_DeleteResponse(o) \
	(((XmVendorShellExtObject)o)->vendor.delete_response)

#define VSEP_UnitType(o) \
	(((XmVendorShellExtObject)o)->vendor.unit_type)

#define VSEP_MwmHints(o) \
	(((XmVendorShellExtObject)o)->vendor.mwm_hints)

#define VSEP_MwmInfo(o) \
	(((XmVendorShellExtObject)o)->vendor.mwm_info)

#define VSEP_MwmMenu(o) \
	(((XmVendorShellExtObject)o)->vendor.mwm_menu)

#define VSEP_FocusMovedCallback(o) \
	(((XmVendorShellExtObject)o)->vendor.focus_moved_callback)

#define VSEP_OldManaged(o) \
	(((XmVendorShellExtObject)o)->vendor.old_managed)

#define VSEP_XAtMap(o) \
	(((XmVendorShellExtObject)o)->vendor.xAtMap)

#define VSEP_YAtMap(o) \
	(((XmVendorShellExtObject)o)->vendor.yAtMap)

#define VSEP_XOffset(o) \
	(((XmVendorShellExtObject)o)->vendor.xOffset)

#define VSEP_YOffset(o) \
	(((XmVendorShellExtObject)o)->vendor.yOffset)

#define VSEP_LastOffsetSerial(o) \
	(((XmVendorShellExtObject)o)->vendor.lastOffsetSerial)

#define VSEP_LastMapRequest(o) \
	(((XmVendorShellExtObject)o)->vendor.lastMapRequest)

#define VSEP_ExternalReposition(o) \
	(((XmVendorShellExtObject)o)->vendor.externalReposition)

#define VSEP_MapStyle(o) \
	(((XmVendorShellExtObject)o)->vendor.mapStyle)

#define VSEP_RealizeCallback(o) \
	(((XmVendorShellExtObject)o)->vendor.realize_callback)

#define VSEP_GrabKind(o) \
	(((XmVendorShellExtObject)o)->vendor.grab_kind)

#define VSEP_AudibleWarning(o) \
	(((XmVendorShellExtObject)o)->vendor.audible_warning)

#define VSEP_LabelFontList(o) \
	(((XmVendorShellExtObject)o)->vendor.label_font_list)

#define VSEP_ButtonFontList(o) \
	(((XmVendorShellExtObject)o)->vendor.button_font_list)

#define VSEP_TextFontList(o) \
	(((XmVendorShellExtObject)o)->vendor.text_font_list)

#define VSEP_InputMethodString(o) \
	(((XmVendorShellExtObject)o)->vendor.input_method_string)

#define VSEP_PreeditTypeString(o) \
	(((XmVendorShellExtObject)o)->vendor.preedit_type_string)

#define VSEP_LightThreshold(o) \
	(((XmVendorShellExtObject)o)->vendor.light_threshold)

#define VSEP_DarkThreshold(o) \
	(((XmVendorShellExtObject)o)->vendor.dark_threshold)

#define VSEP_ForegroundThreshold(o) \
	(((XmVendorShellExtObject)o)->vendor.foreground_threshold)

#define VSEP_ImHeight(o) \
	(((XmVendorShellExtObject)o)->vendor.im_height)

#define VSEP_ImInfo(o) \
	(((XmVendorShellExtObject)o)->vendor.im_info)

#define VSEP_ImHeightSet(o) \
	(((XmVendorShellExtObject)o)->vendor.im_vs_height_set)

/*
 * protos
 */
unsigned char _XmGetAudibleWarning(Widget w);
char *_XmGetIconPixmapName(void);
void _XmClearIconPixmapName(void); 

#ifdef __cplusplus
};
#endif

/* This is not the right place for this */
#define	XmNdebugSources	"debugSources"
#define	XmCDebugSources	"DebugSources"

/* Find the VendorShell Extension Object */
extern Widget _LtFindVendorExt(Widget);

#endif /* XM_VENDOR_E_P_H */
