/**
 *
 * $Id: DebugUtil.c,v 1.8 1996/04/22 22:54:29 miers Exp $
 * 
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: DebugUtil.c,v 1.8 1996/04/22 22:54:29 miers Exp $";

#include <LTconfig.h>
#include <X11/Xos.h>
#include <Xm/GadgetP.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <X11/Xresource.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <Xm/VendorSEP.h>

/* Protect ourselves (for now) */
#ifdef	LESSTIF_PRODUCTION
#undef	LESSTIF_PRODUCTION
#endif

static char *_XdbState(Widget w)
{
	if (XtIsRealized(w)) {
		if (XtIsManaged(w))
			return "realized, managed";
		else
			return "realized, not managed";
	} else {
		if (XtIsManaged(w))
			return "not realized, not managed";
		else
			return "not realized, not managed";
	}
}

static void _XdbPrintTree(Widget w, int level)
{
	int	i;
	CompositeWidget	cw = (CompositeWidget)w;

	if (w == NULL)
		return;

	for (i=0; i<level; i++)
		fprintf(stderr, "\t");
	fprintf(stderr, "%s ", XtName(w));
	fprintf(stderr, "(%s) geo %d %d %d %d",
		w->core.widget_class->core_class.class_name,
		XtX(w), XtY(w), XtWidth(w), XtHeight(w));
#ifdef	PRINT_STATE
	fprintf(stderr, " state: %s %s",
		_XdbState(w), w->core.mapped_when_managed ? "mwm": "");
#endif
	fprintf(stderr, "\n");
	if (XtIsSubclass(w, compositeWidgetClass))
		for (i=0; i<cw->composite.num_children; i++)
			_XdbPrintTree(cw->composite.children[i], level+1);
}

void XdbPrintTree(Widget w)
{
	_XdbPrintTree(w, 0);
}

void XdbPrintCompleteTree(Widget w)
{
	Widget	ww = w;

	while (ww) {
		w = ww;
		ww = XtParent(w);
	}

	_XdbPrintTree(w, 0);
}

char * XdbGeometryResult2String(XtGeometryResult r)
{
	switch (r) {
	case XtGeometryYes:	return "Yes";
	case XtGeometryNo:	return "No";
	case XtGeometryAlmost:	return "Almost";
	case XtGeometryDone:	return "Done";
	default:		return "(invalid geometry result)";
	}
}

char *
XdbAttachment2String(int a)
{
	switch (a) {
	case XmATTACH_FORM:		return "XmATTACH_FORM";
	case XmATTACH_OPPOSITE_FORM:	return "XmATTACH_OPPOSITE_FORM";
	case XmATTACH_WIDGET:		return "XmATTACH_WIDGET";
	case XmATTACH_OPPOSITE_WIDGET:	return "XmATTACH_OPPOSITE_WIDGET";
	case XmATTACH_NONE:		return "XmATTACH_NONE";
	case XmATTACH_POSITION:		return "XmATTACH_POSITION";
	default :			return "(invalid attachment)";
	}
}

/*
 * See if 'fn' is one of the elements in 'l'.
 * L is a colon-separated list of source files.
 * The ".c" suffix for sources is not required (i.e. Form is equivalent
 * to Form.c).
 */
static Boolean
ValidateSource(char *fn, char *l)
{
#ifndef	LESSTIF_PRODUCTION
	char	*s, *p, *q;
	int	i = strlen(fn);

	if (l == NULL)
		return False;

	if (strcmp(l, "all") == 0)
		return True;

	s = l;
	while ((p = strstr(s, fn)) != NULL) {
		q = p + i;
		if (*q == '\0' || *q == '.' || *q == ':')
			return True;
		s = q;
	}
#endif
	return False;
}

/*
 * This is the new style debugging support routine for LessTif.
 *
 * It allows us to choose at run time which sources should spit out
 * their guts.
 */
char *_XdbFindDebugSources(Widget w)
{
	Widget	q;
	XmVendorShellExtObject	ve;

	if (w == (Widget)0)
		return getenv("DEBUGSOURCES");

	q = _LtFindVendorExt(w);
	if (q == NULL)
		return getenv("DEBUGSOURCES");
	ve = (XmVendorShellExtObject)q;
	if (ve->vendor.debug_sources == NULL)
		return getenv("DEBUGSOURCES");

	return ve->vendor.debug_sources;
}

void XdbDebug(char *fn, Widget w, char *fmt, ...)
{
#ifndef LESSTIF_PRODUCTION
	va_list	ap;
	char	*dbs = _XdbFindDebugSources(w);

	if (ValidateSource(fn, dbs)) {
		if (w)
		    fprintf(stderr, "%s %s: ",
			w->core.widget_class->core_class.class_name,
			XtName(w));
		else
		    fprintf(stderr, "(null widget): ");
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
#endif
}

void XdbDebug2(char *fn, Widget w, Widget c, char *fmt, ...)
{
#ifndef LESSTIF_PRODUCTION
	va_list	ap;
	char	*dbs = _XdbFindDebugSources(w);

	if (ValidateSource(fn, dbs)) {
		if (w && c)
		    fprintf(stderr, "%s %s (child %s): ",
			w->core.widget_class->core_class.class_name,
			XtName(w), XtName(c));
		else
		    fprintf(stderr, "(null widget): ");
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
#endif
}

void XdbDebug0(char *fn, Widget w, char *fmt, ...)
{
#ifndef LESSTIF_PRODUCTION
	va_list	ap;
	char	*dbs = _XdbFindDebugSources(w);

	if (ValidateSource(fn, dbs)) {
		va_start(ap, fmt);
		vfprintf(stderr, fmt, ap);
		va_end(ap);
	}
#endif
}

Boolean XdbInDebug(char *fn, Widget w)
{
#ifdef	LESSTIF_PRODUCTION
	return False;
#else
	return ValidateSource(fn, _XdbFindDebugSources(w));
#endif
}
