/* d_diode.h		-*- C++ -*-
 $Header: /al/acs/src/RCS/d_diode.h,v 9.21 95/10/21 18:10:38 al Exp $
 * data structures and defaults for diode model.
 */
#ifndef D_DIODE_H
#define D_DIODE_H
#include "e_subckt.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
class DEV_ADMITTANCE;
class DEV_CAPACITANCE;
/*--------------------------------------------------------------------------*/
class MODEL_DIODE : public MODEL_BASE {
friend class DEV_DIODE;
public:
	MODEL_DIODE(const char *name = "");
	MODEL_DIODE(const MODEL_DIODE& p){assert(!"copy-model??");}
	CARD*	clone()const{return new MODEL_DIODE(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
protected:
  double	js;  /* is  */	/* saturation current (per area) */
  double	rs;		/* ohmic resistance (per area) */
  double	n;		/* emission coefficient */
  double	tt;		/* transit time */
  double	cjo;  /* cj  */	/* zero-bias jct capacitance (per area) */
  double	pb;   /* vj  */	/* junction potential */
  double	mj;   /* m   */	/* grading coefficient */
  double	eg;		/* activation energy */
  double	xti;		/* saturation-current temp. exp. */
  double	kf;		/* flicker noise coefficient */
  double	af;		/* flicker noise exponent */
  double	fc;		/* coef for fwd bis depl cap formula */
  double	bv;		/* reverse breakdown voltage */
  double	ibv;		/* current at reverse breakdown */
   				/* non-spice extensions */
  double	cjsw;		/* zero bias sidewall cap (per perim.) */
  double	mjsw;		/* sidewall grading coefficient */
  double	fcpb;		/* fc * pb */
};
/*--------------------------------------------------------------------------*/
class DIODE_COMMON : private COMPONENT_COMMON {
friend class DEV_DIODE;
friend class DEV_MOS;
	DIODE_COMMON();
	DIODE_COMMON(const DIODE_COMMON& p):COMPONENT_COMMON(p){*this = p;}
  char		modelname[LABELEN+1];
  double	is;		/* saturation current */
  double	rs;		/* series resistance */
  double	cj;		/* zero bias jct capacitance */
  double	cjsw;		/* zero bias sidewall capacitance */
  double	area;		/* area factor */
  double	perim;		/* perimeter factor */
  double	ic;		/* initial voltage */
  int		off;		/* flag: assume reverse biased */
  struct {
    unsigned	is:1,
		rs:1,
		cj:1,
		cjsw:1;
  } calc;
};
/*--------------------------------------------------------------------------*/
class DEV_DIODE : public BASE_SUBCKT {
friend class DEV_MOS;
public:
	DEV_DIODE();
	DEV_DIODE(const DEV_DIODE& p);
	~DEV_DIODE(){--Count;}
	CARD*	clone()const{return new DEV_DIODE(*this);}
	void	parse(CS&);
 	void	print(int,int)const;
	double	probe_tr_num(const char*)const;
	void	expand();
static	int	count(){return Count;}
private:
static	void	evaldiode(CARD*);
static	void	diodecap(CARD*);
private:
  enum region_t {INITOFF=-2, REVERSE=-1, UNKNOWN=0, FORWARD=1};
  region_t	region;		/* fwd, reverse, unknown */
  double	isat;		/* is adjusted for temp, etc. */
  double	gd;		/* conductance to pass to capacitor */
  DEV_ADMITTANCE*   Yj;		/* subckt elements, for probe */
  DEV_CAPACITANCE*  Cj;
  enum	{NUMNODES = 2};
  static int	Count;
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
